<?php declare(strict_types=1);

namespace Shop\Application\Catalog\CreateProduct;

use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;
use Shop\Domain\Product\Contracts\ProductEntityInterface;

class CreateProductCommand implements LoggerAwareInterface
{
    use LoggerAwareTrait;

    protected ProductEntityInterface|null $productEntity = null;

    public function __construct(private string $name,
                                private string $sku,
                                private float $price,
                                private ?string $description,
                                private array $images,
                                private int $categoryId,
                                private int $brandId,
                                private array $groupIds,
                                private array $positionCollection
    )
    {
        $this->logger = new NullLogger();
    }

    public function getLogger(): LoggerInterface
    {
        return $this->logger;
    }

    public function getPositionCollection(): array
    {
        return $this->positionCollection;
    }

    public function getGroupIds(): array
    {
        return $this->groupIds;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getSku(): string
    {
        return $this->sku;
    }

    public function getPrice(): float
    {
        return $this->price;
    }


    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getImages(): array
    {
        return $this->images;
    }

    public function getCategoryId(): int
    {
        return $this->categoryId;
    }

    public function getBrandId(): int
    {
        return $this->brandId;
    }

    public function getProductEntity(): ?ProductEntityInterface
    {
        return $this->productEntity;
    }

    public function setProductEntity(?ProductEntityInterface $productEntity): void
    {
        $this->productEntity = $productEntity;
    }


}