<?php declare(strict_types=1);

namespace Shop\Presentation\Modules\AdminPayments;

use ActiveTable\ColumnTable;
use Core\Form\NiftyControlBuilder;
use Core\ModuleController;
use DiamondTable\TableFactory;
use Shop\Infrastructure\Repositories\Payment\PaymentCriteria;
use Shop\Infrastructure\Repositories\Payment\PaymentRepository;
use Shop\Infrastructure\Repositories\PriceFile\PriceFileCriteria;

/**
* Description of AdminPayments
*
* @author Diamond Code Generator
*/
class AdminPayments extends ModuleController
{


    public function __construct(protected PaymentRepository $paymentRepository,
                                protected NiftyControlBuilder $controlBuilder,
                                protected TableFactory $tableFactory)
    {
    }

    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->paymentRepository, PaymentCriteria::create());

        $table
            ->setDefaultSortColumn('id', 'DESC')
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('title', 'Наименование'))
            )
            ->addColumn(
                (new ColumnTable('code', 'Идентификатор оплаты'))
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
                    ->setWidth(120)
            );

        $table
            ->addField(
                $this->controlBuilder->buildInput('title'),true
            )
            ->addField(
                $this->controlBuilder->buildInput('code'),true,'К коду будет привязан скрипт оплаты'
            )
        ;

        return $table->render();
    }
}               