<?php


namespace Shop\Infrastructure\Repositories\State;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\State\StateCollection;
use Shop\Infrastructure\Models\State\State;
use Shop\Infrastructure\Models\State\StateQuery;

class StateRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new State();
    }

    protected function createQuery(): ModelCriteria
    {
        return StateQuery::create();
    }

    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        // TODO: Implement modifyCriteria() method.
    }


    protected function createCollection(): CollectionInterface
    {
        return new StateCollection();
    }
}