<?php

namespace Shop\Infrastructure\Models\Category;

use Shop\Domain\ProductCategory\Contracts\ProductCategoryEntityInterface;
use Shop\Infrastructure\Models\Category\Base\Category as BaseCategory;

/**
 * Skeleton subclass for representing a row from the 'shop_categories' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 */
class Category extends BaseCategory implements ProductCategoryEntityInterface
{

    /**
     * @var int
     */
    protected $countChildrens = 0;

    protected $parentsLevel = 0;

    /**
     * @var int
     */
    protected $countProducts = 0;

    /**
     * @return int
     */
    public function getParentsLevel(): int
    {
        return $this->parentsLevel;
    }

    /**
     * @param int $parentsLevel
     * @return \Shop\Infrastructure\Models\Category\Category
     */
    public function setParentsLevel(int $parentsLevel): Category
    {
        $this->parentsLevel = $parentsLevel;
        return $this;
    }


    /**
     * @param int $count
     * @return Category
     */
    public function setCountChildrens(int $count): self
    {
        $this->countChildrens = $count;
        return $this;
    }

    /**
     * @return int
     */
    public function getCountChildrens(): int
    {
        return $this->countChildrens;
    }


    /**
     * @param int $count
     * @return Category
     */
    public function setCountProducts(int $count): self
    {
        $this->countProducts = $count;
        return $this;
    }

    /**
     * @return int
     */
    public function getCountProducts(): int
    {
        return $this->countProducts;
    }

    /**
     * @param string $name
     * @return string
     * @throws \Propel\Runtime\Exception\PropelException
     * @deprecated
     */
    public function getNameWithParent($name = " одежда, "): string
    {
        return ltrim(

            sprintf("%s%s%s", $this->getParentCategory() ? $this->getParentCategory()->getTitle() : null, $name, $this->getTitle())
            ,
            " -"
        );
    }

    /**
     *
     * @param type $name
     * @return type
     */
    public function getNameWithParentName($name = " / ")
    {

        if ($this->getParentCategory() && $this->getParentCategory()->getParentCategory()) {
            return ltrim(

                sprintf("%s / %s%s%s", $this->getParentCategory()->getParentCategory()->getTitle(), $this->getParentCategory() ? $this->getParentCategory()->getTitle() : null, $name, $this->getTitle())
                ,
                $name
            );
        }

        return ltrim(

            sprintf("%s%s%s", $this->getParentCategory() ? $this->getParentCategory()->getTitle() : null, $name, $this->getTitle())
            ,
            $name
        );
    }

}
