<?php


namespace Shop\Infrastructure\Repositories\OrderItem;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\OrderItem\Contracts\OrderItemCriteriaInterface;
use Shop\Domain\OrderItem\OrderItemCollection;
use Shop\Infrastructure\Models\OrderItem\OrderItem;
use Shop\Infrastructure\Models\OrderItem\OrderItemQuery;
use Shop\Infrastructure\Models\OrderType\OrderType;

class OrderItemRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    /**
     * @return EntityInterface|OrderItem
     */
    public static function createEntity(): EntityInterface
    {
        return new OrderItem();
    }

    protected function createQuery(): ModelCriteria
    {
        return OrderItemQuery::create();
    }

    /**
     * @param PaginationInterface|OrderItemCriteriaInterface $criteria
     * @param ModelCriteria|OrderItemQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dbCriteria
            ->_if($criteria->getFilterByOrderIds() !== null)
            ->filterByOrderId($criteria->getFilterByOrderIds())
            ->_endif()
            ->_if($criteria->getFilterByOrderCode()!==null)
            ->filterByOrderId((int)preg_replace('~.*-(\d+)$~is','$1',$criteria->getFilterByOrderCode()))
            ->_endif()
            ->_if($criteria->getSearchByName()!==null)
            ->filterByName('%' . $criteria->getSearchByName() . '%',Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getSearchByArticle()!==null)
            ->filterByArticle('%' . $criteria->getSearchByArticle() . '%',Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getSearchByBrand()!==null)
            ->filterByBrand('%' . $criteria->getSearchByBrand() . '%',Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getFilterByProviderId()!==null)
            ->filterByProviderId($criteria->getFilterByProviderId())
            ->_endif()
            ->_if($criteria->getFilterByStateId()!==null)
            ->filterByStateId($criteria->getFilterByStateId())
            ->_endif()
            //static filtere
            ->useOrderQuery()
            ->filterByTypeId(OrderType::TYPE_CUSTOMER_ORDER)
            ->endUse()
        ;
    }
    

    protected function createCollection(): CollectionInterface
    {
        return new OrderItemCollection();
    }
}