<?php

namespace Shop\Infrastructure\Models\Provider\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Provider\ShopProvidersArchive as ChildShopProvidersArchive;
use Shop\Infrastructure\Models\Provider\ShopProvidersArchiveQuery as ChildShopProvidersArchiveQuery;
use Shop\Infrastructure\Models\Provider\Map\ShopProvidersArchiveTableMap;

/**
 * Base class that represents a query for the 'shop_providers_archive' table.
 *
 *
 *
 * @method     ChildShopProvidersArchiveQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildShopProvidersArchiveQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildShopProvidersArchiveQuery orderByTerm($order = Criteria::ASC) Order by the term column
 * @method     ChildShopProvidersArchiveQuery orderByDesc($order = Criteria::ASC) Order by the desc column
 * @method     ChildShopProvidersArchiveQuery orderByContact($order = Criteria::ASC) Order by the contact column
 * @method     ChildShopProvidersArchiveQuery orderByDestination($order = Criteria::ASC) Order by the destination column
 * @method     ChildShopProvidersArchiveQuery orderByColor($order = Criteria::ASC) Order by the color column
 * @method     ChildShopProvidersArchiveQuery orderByShopId($order = Criteria::ASC) Order by the shop_id column
 * @method     ChildShopProvidersArchiveQuery orderByCurrencyId($order = Criteria::ASC) Order by the crrency_id column
 * @method     ChildShopProvidersArchiveQuery orderByContractorId($order = Criteria::ASC) Order by the contractor_id column
 * @method     ChildShopProvidersArchiveQuery orderByArchivedAt($order = Criteria::ASC) Order by the archived_at column
 *
 * @method     ChildShopProvidersArchiveQuery groupById() Group by the id column
 * @method     ChildShopProvidersArchiveQuery groupByName() Group by the name column
 * @method     ChildShopProvidersArchiveQuery groupByTerm() Group by the term column
 * @method     ChildShopProvidersArchiveQuery groupByDesc() Group by the desc column
 * @method     ChildShopProvidersArchiveQuery groupByContact() Group by the contact column
 * @method     ChildShopProvidersArchiveQuery groupByDestination() Group by the destination column
 * @method     ChildShopProvidersArchiveQuery groupByColor() Group by the color column
 * @method     ChildShopProvidersArchiveQuery groupByShopId() Group by the shop_id column
 * @method     ChildShopProvidersArchiveQuery groupByCurrencyId() Group by the crrency_id column
 * @method     ChildShopProvidersArchiveQuery groupByContractorId() Group by the contractor_id column
 * @method     ChildShopProvidersArchiveQuery groupByArchivedAt() Group by the archived_at column
 *
 * @method     ChildShopProvidersArchiveQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildShopProvidersArchiveQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildShopProvidersArchiveQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildShopProvidersArchiveQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildShopProvidersArchiveQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildShopProvidersArchiveQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildShopProvidersArchive|null findOne(?ConnectionInterface $con = null) Return the first ChildShopProvidersArchive matching the query
 * @method     ChildShopProvidersArchive findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildShopProvidersArchive matching the query, or a new ChildShopProvidersArchive object populated from the query conditions when no match is found
 *
 * @method     ChildShopProvidersArchive|null findOneById(int $id) Return the first ChildShopProvidersArchive filtered by the id column
 * @method     ChildShopProvidersArchive|null findOneByName(string $name) Return the first ChildShopProvidersArchive filtered by the name column
 * @method     ChildShopProvidersArchive|null findOneByTerm(int $term) Return the first ChildShopProvidersArchive filtered by the term column
 * @method     ChildShopProvidersArchive|null findOneByDesc(string $desc) Return the first ChildShopProvidersArchive filtered by the desc column
 * @method     ChildShopProvidersArchive|null findOneByContact(string $contact) Return the first ChildShopProvidersArchive filtered by the contact column
 * @method     ChildShopProvidersArchive|null findOneByDestination(string $destination) Return the first ChildShopProvidersArchive filtered by the destination column
 * @method     ChildShopProvidersArchive|null findOneByColor(string $color) Return the first ChildShopProvidersArchive filtered by the color column
 * @method     ChildShopProvidersArchive|null findOneByShopId(int $shop_id) Return the first ChildShopProvidersArchive filtered by the shop_id column
 * @method     ChildShopProvidersArchive|null findOneByCurrencyId(int $crrency_id) Return the first ChildShopProvidersArchive filtered by the crrency_id column
 * @method     ChildShopProvidersArchive|null findOneByContractorId(int $contractor_id) Return the first ChildShopProvidersArchive filtered by the contractor_id column
 * @method     ChildShopProvidersArchive|null findOneByArchivedAt(string $archived_at) Return the first ChildShopProvidersArchive filtered by the archived_at column *

 * @method     ChildShopProvidersArchive requirePk($key, ?ConnectionInterface $con = null) Return the ChildShopProvidersArchive by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopProvidersArchive requireOne(?ConnectionInterface $con = null) Return the first ChildShopProvidersArchive matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopProvidersArchive requireOneById(int $id) Return the first ChildShopProvidersArchive filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopProvidersArchive requireOneByName(string $name) Return the first ChildShopProvidersArchive filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopProvidersArchive requireOneByTerm(int $term) Return the first ChildShopProvidersArchive filtered by the term column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopProvidersArchive requireOneByDesc(string $desc) Return the first ChildShopProvidersArchive filtered by the desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopProvidersArchive requireOneByContact(string $contact) Return the first ChildShopProvidersArchive filtered by the contact column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopProvidersArchive requireOneByDestination(string $destination) Return the first ChildShopProvidersArchive filtered by the destination column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopProvidersArchive requireOneByColor(string $color) Return the first ChildShopProvidersArchive filtered by the color column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopProvidersArchive requireOneByShopId(int $shop_id) Return the first ChildShopProvidersArchive filtered by the shop_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopProvidersArchive requireOneByCurrencyId(int $crrency_id) Return the first ChildShopProvidersArchive filtered by the crrency_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopProvidersArchive requireOneByContractorId(int $contractor_id) Return the first ChildShopProvidersArchive filtered by the contractor_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopProvidersArchive requireOneByArchivedAt(string $archived_at) Return the first ChildShopProvidersArchive filtered by the archived_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopProvidersArchive[]|Collection find(?ConnectionInterface $con = null) Return ChildShopProvidersArchive objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildShopProvidersArchive> find(?ConnectionInterface $con = null) Return ChildShopProvidersArchive objects based on current ModelCriteria
 * @method     ChildShopProvidersArchive[]|Collection findById(int $id) Return ChildShopProvidersArchive objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildShopProvidersArchive> findById(int $id) Return ChildShopProvidersArchive objects filtered by the id column
 * @method     ChildShopProvidersArchive[]|Collection findByName(string $name) Return ChildShopProvidersArchive objects filtered by the name column
 * @psalm-method Collection&\Traversable<ChildShopProvidersArchive> findByName(string $name) Return ChildShopProvidersArchive objects filtered by the name column
 * @method     ChildShopProvidersArchive[]|Collection findByTerm(int $term) Return ChildShopProvidersArchive objects filtered by the term column
 * @psalm-method Collection&\Traversable<ChildShopProvidersArchive> findByTerm(int $term) Return ChildShopProvidersArchive objects filtered by the term column
 * @method     ChildShopProvidersArchive[]|Collection findByDesc(string $desc) Return ChildShopProvidersArchive objects filtered by the desc column
 * @psalm-method Collection&\Traversable<ChildShopProvidersArchive> findByDesc(string $desc) Return ChildShopProvidersArchive objects filtered by the desc column
 * @method     ChildShopProvidersArchive[]|Collection findByContact(string $contact) Return ChildShopProvidersArchive objects filtered by the contact column
 * @psalm-method Collection&\Traversable<ChildShopProvidersArchive> findByContact(string $contact) Return ChildShopProvidersArchive objects filtered by the contact column
 * @method     ChildShopProvidersArchive[]|Collection findByDestination(string $destination) Return ChildShopProvidersArchive objects filtered by the destination column
 * @psalm-method Collection&\Traversable<ChildShopProvidersArchive> findByDestination(string $destination) Return ChildShopProvidersArchive objects filtered by the destination column
 * @method     ChildShopProvidersArchive[]|Collection findByColor(string $color) Return ChildShopProvidersArchive objects filtered by the color column
 * @psalm-method Collection&\Traversable<ChildShopProvidersArchive> findByColor(string $color) Return ChildShopProvidersArchive objects filtered by the color column
 * @method     ChildShopProvidersArchive[]|Collection findByShopId(int $shop_id) Return ChildShopProvidersArchive objects filtered by the shop_id column
 * @psalm-method Collection&\Traversable<ChildShopProvidersArchive> findByShopId(int $shop_id) Return ChildShopProvidersArchive objects filtered by the shop_id column
 * @method     ChildShopProvidersArchive[]|Collection findByCurrencyId(int $crrency_id) Return ChildShopProvidersArchive objects filtered by the crrency_id column
 * @psalm-method Collection&\Traversable<ChildShopProvidersArchive> findByCurrencyId(int $crrency_id) Return ChildShopProvidersArchive objects filtered by the crrency_id column
 * @method     ChildShopProvidersArchive[]|Collection findByContractorId(int $contractor_id) Return ChildShopProvidersArchive objects filtered by the contractor_id column
 * @psalm-method Collection&\Traversable<ChildShopProvidersArchive> findByContractorId(int $contractor_id) Return ChildShopProvidersArchive objects filtered by the contractor_id column
 * @method     ChildShopProvidersArchive[]|Collection findByArchivedAt(string $archived_at) Return ChildShopProvidersArchive objects filtered by the archived_at column
 * @psalm-method Collection&\Traversable<ChildShopProvidersArchive> findByArchivedAt(string $archived_at) Return ChildShopProvidersArchive objects filtered by the archived_at column
 * @method     ChildShopProvidersArchive[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildShopProvidersArchive> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ShopProvidersArchiveQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\Provider\Base\ShopProvidersArchiveQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Infrastructure\\Models\\Provider\\ShopProvidersArchive', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildShopProvidersArchiveQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildShopProvidersArchiveQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildShopProvidersArchiveQuery) {
            return $criteria;
        }
        $query = new ChildShopProvidersArchiveQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildShopProvidersArchive|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ShopProvidersArchiveTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ShopProvidersArchiveTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopProvidersArchive A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `term`, `desc`, `contact`, `destination`, `color`, `shop_id`, `crrency_id`, `contractor_id`, `archived_at` FROM `shop_providers_archive` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildShopProvidersArchive $obj */
            $obj = new ChildShopProvidersArchive();
            $obj->hydrate($row);
            ShopProvidersArchiveTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildShopProvidersArchive|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * $query->filterByName(['foo', 'bar']); // WHERE name IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $name The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByName($name = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_NAME, $name, $comparison);

        return $this;
    }

    /**
     * Filter the query on the term column
     *
     * Example usage:
     * <code>
     * $query->filterByTerm(1234); // WHERE term = 1234
     * $query->filterByTerm(array(12, 34)); // WHERE term IN (12, 34)
     * $query->filterByTerm(array('min' => 12)); // WHERE term > 12
     * </code>
     *
     * @param mixed $term The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByTerm($term = null, ?string $comparison = null)
    {
        if (is_array($term)) {
            $useMinMax = false;
            if (isset($term['min'])) {
                $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_TERM, $term['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($term['max'])) {
                $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_TERM, $term['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_TERM, $term, $comparison);

        return $this;
    }

    /**
     * Filter the query on the desc column
     *
     * Example usage:
     * <code>
     * $query->filterByDesc('fooValue');   // WHERE desc = 'fooValue'
     * $query->filterByDesc('%fooValue%', Criteria::LIKE); // WHERE desc LIKE '%fooValue%'
     * $query->filterByDesc(['foo', 'bar']); // WHERE desc IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $desc The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDesc($desc = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($desc)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_DESC, $desc, $comparison);

        return $this;
    }

    /**
     * Filter the query on the contact column
     *
     * Example usage:
     * <code>
     * $query->filterByContact('fooValue');   // WHERE contact = 'fooValue'
     * $query->filterByContact('%fooValue%', Criteria::LIKE); // WHERE contact LIKE '%fooValue%'
     * $query->filterByContact(['foo', 'bar']); // WHERE contact IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $contact The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByContact($contact = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($contact)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_CONTACT, $contact, $comparison);

        return $this;
    }

    /**
     * Filter the query on the destination column
     *
     * Example usage:
     * <code>
     * $query->filterByDestination('fooValue');   // WHERE destination = 'fooValue'
     * $query->filterByDestination('%fooValue%', Criteria::LIKE); // WHERE destination LIKE '%fooValue%'
     * $query->filterByDestination(['foo', 'bar']); // WHERE destination IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $destination The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDestination($destination = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($destination)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_DESTINATION, $destination, $comparison);

        return $this;
    }

    /**
     * Filter the query on the color column
     *
     * Example usage:
     * <code>
     * $query->filterByColor('fooValue');   // WHERE color = 'fooValue'
     * $query->filterByColor('%fooValue%', Criteria::LIKE); // WHERE color LIKE '%fooValue%'
     * $query->filterByColor(['foo', 'bar']); // WHERE color IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $color The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByColor($color = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($color)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_COLOR, $color, $comparison);

        return $this;
    }

    /**
     * Filter the query on the shop_id column
     *
     * Example usage:
     * <code>
     * $query->filterByShopId(1234); // WHERE shop_id = 1234
     * $query->filterByShopId(array(12, 34)); // WHERE shop_id IN (12, 34)
     * $query->filterByShopId(array('min' => 12)); // WHERE shop_id > 12
     * </code>
     *
     * @param mixed $shopId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByShopId($shopId = null, ?string $comparison = null)
    {
        if (is_array($shopId)) {
            $useMinMax = false;
            if (isset($shopId['min'])) {
                $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_SHOP_ID, $shopId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($shopId['max'])) {
                $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_SHOP_ID, $shopId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_SHOP_ID, $shopId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the crrency_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCurrencyId(1234); // WHERE crrency_id = 1234
     * $query->filterByCurrencyId(array(12, 34)); // WHERE crrency_id IN (12, 34)
     * $query->filterByCurrencyId(array('min' => 12)); // WHERE crrency_id > 12
     * </code>
     *
     * @param mixed $currencyId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCurrencyId($currencyId = null, ?string $comparison = null)
    {
        if (is_array($currencyId)) {
            $useMinMax = false;
            if (isset($currencyId['min'])) {
                $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_CRRENCY_ID, $currencyId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($currencyId['max'])) {
                $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_CRRENCY_ID, $currencyId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_CRRENCY_ID, $currencyId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the contractor_id column
     *
     * Example usage:
     * <code>
     * $query->filterByContractorId(1234); // WHERE contractor_id = 1234
     * $query->filterByContractorId(array(12, 34)); // WHERE contractor_id IN (12, 34)
     * $query->filterByContractorId(array('min' => 12)); // WHERE contractor_id > 12
     * </code>
     *
     * @param mixed $contractorId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByContractorId($contractorId = null, ?string $comparison = null)
    {
        if (is_array($contractorId)) {
            $useMinMax = false;
            if (isset($contractorId['min'])) {
                $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_CONTRACTOR_ID, $contractorId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($contractorId['max'])) {
                $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_CONTRACTOR_ID, $contractorId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_CONTRACTOR_ID, $contractorId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the archived_at column
     *
     * Example usage:
     * <code>
     * $query->filterByArchivedAt('2011-03-14'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt('now'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt(array('max' => 'yesterday')); // WHERE archived_at > '2011-03-13'
     * </code>
     *
     * @param mixed $archivedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByArchivedAt($archivedAt = null, ?string $comparison = null)
    {
        if (is_array($archivedAt)) {
            $useMinMax = false;
            if (isset($archivedAt['min'])) {
                $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($archivedAt['max'])) {
                $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_ARCHIVED_AT, $archivedAt, $comparison);

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildShopProvidersArchive $shopProvidersArchive Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($shopProvidersArchive = null)
    {
        if ($shopProvidersArchive) {
            $this->addUsingAlias(ShopProvidersArchiveTableMap::COL_ID, $shopProvidersArchive->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_providers_archive table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopProvidersArchiveTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ShopProvidersArchiveTableMap::clearInstancePool();
            ShopProvidersArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopProvidersArchiveTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ShopProvidersArchiveTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ShopProvidersArchiveTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ShopProvidersArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
