<?php declare(strict_types=1);

namespace Shop\Presentation\Transformers;

use League\Fractal\TransformerAbstract;
use Shop\Domain\Product\Contracts\ProductEntityInterface;
use Shop\Infrastructure\Models\Product\Product;

class ProductTransformer extends TransformerAbstract
{
    /**
     * @param ProductEntityInterface|Product $cat
     * @return array
     */
    public function transform(ProductEntityInterface $product): array
    {
        $category = $product->getCategory();


        if ($parent = $category->getParentCategory()) {
            $categoryName = $parent->getTitle() . '->' . $category->getTitle();
        } else {
            $categoryName = $category->getTitle();
        }

        $positions = [];

        foreach ($product->getPositions() as $position){
            $positions[] = [
                'id' => $position->getId(),
                'description' => $position->getDesc(),
                'price' => $position->getPrice(),
                'remain' => $position->getRemain(),
            ];
        }

        return [
            'id' => $product->getId(),
            'name' => $product->getName(),
            'article' => $product->getArticle(),
            'brand' => $product->getBrand()->getName(),
            'description' => $product->getDesc(),
            'price' => $product->getPrice(),
            'image' => $product->getImg(),
            'images' => $product->getImages(),
            'positions' => $positions,
            'category' => $categoryName,
            'groups' => $product->getGroupListArray()
        ];
    }
}