<?php

namespace Shop\Infrastructure\Models\PricelistSheet\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Position\Map\PositionTableMap;
use Shop\Infrastructure\Models\PricelistSheet\PricelistSheet;
use Shop\Infrastructure\Models\PricelistSheet\PricelistSheetQuery;


/**
 * This class defines the structure of the 'shop_pricelist_sheets' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class PricelistSheetTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.PricelistSheet.Map.PricelistSheetTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_pricelist_sheets';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\PricelistSheet\\PricelistSheet';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.PricelistSheet.PricelistSheet';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 5;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 5;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_pricelist_sheets.id';

    /**
     * the column name for the title field
     */
    public const COL_TITLE = 'shop_pricelist_sheets.title';

    /**
     * the column name for the date_update field
     */
    public const COL_DATE_UPDATE = 'shop_pricelist_sheets.date_update';

    /**
     * the column name for the pricelist_file_id field
     */
    public const COL_PRICELIST_FILE_ID = 'shop_pricelist_sheets.pricelist_file_id';

    /**
     * the column name for the crrency_id field
     */
    public const COL_CRRENCY_ID = 'shop_pricelist_sheets.crrency_id';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Title', 'DateUpdate', 'PricelistFileId', 'CurrencyId', ],
        self::TYPE_CAMELNAME     => ['id', 'title', 'dateUpdate', 'pricelistFileId', 'currencyId', ],
        self::TYPE_COLNAME       => [PricelistSheetTableMap::COL_ID, PricelistSheetTableMap::COL_TITLE, PricelistSheetTableMap::COL_DATE_UPDATE, PricelistSheetTableMap::COL_PRICELIST_FILE_ID, PricelistSheetTableMap::COL_CRRENCY_ID, ],
        self::TYPE_FIELDNAME     => ['id', 'title', 'date_update', 'pricelist_file_id', 'crrency_id', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Title' => 1, 'DateUpdate' => 2, 'PricelistFileId' => 3, 'CurrencyId' => 4, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'title' => 1, 'dateUpdate' => 2, 'pricelistFileId' => 3, 'currencyId' => 4, ],
        self::TYPE_COLNAME       => [PricelistSheetTableMap::COL_ID => 0, PricelistSheetTableMap::COL_TITLE => 1, PricelistSheetTableMap::COL_DATE_UPDATE => 2, PricelistSheetTableMap::COL_PRICELIST_FILE_ID => 3, PricelistSheetTableMap::COL_CRRENCY_ID => 4, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'title' => 1, 'date_update' => 2, 'pricelist_file_id' => 3, 'crrency_id' => 4, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'PricelistSheet.Id' => 'ID',
        'id' => 'ID',
        'pricelistSheet.id' => 'ID',
        'PricelistSheetTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_pricelist_sheets.id' => 'ID',
        'Title' => 'TITLE',
        'PricelistSheet.Title' => 'TITLE',
        'title' => 'TITLE',
        'pricelistSheet.title' => 'TITLE',
        'PricelistSheetTableMap::COL_TITLE' => 'TITLE',
        'COL_TITLE' => 'TITLE',
        'shop_pricelist_sheets.title' => 'TITLE',
        'DateUpdate' => 'DATE_UPDATE',
        'PricelistSheet.DateUpdate' => 'DATE_UPDATE',
        'dateUpdate' => 'DATE_UPDATE',
        'pricelistSheet.dateUpdate' => 'DATE_UPDATE',
        'PricelistSheetTableMap::COL_DATE_UPDATE' => 'DATE_UPDATE',
        'COL_DATE_UPDATE' => 'DATE_UPDATE',
        'date_update' => 'DATE_UPDATE',
        'shop_pricelist_sheets.date_update' => 'DATE_UPDATE',
        'PricelistFileId' => 'PRICELIST_FILE_ID',
        'PricelistSheet.PricelistFileId' => 'PRICELIST_FILE_ID',
        'pricelistFileId' => 'PRICELIST_FILE_ID',
        'pricelistSheet.pricelistFileId' => 'PRICELIST_FILE_ID',
        'PricelistSheetTableMap::COL_PRICELIST_FILE_ID' => 'PRICELIST_FILE_ID',
        'COL_PRICELIST_FILE_ID' => 'PRICELIST_FILE_ID',
        'pricelist_file_id' => 'PRICELIST_FILE_ID',
        'shop_pricelist_sheets.pricelist_file_id' => 'PRICELIST_FILE_ID',
        'CurrencyId' => 'CRRENCY_ID',
        'PricelistSheet.CurrencyId' => 'CRRENCY_ID',
        'currencyId' => 'CRRENCY_ID',
        'pricelistSheet.currencyId' => 'CRRENCY_ID',
        'PricelistSheetTableMap::COL_CRRENCY_ID' => 'CRRENCY_ID',
        'COL_CRRENCY_ID' => 'CRRENCY_ID',
        'crrency_id' => 'CRRENCY_ID',
        'shop_pricelist_sheets.crrency_id' => 'CRRENCY_ID',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_pricelist_sheets');
        $this->setPhpName('PricelistSheet');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\PricelistSheet\\PricelistSheet');
        $this->setPackage('Shop.Infrastructure.Models.PricelistSheet');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('title', 'Title', 'VARCHAR', false, 100, null);
        $this->addColumn('date_update', 'DateUpdate', 'TIMESTAMP', false, null, null);
        $this->addForeignKey('pricelist_file_id', 'PricelistFileId', 'INTEGER', 'shop_pricelist_files', 'id', true, null, null);
        $this->addForeignKey('crrency_id', 'CurrencyId', 'INTEGER', 'shop_currencies', 'id', true, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('PricelistFile', '\\Shop\\Infrastructure\\Models\\PricelistFile\\PricelistFile', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':pricelist_file_id',
    1 => ':id',
  ),
), 'CASCADE', null, null, false);
        $this->addRelation('Currency', '\\Shop\\Infrastructure\\Models\\Currency\\Currency', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':crrency_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Position', '\\Shop\\Infrastructure\\Models\\Position\\Position', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':pricelist_sheet_id',
    1 => ':id',
  ),
), 'CASCADE', null, 'Positions', false);
    }

    /**
     * Method to invalidate the instance pool of all tables related to shop_pricelist_sheets     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool(): void
    {
        // Invalidate objects in related instance pools,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        PositionTableMap::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? PricelistSheetTableMap::CLASS_DEFAULT : PricelistSheetTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (PricelistSheet object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = PricelistSheetTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = PricelistSheetTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + PricelistSheetTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = PricelistSheetTableMap::OM_CLASS;
            /** @var PricelistSheet $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            PricelistSheetTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = PricelistSheetTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = PricelistSheetTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var PricelistSheet $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                PricelistSheetTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(PricelistSheetTableMap::COL_ID);
            $criteria->addSelectColumn(PricelistSheetTableMap::COL_TITLE);
            $criteria->addSelectColumn(PricelistSheetTableMap::COL_DATE_UPDATE);
            $criteria->addSelectColumn(PricelistSheetTableMap::COL_PRICELIST_FILE_ID);
            $criteria->addSelectColumn(PricelistSheetTableMap::COL_CRRENCY_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.title');
            $criteria->addSelectColumn($alias . '.date_update');
            $criteria->addSelectColumn($alias . '.pricelist_file_id');
            $criteria->addSelectColumn($alias . '.crrency_id');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(PricelistSheetTableMap::COL_ID);
            $criteria->removeSelectColumn(PricelistSheetTableMap::COL_TITLE);
            $criteria->removeSelectColumn(PricelistSheetTableMap::COL_DATE_UPDATE);
            $criteria->removeSelectColumn(PricelistSheetTableMap::COL_PRICELIST_FILE_ID);
            $criteria->removeSelectColumn(PricelistSheetTableMap::COL_CRRENCY_ID);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.title');
            $criteria->removeSelectColumn($alias . '.date_update');
            $criteria->removeSelectColumn($alias . '.pricelist_file_id');
            $criteria->removeSelectColumn($alias . '.crrency_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(PricelistSheetTableMap::DATABASE_NAME)->getTable(PricelistSheetTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a PricelistSheet or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or PricelistSheet object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PricelistSheetTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\PricelistSheet\PricelistSheet) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(PricelistSheetTableMap::DATABASE_NAME);
            $criteria->add(PricelistSheetTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = PricelistSheetQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            PricelistSheetTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                PricelistSheetTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_pricelist_sheets table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return PricelistSheetQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a PricelistSheet or Criteria object.
     *
     * @param mixed $criteria Criteria or PricelistSheet object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PricelistSheetTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from PricelistSheet object
        }

        if ($criteria->containsKey(PricelistSheetTableMap::COL_ID) && $criteria->keyContainsValue(PricelistSheetTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.PricelistSheetTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = PricelistSheetQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
