<?php


namespace Shop\Domain\Basket;


class BasketItem
{
    const STATE_CORRECT = "correct";
    const STATE_UP_PRICE = "up_price";
    const STATE_DOWN_PRICE = "down_price";
    const STATE_OUT_STOCK = "out_stock";

    /**
     * @var string
     */
    protected $id;

    /**
     * @var float
     */
    protected $price;

    /**
     * @var int
     */
    protected $amount;

    /**
     * @var string|null
     */
    protected $name;

    /**
     * @var string|null
     */
    protected $article;

    /**
     * @var string|null
     */
    protected $brand;

    /**
     * @var string|null
     */
    protected $desc;

    /**
     * @var string|null
     */
    protected $ref;

    /**
     * поставщик товара
     * @var int
     */
    protected $providerId;

    /**
     * @var string|null
     */
    protected $menagerComment;

    /**
     * @var string|null
     */
    protected $destination;

    /**\
     * @var string
     */
    protected $state = self::STATE_CORRECT;


    /**
     * @return string
     */
    public function getState(): string
    {
        return $this->state;
    }

    /**
     * @param string $state
     * @return BasketItem
     */
    public function setState(string $state): BasketItem
    {
        $this->state = $state;
        return $this;
    }



    /**
     * @return string|null
     */
    public function getDestination(): ?string
    {
        return $this->destination;
    }

    /**
     * @param string|null $destination
     * @return BasketItem
     */
    public function setDestination(?string $destination): BasketItem
    {
        $this->destination = $destination;
        return $this;
    }


    /**
     * @return string
     */
    public function getId(): string
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return BasketItem
     */
    public function setId(string $id): BasketItem
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return float
     */
    public function getPrice(): float
    {
        return $this->price;
    }

    /**
     * @param float $price
     * @return BasketItem
     */
    public function setPrice(float $price): BasketItem
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return int
     */
    public function getAmount(): int
    {
        return $this->amount;
    }

    /**
     * @param int $amount
     * @return BasketItem
     */
    public function setAmount(int $amount): BasketItem
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return BasketItem
     */
    public function setName(?string $name): BasketItem
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getArticle(): ?string
    {
        return $this->article;
    }

    /**
     * @param string|null $article
     * @return BasketItem
     */
    public function setArticle(?string $article): BasketItem
    {
        $this->article = $article;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBrand(): ?string
    {
        return $this->brand;
    }

    /**
     * @param string|null $brand
     * @return BasketItem
     */
    public function setBrand(?string $brand): BasketItem
    {
        $this->brand = $brand;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDesc(): ?string
    {
        return $this->desc;
    }

    /**
     * @param string|null $desc
     * @return BasketItem
     */
    public function setDesc(?string $desc): BasketItem
    {
        $this->desc = $desc;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getRef(): ?string
    {
        return $this->ref;
    }

    /**
     * @param string|null $ref
     * @return BasketItem
     */
    public function setRef(?string $ref): BasketItem
    {
        $this->ref = $ref;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getProviderId(): int
    {
        return $this->providerId;
    }

    /**
     * @param string|null $providerId
     * @return BasketItem
     */
    public function setProviderId(int $providerId): BasketItem
    {
        $this->providerId = $providerId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMenagerComment(): ?string
    {
        return $this->menagerComment;
    }

    /**
     * @param string|null $menagerComment
     * @return BasketItem
     */
    public function setMenagerComment(?string $menagerComment): BasketItem
    {
        $this->menagerComment = $menagerComment;
        return $this;
    }


}