<?php


namespace Shop\Application\Shopping\SendCustomerOrders;


use JetBrains\PhpStorm\Internal\LanguageLevelTypeAware;
use Shop\Application\Shopping\Exceptions\ShoppingException;
use Shop\Domain\CustomerOrder\CustomerOrderCollection;

class SendCustomerOrdersException extends ShoppingException
{

    protected $orders = [];
    protected $errors = [];

    public function __construct(CustomerOrderCollection $orders, array $errors, $message = "", $code = 0, Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->orders = $orders;
        $this->errors = $errors;
    }

    /**
     * @return CustomerOrderCollection
     */
    public function getSuccess(): CustomerOrderCollection
    {
        return $this->orders;
    }

    /**
     * @return array
     */
    public function getErrors(): array
    {
        return $this->errors;
    }

}