<?php


namespace Shop\Infrastructure\Repositories\SyncLog;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\SyncLog\SyncLogCollection;
use Shop\Infrastructure\Models\SyncLog\SyncLog;
use Shop\Infrastructure\Models\SyncLog\SyncLogQuery;
use Shop\Infrastructure\Models\SyncLogs\SyncLogs;
use Shop\Infrastructure\Models\SyncLogs\SyncLogsQuery;

class SyncLogRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    /**
     * @return EntityInterface
     */
    public static function createEntity(): EntityInterface
    {
        return new SyncLog();
    }

    protected function createQuery(): ModelCriteria
    {
        return SyncLogQuery::create();
    }

    /**
     * @param PaginationInterface $criteria
     * @param ModelCriteria $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $dbCriteria
            ->_if($criteria->getFilterByOrderId()!==null)
            ->filterByOrderId($criteria->getFilterByOrderId())
            ->_endif();
    }

    protected function createCollection(): CollectionInterface
    {
        return new SyncLogCollection();
    }
}