<?php

namespace Shop\Infrastructure\Repositories\Customer;

use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\Currency\CurrencyCollection;
use Shop\Domain\Customer\Contracts\CustomerCriteriaInterface;
use Shop\Domain\Customer\CustomerCollection;
use Shop\Infrastructure\Models\Customer\Customer;
use Shop\Infrastructure\Models\Customer\CustomerQuery;

class CustomerRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new Customer();
    }

    protected function createQuery(): ModelCriteria
    {
        return CustomerQuery::create();
    }

    /**
     * @param PaginationInterface|CustomerCriteriaInterface $criteria
     * @param ModelCriteria|CustomerQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dbCriteria
            ->_if($criteria->getFilterByCreateMonthDate() !== null)
            ->filterByRegistred(sprintf(
                '(YEAR(registred) = %s AND MONTH(registred) = %s)',
                preg_replace('~\-\d+~is','',$criteria->getFilterByCreateMonthDate()),
                preg_replace('~\d+\-~is','',$criteria->getFilterByCreateMonthDate()),
            ),Criteria::CUSTOM)
            ->_endif()
            //filter
            ->_if($criteria->getFilterByOnlyAyth() === true)
            ->filterByLastauth(null, Criteria::ISNOTNULL)
            ->_endif()
            ->_if($criteria->getFilterByOnlyAyth() === false)
            ->filterByLastauth(null, Criteria::ISNULL)
            ->_endif()
            ->_if($criteria->getFilterByManagerId() !== null)
            ->filterByManagerId($criteria->getFilterByManagerId())
            ->_endif()
            ->_if($criteria->getFilterByBlocked() !== null)
            ->filterByBlocked($criteria->getFilterByBlocked() === true ? 'Y' : 'N')
            ->_endif()
            ->_if($criteria->getFilterByStockId() !== null)
            ->useManagerQuery()
            ->filterByShopId($criteria->getFilterByStockId())
            ->endUse()
            ->_endif()
            ->_if($criteria->getFilterByGroupIds() !== null)
            ->filterByGroupId($criteria->getFilterByGroupIds())
            ->_endif()
            ->_if($criteria->getFilterByGroupId() !== null)
            ->filterByGroupId($criteria->getFilterByGroupId())
            ->_endif()
            ->_if($criteria->getFilterByEmail() !== null)
            ->filterByEmail($criteria->getFilterByEmail())
            ->_endif()
            ->_if($criteria->getFilterByPassword() !== null)
            ->filterByPassword($criteria->getFilterByPassword())
            ->_endif()
            ->_if($criteria->getSearchByEmail() !== null)
            ->filterByEmail('%' . $criteria->getSearchByEmail() . '%', Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getSearchByName() !== null)
            ->filterByName('%' . $criteria->getSearchByName() . '%', Criteria::LIKE)
            ->_endif()
            //order
            ->_if($criteria->getSortByEmail() !== null)
            ->orderByEmail($criteria->getSortByEmail())
            ->_endif()
            ->_if($criteria->getSortByRegistred() !== null)
            ->orderByRegistred($criteria->getSortByRegistred())
            ->_endif();
    }



    protected function createCollection(): CollectionInterface
    {
        return new CustomerCollection();
    }

}