<?php

namespace Shop\Infrastructure\Models\Discount\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Discount\Discount as ChildDiscount;
use Shop\Infrastructure\Models\Discount\DiscountQuery as ChildDiscountQuery;
use Shop\Infrastructure\Models\Discount\Map\DiscountTableMap;

/**
 * Base class that represents a query for the 'shop_discounts' table.
 *
 *
 *
 * @method     ChildDiscountQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildDiscountQuery orderByPriceFrom($order = Criteria::ASC) Order by the price_from column
 * @method     ChildDiscountQuery orderByPriceTo($order = Criteria::ASC) Order by the price_to column
 * @method     ChildDiscountQuery orderByPercent($order = Criteria::ASC) Order by the percent column
 *
 * @method     ChildDiscountQuery groupById() Group by the id column
 * @method     ChildDiscountQuery groupByPriceFrom() Group by the price_from column
 * @method     ChildDiscountQuery groupByPriceTo() Group by the price_to column
 * @method     ChildDiscountQuery groupByPercent() Group by the percent column
 *
 * @method     ChildDiscountQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildDiscountQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildDiscountQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildDiscountQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildDiscountQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildDiscountQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildDiscount|null findOne(?ConnectionInterface $con = null) Return the first ChildDiscount matching the query
 * @method     ChildDiscount findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildDiscount matching the query, or a new ChildDiscount object populated from the query conditions when no match is found
 *
 * @method     ChildDiscount|null findOneById(int $id) Return the first ChildDiscount filtered by the id column
 * @method     ChildDiscount|null findOneByPriceFrom(string $price_from) Return the first ChildDiscount filtered by the price_from column
 * @method     ChildDiscount|null findOneByPriceTo(string $price_to) Return the first ChildDiscount filtered by the price_to column
 * @method     ChildDiscount|null findOneByPercent(string $percent) Return the first ChildDiscount filtered by the percent column *

 * @method     ChildDiscount requirePk($key, ?ConnectionInterface $con = null) Return the ChildDiscount by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDiscount requireOne(?ConnectionInterface $con = null) Return the first ChildDiscount matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildDiscount requireOneById(int $id) Return the first ChildDiscount filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDiscount requireOneByPriceFrom(string $price_from) Return the first ChildDiscount filtered by the price_from column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDiscount requireOneByPriceTo(string $price_to) Return the first ChildDiscount filtered by the price_to column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDiscount requireOneByPercent(string $percent) Return the first ChildDiscount filtered by the percent column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildDiscount[]|Collection find(?ConnectionInterface $con = null) Return ChildDiscount objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildDiscount> find(?ConnectionInterface $con = null) Return ChildDiscount objects based on current ModelCriteria
 * @method     ChildDiscount[]|Collection findById(int $id) Return ChildDiscount objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildDiscount> findById(int $id) Return ChildDiscount objects filtered by the id column
 * @method     ChildDiscount[]|Collection findByPriceFrom(string $price_from) Return ChildDiscount objects filtered by the price_from column
 * @psalm-method Collection&\Traversable<ChildDiscount> findByPriceFrom(string $price_from) Return ChildDiscount objects filtered by the price_from column
 * @method     ChildDiscount[]|Collection findByPriceTo(string $price_to) Return ChildDiscount objects filtered by the price_to column
 * @psalm-method Collection&\Traversable<ChildDiscount> findByPriceTo(string $price_to) Return ChildDiscount objects filtered by the price_to column
 * @method     ChildDiscount[]|Collection findByPercent(string $percent) Return ChildDiscount objects filtered by the percent column
 * @psalm-method Collection&\Traversable<ChildDiscount> findByPercent(string $percent) Return ChildDiscount objects filtered by the percent column
 * @method     ChildDiscount[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildDiscount> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class DiscountQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\Discount\Base\DiscountQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Infrastructure\\Models\\Discount\\Discount', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildDiscountQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildDiscountQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildDiscountQuery) {
            return $criteria;
        }
        $query = new ChildDiscountQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildDiscount|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(DiscountTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = DiscountTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildDiscount A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `price_from`, `price_to`, `percent` FROM `shop_discounts` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildDiscount $obj */
            $obj = new ChildDiscount();
            $obj->hydrate($row);
            DiscountTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildDiscount|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(DiscountTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(DiscountTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(DiscountTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(DiscountTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(DiscountTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the price_from column
     *
     * Example usage:
     * <code>
     * $query->filterByPriceFrom(1234); // WHERE price_from = 1234
     * $query->filterByPriceFrom(array(12, 34)); // WHERE price_from IN (12, 34)
     * $query->filterByPriceFrom(array('min' => 12)); // WHERE price_from > 12
     * </code>
     *
     * @param mixed $priceFrom The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPriceFrom($priceFrom = null, ?string $comparison = null)
    {
        if (is_array($priceFrom)) {
            $useMinMax = false;
            if (isset($priceFrom['min'])) {
                $this->addUsingAlias(DiscountTableMap::COL_PRICE_FROM, $priceFrom['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($priceFrom['max'])) {
                $this->addUsingAlias(DiscountTableMap::COL_PRICE_FROM, $priceFrom['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(DiscountTableMap::COL_PRICE_FROM, $priceFrom, $comparison);

        return $this;
    }

    /**
     * Filter the query on the price_to column
     *
     * Example usage:
     * <code>
     * $query->filterByPriceTo(1234); // WHERE price_to = 1234
     * $query->filterByPriceTo(array(12, 34)); // WHERE price_to IN (12, 34)
     * $query->filterByPriceTo(array('min' => 12)); // WHERE price_to > 12
     * </code>
     *
     * @param mixed $priceTo The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPriceTo($priceTo = null, ?string $comparison = null)
    {
        if (is_array($priceTo)) {
            $useMinMax = false;
            if (isset($priceTo['min'])) {
                $this->addUsingAlias(DiscountTableMap::COL_PRICE_TO, $priceTo['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($priceTo['max'])) {
                $this->addUsingAlias(DiscountTableMap::COL_PRICE_TO, $priceTo['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(DiscountTableMap::COL_PRICE_TO, $priceTo, $comparison);

        return $this;
    }

    /**
     * Filter the query on the percent column
     *
     * Example usage:
     * <code>
     * $query->filterByPercent(1234); // WHERE percent = 1234
     * $query->filterByPercent(array(12, 34)); // WHERE percent IN (12, 34)
     * $query->filterByPercent(array('min' => 12)); // WHERE percent > 12
     * </code>
     *
     * @param mixed $percent The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPercent($percent = null, ?string $comparison = null)
    {
        if (is_array($percent)) {
            $useMinMax = false;
            if (isset($percent['min'])) {
                $this->addUsingAlias(DiscountTableMap::COL_PERCENT, $percent['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($percent['max'])) {
                $this->addUsingAlias(DiscountTableMap::COL_PERCENT, $percent['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(DiscountTableMap::COL_PERCENT, $percent, $comparison);

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildDiscount $discount Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($discount = null)
    {
        if ($discount) {
            $this->addUsingAlias(DiscountTableMap::COL_ID, $discount->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_discounts table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(DiscountTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            DiscountTableMap::clearInstancePool();
            DiscountTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(DiscountTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(DiscountTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            DiscountTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            DiscountTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
