<?php

namespace Shop\Infrastructure\Models\Currency\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Currency\ShopCurrenciesArchive;
use Shop\Infrastructure\Models\Currency\ShopCurrenciesArchiveQuery;


/**
 * This class defines the structure of the 'shop_currencies_archive' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class ShopCurrenciesArchiveTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.Currency.Map.ShopCurrenciesArchiveTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_currencies_archive';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\Currency\\ShopCurrenciesArchive';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.Currency.ShopCurrenciesArchive';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 11;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 11;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_currencies_archive.id';

    /**
     * the column name for the name field
     */
    public const COL_NAME = 'shop_currencies_archive.name';

    /**
     * the column name for the native field
     */
    public const COL_NATIVE = 'shop_currencies_archive.native';

    /**
     * the column name for the position field
     */
    public const COL_POSITION = 'shop_currencies_archive.position';

    /**
     * the column name for the html_sign field
     */
    public const COL_HTML_SIGN = 'shop_currencies_archive.html_sign';

    /**
     * the column name for the round_price field
     */
    public const COL_ROUND_PRICE = 'shop_currencies_archive.round_price';

    /**
     * the column name for the displayed field
     */
    public const COL_DISPLAYED = 'shop_currencies_archive.displayed';

    /**
     * the column name for the iso field
     */
    public const COL_ISO = 'shop_currencies_archive.iso';

    /**
     * the column name for the rbk_sync field
     */
    public const COL_RBK_SYNC = 'shop_currencies_archive.rbk_sync';

    /**
     * the column name for the round_mode field
     */
    public const COL_ROUND_MODE = 'shop_currencies_archive.round_mode';

    /**
     * the column name for the archived_at field
     */
    public const COL_ARCHIVED_AT = 'shop_currencies_archive.archived_at';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Name', 'Native', 'Position', 'HtmlSign', 'RoundPrice', 'Displayed', 'Iso', 'RbkSync', 'RoundMode', 'ArchivedAt', ],
        self::TYPE_CAMELNAME     => ['id', 'name', 'native', 'position', 'htmlSign', 'roundPrice', 'displayed', 'iso', 'rbkSync', 'roundMode', 'archivedAt', ],
        self::TYPE_COLNAME       => [ShopCurrenciesArchiveTableMap::COL_ID, ShopCurrenciesArchiveTableMap::COL_NAME, ShopCurrenciesArchiveTableMap::COL_NATIVE, ShopCurrenciesArchiveTableMap::COL_POSITION, ShopCurrenciesArchiveTableMap::COL_HTML_SIGN, ShopCurrenciesArchiveTableMap::COL_ROUND_PRICE, ShopCurrenciesArchiveTableMap::COL_DISPLAYED, ShopCurrenciesArchiveTableMap::COL_ISO, ShopCurrenciesArchiveTableMap::COL_RBK_SYNC, ShopCurrenciesArchiveTableMap::COL_ROUND_MODE, ShopCurrenciesArchiveTableMap::COL_ARCHIVED_AT, ],
        self::TYPE_FIELDNAME     => ['id', 'name', 'native', 'position', 'html_sign', 'round_price', 'displayed', 'iso', 'rbk_sync', 'round_mode', 'archived_at', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Name' => 1, 'Native' => 2, 'Position' => 3, 'HtmlSign' => 4, 'RoundPrice' => 5, 'Displayed' => 6, 'Iso' => 7, 'RbkSync' => 8, 'RoundMode' => 9, 'ArchivedAt' => 10, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'name' => 1, 'native' => 2, 'position' => 3, 'htmlSign' => 4, 'roundPrice' => 5, 'displayed' => 6, 'iso' => 7, 'rbkSync' => 8, 'roundMode' => 9, 'archivedAt' => 10, ],
        self::TYPE_COLNAME       => [ShopCurrenciesArchiveTableMap::COL_ID => 0, ShopCurrenciesArchiveTableMap::COL_NAME => 1, ShopCurrenciesArchiveTableMap::COL_NATIVE => 2, ShopCurrenciesArchiveTableMap::COL_POSITION => 3, ShopCurrenciesArchiveTableMap::COL_HTML_SIGN => 4, ShopCurrenciesArchiveTableMap::COL_ROUND_PRICE => 5, ShopCurrenciesArchiveTableMap::COL_DISPLAYED => 6, ShopCurrenciesArchiveTableMap::COL_ISO => 7, ShopCurrenciesArchiveTableMap::COL_RBK_SYNC => 8, ShopCurrenciesArchiveTableMap::COL_ROUND_MODE => 9, ShopCurrenciesArchiveTableMap::COL_ARCHIVED_AT => 10, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'name' => 1, 'native' => 2, 'position' => 3, 'html_sign' => 4, 'round_price' => 5, 'displayed' => 6, 'iso' => 7, 'rbk_sync' => 8, 'round_mode' => 9, 'archived_at' => 10, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'ShopCurrenciesArchive.Id' => 'ID',
        'id' => 'ID',
        'shopCurrenciesArchive.id' => 'ID',
        'ShopCurrenciesArchiveTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_currencies_archive.id' => 'ID',
        'Name' => 'NAME',
        'ShopCurrenciesArchive.Name' => 'NAME',
        'name' => 'NAME',
        'shopCurrenciesArchive.name' => 'NAME',
        'ShopCurrenciesArchiveTableMap::COL_NAME' => 'NAME',
        'COL_NAME' => 'NAME',
        'shop_currencies_archive.name' => 'NAME',
        'Native' => 'NATIVE',
        'ShopCurrenciesArchive.Native' => 'NATIVE',
        'native' => 'NATIVE',
        'shopCurrenciesArchive.native' => 'NATIVE',
        'ShopCurrenciesArchiveTableMap::COL_NATIVE' => 'NATIVE',
        'COL_NATIVE' => 'NATIVE',
        'shop_currencies_archive.native' => 'NATIVE',
        'Position' => 'POSITION',
        'ShopCurrenciesArchive.Position' => 'POSITION',
        'position' => 'POSITION',
        'shopCurrenciesArchive.position' => 'POSITION',
        'ShopCurrenciesArchiveTableMap::COL_POSITION' => 'POSITION',
        'COL_POSITION' => 'POSITION',
        'shop_currencies_archive.position' => 'POSITION',
        'HtmlSign' => 'HTML_SIGN',
        'ShopCurrenciesArchive.HtmlSign' => 'HTML_SIGN',
        'htmlSign' => 'HTML_SIGN',
        'shopCurrenciesArchive.htmlSign' => 'HTML_SIGN',
        'ShopCurrenciesArchiveTableMap::COL_HTML_SIGN' => 'HTML_SIGN',
        'COL_HTML_SIGN' => 'HTML_SIGN',
        'html_sign' => 'HTML_SIGN',
        'shop_currencies_archive.html_sign' => 'HTML_SIGN',
        'RoundPrice' => 'ROUND_PRICE',
        'ShopCurrenciesArchive.RoundPrice' => 'ROUND_PRICE',
        'roundPrice' => 'ROUND_PRICE',
        'shopCurrenciesArchive.roundPrice' => 'ROUND_PRICE',
        'ShopCurrenciesArchiveTableMap::COL_ROUND_PRICE' => 'ROUND_PRICE',
        'COL_ROUND_PRICE' => 'ROUND_PRICE',
        'round_price' => 'ROUND_PRICE',
        'shop_currencies_archive.round_price' => 'ROUND_PRICE',
        'Displayed' => 'DISPLAYED',
        'ShopCurrenciesArchive.Displayed' => 'DISPLAYED',
        'displayed' => 'DISPLAYED',
        'shopCurrenciesArchive.displayed' => 'DISPLAYED',
        'ShopCurrenciesArchiveTableMap::COL_DISPLAYED' => 'DISPLAYED',
        'COL_DISPLAYED' => 'DISPLAYED',
        'shop_currencies_archive.displayed' => 'DISPLAYED',
        'Iso' => 'ISO',
        'ShopCurrenciesArchive.Iso' => 'ISO',
        'iso' => 'ISO',
        'shopCurrenciesArchive.iso' => 'ISO',
        'ShopCurrenciesArchiveTableMap::COL_ISO' => 'ISO',
        'COL_ISO' => 'ISO',
        'shop_currencies_archive.iso' => 'ISO',
        'RbkSync' => 'RBK_SYNC',
        'ShopCurrenciesArchive.RbkSync' => 'RBK_SYNC',
        'rbkSync' => 'RBK_SYNC',
        'shopCurrenciesArchive.rbkSync' => 'RBK_SYNC',
        'ShopCurrenciesArchiveTableMap::COL_RBK_SYNC' => 'RBK_SYNC',
        'COL_RBK_SYNC' => 'RBK_SYNC',
        'rbk_sync' => 'RBK_SYNC',
        'shop_currencies_archive.rbk_sync' => 'RBK_SYNC',
        'RoundMode' => 'ROUND_MODE',
        'ShopCurrenciesArchive.RoundMode' => 'ROUND_MODE',
        'roundMode' => 'ROUND_MODE',
        'shopCurrenciesArchive.roundMode' => 'ROUND_MODE',
        'ShopCurrenciesArchiveTableMap::COL_ROUND_MODE' => 'ROUND_MODE',
        'COL_ROUND_MODE' => 'ROUND_MODE',
        'round_mode' => 'ROUND_MODE',
        'shop_currencies_archive.round_mode' => 'ROUND_MODE',
        'ArchivedAt' => 'ARCHIVED_AT',
        'ShopCurrenciesArchive.ArchivedAt' => 'ARCHIVED_AT',
        'archivedAt' => 'ARCHIVED_AT',
        'shopCurrenciesArchive.archivedAt' => 'ARCHIVED_AT',
        'ShopCurrenciesArchiveTableMap::COL_ARCHIVED_AT' => 'ARCHIVED_AT',
        'COL_ARCHIVED_AT' => 'ARCHIVED_AT',
        'archived_at' => 'ARCHIVED_AT',
        'shop_currencies_archive.archived_at' => 'ARCHIVED_AT',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_currencies_archive');
        $this->setPhpName('ShopCurrenciesArchive');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\Currency\\ShopCurrenciesArchive');
        $this->setPackage('Shop.Infrastructure.Models.Currency');
        $this->setUseIdGenerator(false);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('name', 'Name', 'VARCHAR', false, 255, null);
        $this->addColumn('native', 'Native', 'CHAR', false, null, 'Y');
        $this->addColumn('position', 'Position', 'TINYINT', true, null, 0);
        $this->addColumn('html_sign', 'HtmlSign', 'CHAR', false, 10, null);
        $this->addColumn('round_price', 'RoundPrice', 'TINYINT', true, null, 0);
        $this->addColumn('displayed', 'Displayed', 'CHAR', false, null, 'Y');
        $this->addColumn('iso', 'Iso', 'CHAR', false, 10, null);
        $this->addColumn('rbk_sync', 'RbkSync', 'CHAR', false, null, 'N');
        $this->addColumn('round_mode', 'RoundMode', 'CHAR', false, null, 'ceil');
        $this->addColumn('archived_at', 'ArchivedAt', 'TIMESTAMP', false, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? ShopCurrenciesArchiveTableMap::CLASS_DEFAULT : ShopCurrenciesArchiveTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (ShopCurrenciesArchive object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = ShopCurrenciesArchiveTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = ShopCurrenciesArchiveTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + ShopCurrenciesArchiveTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ShopCurrenciesArchiveTableMap::OM_CLASS;
            /** @var ShopCurrenciesArchive $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            ShopCurrenciesArchiveTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = ShopCurrenciesArchiveTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = ShopCurrenciesArchiveTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var ShopCurrenciesArchive $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ShopCurrenciesArchiveTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ShopCurrenciesArchiveTableMap::COL_ID);
            $criteria->addSelectColumn(ShopCurrenciesArchiveTableMap::COL_NAME);
            $criteria->addSelectColumn(ShopCurrenciesArchiveTableMap::COL_NATIVE);
            $criteria->addSelectColumn(ShopCurrenciesArchiveTableMap::COL_POSITION);
            $criteria->addSelectColumn(ShopCurrenciesArchiveTableMap::COL_HTML_SIGN);
            $criteria->addSelectColumn(ShopCurrenciesArchiveTableMap::COL_ROUND_PRICE);
            $criteria->addSelectColumn(ShopCurrenciesArchiveTableMap::COL_DISPLAYED);
            $criteria->addSelectColumn(ShopCurrenciesArchiveTableMap::COL_ISO);
            $criteria->addSelectColumn(ShopCurrenciesArchiveTableMap::COL_RBK_SYNC);
            $criteria->addSelectColumn(ShopCurrenciesArchiveTableMap::COL_ROUND_MODE);
            $criteria->addSelectColumn(ShopCurrenciesArchiveTableMap::COL_ARCHIVED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.name');
            $criteria->addSelectColumn($alias . '.native');
            $criteria->addSelectColumn($alias . '.position');
            $criteria->addSelectColumn($alias . '.html_sign');
            $criteria->addSelectColumn($alias . '.round_price');
            $criteria->addSelectColumn($alias . '.displayed');
            $criteria->addSelectColumn($alias . '.iso');
            $criteria->addSelectColumn($alias . '.rbk_sync');
            $criteria->addSelectColumn($alias . '.round_mode');
            $criteria->addSelectColumn($alias . '.archived_at');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(ShopCurrenciesArchiveTableMap::COL_ID);
            $criteria->removeSelectColumn(ShopCurrenciesArchiveTableMap::COL_NAME);
            $criteria->removeSelectColumn(ShopCurrenciesArchiveTableMap::COL_NATIVE);
            $criteria->removeSelectColumn(ShopCurrenciesArchiveTableMap::COL_POSITION);
            $criteria->removeSelectColumn(ShopCurrenciesArchiveTableMap::COL_HTML_SIGN);
            $criteria->removeSelectColumn(ShopCurrenciesArchiveTableMap::COL_ROUND_PRICE);
            $criteria->removeSelectColumn(ShopCurrenciesArchiveTableMap::COL_DISPLAYED);
            $criteria->removeSelectColumn(ShopCurrenciesArchiveTableMap::COL_ISO);
            $criteria->removeSelectColumn(ShopCurrenciesArchiveTableMap::COL_RBK_SYNC);
            $criteria->removeSelectColumn(ShopCurrenciesArchiveTableMap::COL_ROUND_MODE);
            $criteria->removeSelectColumn(ShopCurrenciesArchiveTableMap::COL_ARCHIVED_AT);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.name');
            $criteria->removeSelectColumn($alias . '.native');
            $criteria->removeSelectColumn($alias . '.position');
            $criteria->removeSelectColumn($alias . '.html_sign');
            $criteria->removeSelectColumn($alias . '.round_price');
            $criteria->removeSelectColumn($alias . '.displayed');
            $criteria->removeSelectColumn($alias . '.iso');
            $criteria->removeSelectColumn($alias . '.rbk_sync');
            $criteria->removeSelectColumn($alias . '.round_mode');
            $criteria->removeSelectColumn($alias . '.archived_at');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(ShopCurrenciesArchiveTableMap::DATABASE_NAME)->getTable(ShopCurrenciesArchiveTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a ShopCurrenciesArchive or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or ShopCurrenciesArchive object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopCurrenciesArchiveTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\Currency\ShopCurrenciesArchive) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ShopCurrenciesArchiveTableMap::DATABASE_NAME);
            $criteria->add(ShopCurrenciesArchiveTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = ShopCurrenciesArchiveQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            ShopCurrenciesArchiveTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                ShopCurrenciesArchiveTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_currencies_archive table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return ShopCurrenciesArchiveQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a ShopCurrenciesArchive or Criteria object.
     *
     * @param mixed $criteria Criteria or ShopCurrenciesArchive object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopCurrenciesArchiveTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from ShopCurrenciesArchive object
        }


        // Set the correct dbName
        $query = ShopCurrenciesArchiveQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
