<?php


namespace Shop\Domain\Brand\Contracts;

use Repo\CrudRepositoryBuilderInterface;
use Shop\Domain\Brand\BrandCollection;

interface BrandRepositoryInterface extends CrudRepositoryBuilderInterface
{
    /**
     * @param int $shopId
     * @param array $ignore
     * @param array $orderAlias
     * @param bool $limit
     * @return BrandCollection
     */
    public function findWithImagesByShopIdWithoutHideBrands(int $shopId, array $ignore, array $orderAlias = [],
                                                            $limit = false): BrandCollection;
}