<?php

namespace Shop\Presentation\Modules\AdminCustomerOrdersSettings;

use Core\Form\ControlBuilder;
use Core\Form\FormBuilder;
use Core\Form\NiftyControlBuilder;
use Core\ModuleController;
use Diamond\Helpers\Form;
use Shop\Presentation\Config\Main;
use Shop\Infrastructure\Models\City\City;
use Shop\Infrastructure\Repositories\City\CityCriteria;
use Shop\Infrastructure\Repositories\City\CityRepository;
use Shop\Infrastructure\Repositories\CustomerGroup\CustomerGroupCriteria;
use Shop\Infrastructure\Repositories\CustomerGroup\CustomerGroupRepository;
use Shop\Infrastructure\Repositories\Region\RegionCriteria;
use Shop\Infrastructure\Repositories\Region\RegionRepository;
use Shop\Infrastructure\Repositories\State\StateCriteria;
use Shop\Infrastructure\Repositories\State\StateRepository;
use Shop\Infrastructure\Repositories\Stock\StockCriteria;
use Shop\Infrastructure\Repositories\Stock\StockRepository;

/**
 * Description of AdminCustomerOrdersSettings
 *
 * @author Diamond Code Generator
 */
class AdminCustomerOrdersSettings extends ModuleController
{

    public $tab = 1;

    protected $form;
    protected $controlBuilder;
    protected $mainConf;
    protected $customerGroupRepository;
    protected $regionRepository;
    protected $cityRepository;
    protected $stateRepository;
    protected $stockRepository;

    /**
     * AdminCustomerOrdersSettings constructor.
     * @param FormBuilder $form
     * @param ControlBuilder $controlBuilder
     * @param Main $mainConf
     * @param CustomerGroupRepository $customerGroupRepository
     * @param RegionRepository $regionRepository
     * @param CityRepository $cityRepository
     * @param StockRepository $stockRepository
     * @param StateRepository $stateRepository
     */
    public function __construct(FormBuilder             $form,
                                NiftyControlBuilder     $controlBuilder,
                                Main                    $mainConf,
                                CustomerGroupRepository $customerGroupRepository,
                                RegionRepository        $regionRepository,
                                CityRepository          $cityRepository,
                                StockRepository         $stockRepository,
                                StateRepository         $stateRepository)
    {
        $this->form = $form;
        $this->controlBuilder = $controlBuilder;
        $this->mainConf = $mainConf;
        $this->customerGroupRepository = $customerGroupRepository;
        $this->regionRepository = $regionRepository;
        $this->cityRepository = $cityRepository;
        $this->stateRepository = $stateRepository;
        $this->stockRepository = $stockRepository;
    }


    /**
     * @return string
     * @throws \Core\Exceptions\BaseException
     * @throws \Repo\Concrete\Exceptions\Collection
     */
    public function process(): string
    {
        $form = $this->form->buildSettingsForm($this->mainConf, 'main');
        $form->setClass('panel-body form-horizontal form-padding');
        $builder = $this->controlBuilder;

        $states = $this->stateRepository->findByCriteria(
            StateCriteria::create()
        );

        if (!$states->count()) {
            return Form::buildErrorMessage(sprintf(
                'Необходимо создать хотя бы одно состояние. %s',
                anchor('/admin/shop/other/states', 'Настроить')
            ));
        }

        $statesAr = Form::prepareDropdown($states);

        $regions = $this->regionRepository->findByCriteria(
            RegionCriteria::create()
        );
        $regionsAr = Form::prepareDropdown($regions);

        $customerGroups = $this->customerGroupRepository->findByCriteria(
            CustomerGroupCriteria::create()
        );

        $customerGroupsAr = Form::prepareDropdown($customerGroups);

        $regionId = null;
        $cityId = $this->mainConf->getDefaultCity();

        if (!input_post('defaultRegion') && $cityId) {
            /**
             * @var City $city
             */
            if (!$city = $this->cityRepository->findById($cityId)) {
                $regionId = null;
            } else {
                $regionId = $city->getRegionId();
            }

            $cities = $this->cityRepository->findByCriteria(
                CityCriteria::create()->setFilterByRegionId($regionId)
            );
            $citiesAr = Form::prepareDropdown($cities);
        } elseif (!$regionId = input_post('defaultRegion')) {
            $citiesAr = [null => 'город не выбран'];
        } else {
            $cities = $this->cityRepository->findByCriteria(
                CityCriteria::create()->setFilterByRegionId($regionId)
            );
            $citiesAr = Form::prepareDropdown($cities);
        }

        $stocks = $this->stockRepository->findByCriteria(
            StockCriteria::create()->setFilterByActive(true)
        );

        switch ($this->tab) {
            case 1:
                $form
                    ->addField(
                        $builder->buildInputSmall('wishfulSumOrderMonth'), 'Желаемая сумма заказов в месяц', '',
                        'используется для аналитики'
                    )
                    ->addField(
                        $builder->buildInputSmall('wishfulCountClientMonth'), 'Желаемое количество клиентов в месяц', '',
                        'используется для аналитики'
                    )
                    ->addField(
                        $builder->buildInputSmall('mobileMask'), 'Маска для сотового телефона', 'required',
                        'используется в формах регистрации, заказа'
                    )
                    ->addField(
                        $builder->buildInputLittle('customersBlockedInterval'), 'Интервал блокировки пользователей, дней'
                    )
                    ->addField(
                        $builder->buildDropdownUniform('default_customer_category', $customerGroupsAr), 'Группа клиентов по умолчанию', 'required',
                        'Назначается при регистрации'
                    )
                    ->addField(
                        $builder->buildDropdownUniform('defaultGuestGroup', $customerGroupsAr), 'Группа для гостей сайта', 'required',
                        'Для временных клиентов'
                    )
                    ->addField(
                        $builder->buildDropdownUniform('defaultContractorGroup', $customerGroupsAr), 'Группа для контрагентов', 'required',
                        'Для торговых точек, поставщков, складов'
                    )
                    ->addField(
                        $builder->buildNiftyDropdownChosen('defaultRegion', $regionsAr)
                            ->onChange('select_city(this,\'defaultCity\')')
                            ->setValue($regionId)
                            ->setId('region_id')
                        , 'Регион по умолчанию', 'required',
                        'Для скрытой регистрации из соц.сетей'
                    )
                    ->addField(
                        $builder->buildNiftyDropdownChosen('defaultCity', $citiesAr)
                            ->setValue($cityId)
                            ->setId('defaultCity')
                        , 'Город по умолчанию', 'required',
                        'Для скрытой регистрации из соц.сетей'
                    );
                break;

            case 2:
                $form
                    ->addField(
                        $builder->buildInputLittle('orderScoreSumm'), 'С какой суммы заказа начислять баллы', [], '0 баллы не начисляются'
                    )
                    ->addField(
                        $builder->buildInputLittle('orderScoreVolume'), 'Кол-во начисляемых баллов', '', 'за 1 еденицу валюты'
                    )
                    ->addField(
                        $builder->buildNiftyDropdownChosen('orderDiscountIgnoreCustomerGroups',
                            Form::prepareDropdownWithoutDef($customerGroups)), 'Не использовать скидки для групп', [],
                        'Скидки от суммы заказа'
                    )
                    ->addField(
                        $builder->buildInputLittle('minOrderSumm'), 'Минимальная сумма заказа, руб.'
                    )
                    ->addField(
                        $builder->buildDropdownUniform('stateDefault', $statesAr), 'Новые заказы клиентов', 'required',
                        'Состояние будет выставлено по умолчанию'
                    )
                    ->addField(
                        $builder->buildDropdownUniform('statePayment', $statesAr), 'Оплаченные заказы', 'required',
                        'Состояние при успешной онлайн оплате'
                    )
                    ->addField(
                        $builder->buildDropdownUniform('stateCancel', $statesAr), 'Отмененные заказы', 'required',
                        'Состояние не используется в расчетах'
                    )
                    ->addField(
                        $builder->buildDropdownUniform('stateProviderSend', $statesAr), 'Отправленные поставщику заказы', 'required',
                        'Состояние будет выставлено по умолчанию'
                    )
                    ->addField(
                        $builder->buildDropdownUniform('stateProviderDefault', $statesAr), 'Новые заказы поставщику', 'required',
                        'Состояние будет выставлено по умолчанию'
                    )
                    ->addField(
                        $builder->buildDropdownUniform('modeChangeOrderStates', [
                            Main::MODE_CHANGE_STATE_SINHLY => 'Независимая смена',
                            Main::MODE_CHANGE_STATE_FROM_ORDER => 'От заказа к позициям',
                            Main::MODE_CHANGE_STATE_FROM_POSITION => 'От позиций к заказу'
                        ]), 'Режим синхронизации состояний', 'required',
                        'Состояние заказа и состояния позиций'
                    );
                break;

            case 3:

                $form
                    ->addField(
                        $builder->buildInputSmall('moyskladLogin'), 'Логин к сервису'
                    )
                    ->addField(
                        $builder->buildInputPassword('moyskladPassword'), 'Пароль к сервису'
                    )
                    ->addField(
                        $builder->buildDropdownYNUniform('moyskladSyncOrders'), 'Отправлять заказы в мойсклад'
                    )
                    ->addField(
                        $builder->buildDropdownUniform('moyskladOrderStateId', $statesAr), 'Заказы готовые для синхронизации'
                    )
                    ->addField(
                        $builder->buildDropdownUniform('moyskladOrderStateSucessId', $statesAr), 'Успешно синхронизированные заказы'
                    )
                    ->addField(
                        $builder->buildInputSmall('moyskladRemoteStock'), 'Удаленный склад для заказов', null, 'Для новых заказов в МойСклад'
                    )
                    ->addField(
                        $builder->buildNiftyMultiSelect('moyskladSyncStockIds', $stocks->getDropdownList()),
                        'Заказы торговых точек'
                    );

                break;

            case 4:

                $form
                    ->addField(
                        $builder->buildDropdownYNUniform('bitrixSyncOrders'), 'Отправлять заказы в bitrix24'
                    )
                    ->addField(
                        $builder->buildInputSmall('bitrixUrl'), 'Адрес онлайн сервиса bitrix24', null, 'https://mysite.bitrix24.ru'
                    )
                    ->addField(
                        $builder->buildInputLittle('bitrixUserID'), 'Идентификатор пользователя', null, 'например 22'
                    )
                    ->addField(
                        $builder->buildInputSmall('bitrixWebHook'), 'Сгенерированный веб хук', null, 'например b1t694r1i4y81fzi'
                    )
                    ->addField(
                        $builder->buildInputLittle('bitrixAssignedById'), 'Пользователь на кого назначать заказы', null, 'например 22'
                    )
                    ->addField(
                        $builder->buildNiftyMultiSelect('bitrixSyncStockIds', $stocks->getDropdownList()),
                        'Заказы торговых точек'
                    )
                    ->addField(
                        $builder->buildDropdownUniform('bitrixOrderStateId', $statesAr), 'Заказы готовые для синхронизации'
                    )
                    ->addField(
                        $builder->buildDropdownUniform('bitrixOrderStateSuсcessId', $statesAr), 'Успешно синхронизированные заказы'
                    );
                break;

            default:

                throw new \RuntimeException('tab not iplemented');

        }


        return $form->render();
    }
}               