<?php declare(strict_types=1);

namespace Shop\Presentation\Controllers;

use Core\BaseController;
use Core\Concrete\RequestAwareTrait;
use Core\Contracts\RequestAwareInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

class RestController  extends BaseController implements RequestAwareInterface
{
    use RequestAwareTrait;

    protected function buildSuccessDelete(): JsonResponse
    {
        return new JsonResponse(null, JsonResponse::HTTP_NO_CONTENT);
    }

    protected function buildSuccessUpdate(): JsonResponse
    {
        return new JsonResponse([
            'status' => 'success'
        ], JsonResponse::HTTP_NO_CONTENT);
    }

    protected static function buildErrorJson(string $text): JsonResponse
    {
        return (new JsonResponse([
            'error' => $text
        ], Response::HTTP_BAD_REQUEST))->setEncodingOptions(JSON_UNESCAPED_UNICODE);
    }

    protected function buildJsonResponse(array $result): JsonResponse
    {
        return (new JsonResponse($result))->setEncodingOptions(JSON_UNESCAPED_UNICODE);
    }

    protected function buildPageNotFound(string $message): JsonResponse
    {
        return (new JsonResponse([
            'message' => $message
        ], JsonResponse::HTTP_NOT_FOUND))->setEncodingOptions(JSON_UNESCAPED_UNICODE);
    }

    protected function parseBody(): array
    {
        if (!$res = json_decode($this->request->getContent(), true)) {
            return [];
        }

        return $res;
    }

    protected function buildInvalidArgumentResponse(string $message): JsonResponse
    {
        return (new JsonResponse([
            'status' => 'error',
            'message' => $message
        ], JsonResponse::HTTP_BAD_REQUEST))->setEncodingOptions(JSON_UNESCAPED_UNICODE);
    }

}