<?php

namespace Shop\Infrastructure\Repositories\Payment;

use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use QueryBuilder\SearchCriteria;
use Repo\CollectionInterface;
use Repo\Concrete\AbstractCrudRepository;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\Payment\Contracts\PaymentEntityInterface;
use Shop\Domain\Payment\PaymentCollection;
use Shop\Infrastructure\Models\Payment\Payment;
use Shop\Infrastructure\Models\Payment\PaymentQuery;

/**
 * Class PaymentRepository
 * @package Shop\Infrastructure\Repositories\Payment
 */
class PaymentRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    /**
     * @param PaginationInterface|PaymentCriteriaInterface $criteria
     * @param SearchCriteria|PaymentQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        
    }

    /**
     * @return EntityInterface|PaymentEntityInterface
     */
    public static function createEntity(): \Repo\EntityInterface
    {
        return new Payment();
    }

    protected function createQuery(): ModelCriteria
    {
        return PaymentQuery::create();
    }

    protected function createCollection(): CollectionInterface
    {
        return new PaymentCollection();
    }
}