<?php

namespace Shop\Domain\CustomerOrder;

use Repo\Concrete\AbstractCollection;
use Shop\Domain\CustomerOrder\Contracts\CustomerOrderEntityInterface;

/**
* Description of CustomerOrder
*
* @author Diamond Code Generator
*/
class CustomerOrderCollection extends AbstractCollection
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return CustomerOrderEntityInterface::class;
    }


    public function getSum(): float
    {
        $sum = 0;
        foreach ($this->_entities as $entity) {
            $sum += $entity->getSum();
        }
        return $sum;
    }
}               