<?php


namespace Shop\Application\Shopping\MergeProducts;

/**
 * Class MergeProductsCommand
 * @package Shop\Presentation\Commands\Catalog\MergeProducts
 */
class MergeProductsCommand
{

    /**
     * @var array
     */
    protected $mergeProductsIds = [];

    /**
     * @var int
     */
    protected $targetProductId;


    public function __construct(array $mergeProductsIds, int $targetProductId)
    {
        $this->mergeProductsIds = $mergeProductsIds;

        $this->targetProductId = $targetProductId;
    }

    /**
     * @return array
     */
    public function getMergeProductsIds(): array
    {
        return $this->mergeProductsIds;
    }

    /**
     * @return int
     */
    public function getTargetProductId(): int
    {
        return $this->targetProductId;
    }

}