<?php


namespace Shop\Application\Office\SendNotifyCustomerPassword;

use Diamond\Application\Notification\NotificationService;

class SendNotifyCustomerPasswordHandler
{
    protected $notificationService;
    protected $commandBus;

    /**
     * SendNotifyCustomerPasswordHandler constructor.
     * @param NotificationService $notificationService
     */
    public function __construct(NotificationService $notificationService)
    {
        $this->notificationService = $notificationService;
    }

    /**
     * @param SendNotifyCustomerPasswordCommand $command
     * @throws \Repo\Concrete\Exceptions\Collection
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function handle(SendNotifyCustomerPasswordCommand $command): void
    {

        $customer = $command->getCustomer();
        $password = $command->getPassword();
        $data = array_change_key_case($customer->toArray());
        $data['code'] = $password;
        $data['email'] = $customer->getEmail();
        $data['name'] = $customer->getName();
        $this->notificationService->sendToEmailByReport('customer_password_recovery',$customer->getEmail(),$data);
    }
}