<?php


namespace Shop\Infrastructure\Repositories\PaymentTransaction;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\PaymentTransaction\Contracts\PaymentTransactionCriteriaInterface;

class PaymentTransactionCriteria extends AbstractCriteria implements PaymentTransactionCriteriaInterface
{
    /**
     * @var string|null
     */
    protected $filterByCode;

    /**
     * @var int|null
     */
    protected $filterByOrderId;

    /**
     * @return int|null
     */
    public function getFilterByOrderId(): ?int
    {
        return $this->filterByOrderId;
    }

    /**
     * @param int|null $filterByOrderId
     * @return PaymentTransactionCriteria
     */
    public function setFilterByOrderId(?int $filterByOrderId): PaymentTransactionCriteria
    {
        $this->filterByOrderId = $filterByOrderId;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getFilterByCode(): ?string
    {
        return $this->filterByCode;
    }

    /**
     * @param string|null $filterByCode
     * @return PaymentTransactionCriteria
     */
    public function setFilterByCode(?string $filterByCode): PaymentTransactionCriteria
    {
        $this->filterByCode = $filterByCode;
        return $this;
    }

    /**
     * @return PaymentTransactionCriteria
     */
    public static function create()
    {
        return new self;
    }

}