<?php


namespace Shop\Application\Office\SendNotifyCustomerRegistration;

use Core\Helpers\Date;
use Diamond\Application\Notification\NotificationService;
use Shop\Application\Notification\SendEmail\SendEmailCommand;

/**
 * Class SendNotifyCustomerRegistrationHandler
 * @package Shop\Presentation\UseCases\Notification
 */
class SendNotifyCustomerRegistrationHandler
{

    protected $notificationService;


    /**
     * SendNotifyCustomerRegistrationHandler constructor.
     * @param NotificationService $notificationService
     */
    public function __construct(NotificationService $notificationService)
    {
        $this->notificationService = $notificationService;
    }

    /**
     * @todo Избавиться от /personal/data
     *
     * @param SendNotifyCustomerRegistrationCommand $command
     * @throws \Repo\Concrete\Exceptions\Collection
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function handle(SendNotifyCustomerRegistrationCommand $command): void
    {
        $customer = $command->getCustomer();

        //Формируем сообщение
        $data = $customer->toArray();
        $data['region'] = $customer->getCustomerCity()->getCityRegion()->getName();
        $data['city'] = $customer->getCustomerCity()->getName();
        $data['code'] = $customer->getRegisterCode();
        $data['registred'] = date(Date::formatDisplay());
        $data['link'] = anchor('/personal/data', 'личном кабинете');
        $data['phone'] = $customer->getPhone();
        $data['group'] = $customer->getCustomerGroup()->getName();
        $data['address'] = $customer->getFullAddress();

        //отправляем уведомление клиенту
        $this->notificationService->sendToEmailByReport('client_registration',$customer->getEmail(),$data);

        //отправляем уведомление менеджеру
        $manager = $customer->getManager();
        $this->notificationService->sendToEmailByReport('client_registration_manager',$manager->getEmail(),$data);
    }
}