<?php

namespace Shop\Application\Office\CreateDealer;

/**
 * Description of DealerComplex
 *
 * @author Admin
 */
class DealerRequest
{

    //domain
    /**
     * @var string
     */
    protected $domainName;
    /**
     * @var string
     */
    protected $domainLang;
    /**
     * @var string
     */
    protected $domainDomain;
    //stock
    /**
     * @var string
     */
    protected $stockName;

    /**
     * @var int
     */
    protected $stockCityId;
    /**
     * @var string
     */
    protected $stockStreet;
    /**
     * @var string
     */
    protected $stockHouse;
    /**
     * @var string
     */
    protected $stockRoom;
    //contragent
    /**
     * @var string
     */
    protected $email;
    /**
     * @var string
     */
    protected $phone;
    //user
    /**
     * @var string
     */
    protected $userName;
    /**
     * @var string
     */
    protected $userEmail;
    /**
     * @var string
     */
    protected $userPassword;
    //copy
    /**
     * @var bool
     */
    protected $copyPages       = false;
    /**
     * @var bool
     */
    protected $copyMenu        = false;
    /**
     * @var bool
     */
    protected $copyContents    = false;
    /**
     * @var bool
     */
    protected $copyPromoblocks = false;
    /**
     * @var bool
     */
    protected $copyTemplates   = false;

    /**
     * @return string
     */
    public function getDomainName(): string
    {
        return $this->domainName;
    }

    /**
     * @param string $domainName
     * @return DealerRequest
     */
    public function setDomainName(string $domainName): DealerRequest
    {
        $this->domainName = $domainName;
        return $this;
    }

    /**
     * @return string
     */
    public function getDomainLang(): string
    {
        return $this->domainLang;
    }

    /**
     * @param string $domainLang
     * @return DealerRequest
     */
    public function setDomainLang(string $domainLang): DealerRequest
    {
        $this->domainLang = $domainLang;
        return $this;
    }

    /**
     * @return string
     */
    public function getDomainDomain(): string
    {
        return $this->domainDomain;
    }

    /**
     * @param string $domainDomain
     * @return DealerRequest
     */
    public function setDomainDomain(string $domainDomain): DealerRequest
    {
        $this->domainDomain = $domainDomain;
        return $this;
    }

    /**
     * @return string
     */
    public function getStockName(): string
    {
        return $this->stockName;
    }

    /**
     * @param string $stockName
     * @return DealerRequest
     */
    public function setStockName(string $stockName): DealerRequest
    {
        $this->stockName = $stockName;
        return $this;
    }

    /**
     * @return int
     */
    public function getStockCityId(): int
    {
        return $this->stockCityId;
    }

    /**
     * @param int $stockCityId
     * @return DealerRequest
     */
    public function setStockCityId(int $stockCityId): DealerRequest
    {
        $this->stockCityId = $stockCityId;
        return $this;
    }

    /**
     * @return string
     */
    public function getStockStreet(): string
    {
        return $this->stockStreet;
    }

    /**
     * @param string $stockStreet
     * @return DealerRequest
     */
    public function setStockStreet(string $stockStreet): DealerRequest
    {
        $this->stockStreet = $stockStreet;
        return $this;
    }

    /**
     * @return string
     */
    public function getStockHouse(): string
    {
        return $this->stockHouse;
    }

    /**
     * @param string $stockHouse
     * @return DealerRequest
     */
    public function setStockHouse(string $stockHouse): DealerRequest
    {
        $this->stockHouse = $stockHouse;
        return $this;
    }

    /**
     * @return string
     */
    public function getStockRoom(): string
    {
        return $this->stockRoom;
    }

    /**
     * @param string $stockRoom
     * @return DealerRequest
     */
    public function setStockRoom(string $stockRoom): DealerRequest
    {
        $this->stockRoom = $stockRoom;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return DealerRequest
     */
    public function setEmail(string $email): DealerRequest
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getPhone(): string
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     * @return DealerRequest
     */
    public function setPhone(string $phone): DealerRequest
    {
        $this->phone = $phone;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserName(): string
    {
        return $this->userName;
    }

    /**
     * @param string $userName
     * @return DealerRequest
     */
    public function setUserName(string $userName): DealerRequest
    {
        $this->userName = $userName;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserEmail(): string
    {
        return $this->userEmail;
    }

    /**
     * @param string $userEmail
     * @return DealerRequest
     */
    public function setUserEmail(string $userEmail): DealerRequest
    {
        $this->userEmail = $userEmail;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserPassword(): string
    {
        return $this->userPassword;
    }

    /**
     * @param string $userPassword
     * @return DealerRequest
     */
    public function setUserPassword(string $userPassword): DealerRequest
    {
        $this->userPassword = $userPassword;
        return $this;
    }

    /**
     * @return bool
     */
    public function isCopyPages(): bool
    {
        return $this->copyPages;
    }

    /**
     * @param bool $copyPages
     * @return DealerRequest
     */
    public function setCopyPages(bool $copyPages): DealerRequest
    {
        $this->copyPages = $copyPages;
        return $this;
    }

    /**
     * @return bool
     */
    public function isCopyMenu(): bool
    {
        return $this->copyMenu;
    }

    /**
     * @param bool $copyMenu
     * @return DealerRequest
     */
    public function setCopyMenu(bool $copyMenu): DealerRequest
    {
        $this->copyMenu = $copyMenu;
        return $this;
    }

    /**
     * @return bool
     */
    public function isCopyContents(): bool
    {
        return $this->copyContents;
    }

    /**
     * @param bool $copyContents
     * @return DealerRequest
     */
    public function setCopyContents(bool $copyContents): DealerRequest
    {
        $this->copyContents = $copyContents;
        return $this;
    }

    /**
     * @return bool
     */
    public function isCopyPromoblocks(): bool
    {
        return $this->copyPromoblocks;
    }

    /**
     * @param bool $copyPromoblocks
     * @return DealerRequest
     */
    public function setCopyPromoblocks(bool $copyPromoblocks): DealerRequest
    {
        $this->copyPromoblocks = $copyPromoblocks;
        return $this;
    }

    /**
     * @return bool
     */
    public function isCopyTemplates(): bool
    {
        return $this->copyTemplates;
    }

    /**
     * @param bool $copyTemplates
     * @return DealerRequest
     */
    public function setCopyTemplates(bool $copyTemplates): DealerRequest
    {
        $this->copyTemplates = $copyTemplates;
        return $this;
    }


}