<?php declare(strict_types=1);

namespace Shop\Application\Catalog\CreateProduct;

use Shop\Application\Catalog\UpdateProduct\UpdateProductCommand;
use Shop\Infrastructure\Models\Product\Product;
use spaceonfire\CommandBus\CommandBus;

class CreateProductHandler
{

    public function __construct( private CommandBus $commandBus)
    {
    }

    public function handle(CreateProductCommand $command): void
    {
        $product = new Product();
        $commandUpdate = new UpdateProductCommand(
            product:  $product,
            name: $command->getName(),
            sku: $command->getSku(),
            price: $command->getPrice(),
            brandId: $command->getBrandId(),
            categoryId: $command->getCategoryId(),
            images: $command->getImages(),
            description: $command->getDescription(),
            groupIds: $command->getGroupIds(),
            positionCollection: $command->getPositionCollection()
        );
        $commandUpdate->setLogger($command->getLogger());
        $this->commandBus->handle($commandUpdate);

        $command->setProductEntity($product);
    }


}