<?php declare(strict_types=1);

namespace Shop\Presentation\Transformers;

use League\Fractal\TransformerAbstract;
use Shop\Domain\Product\Contracts\ProductEntityInterface;
use Shop\Infrastructure\Models\Product\Product;

class ProductPositionTransformer extends TransformerAbstract
{
    /**
     * @param ProductEntityInterface|Product $cat
     * @return array
     */
    public function transform(ProductEntityInterface $product): array
    {
        $positions = [];

        foreach ($product->getPositions() as $position) {
            $positions[] = [
                'id' => $position->getId(),
                'description' => $position->getDesc(),
                'price' => $position->getPrice(),
                'remain' => $position->getRemain(),
            ];
        }

        return [
            'id' => $product->getId(),
            'article' => $product->getArticle(),
            'positions' => $positions
        ];
    }
}