<?php

namespace Shop\Presentation\Modules\AdminSyncLog;

use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Core\Form\ControlBuilder;
use Core\Helpers\Date;
use Core\ModuleController;
use DiamondTable\TableFactory;
use Shop\Domain\CustomerOrder\Contracts\CustomerOrderEntityInterface;
use Shop\Domain\SyncLog\Contracts\SyncLogEntityInterface;
use Shop\Infrastructure\Models\MoyskladSyncLogs\MoyskladSyncLogs;
use Shop\Infrastructure\Models\Order\Order;
use Shop\Infrastructure\Repositories\SyncLog\SyncLogCriteria;
use Shop\Infrastructure\Repositories\SyncLog\SyncLogRepository;

/**
 * Description of AdminMoySkladSyncLog
 *
 * @author Diamond Code Generator
 */
class AdminSyncLog extends ModuleController
{


    protected $syncLogRepository;
    protected $tableFactory;
    protected $controlBuilder;

    /**
     * AdminSyncLog constructor.
     * @param SyncLogRepository $moySkladSyncLogRepository
     * @param ControlBuilder $controlBuilder
     * @param TableFactory $tableFactory
     */
    public function __construct(SyncLogRepository $logRepository,
                                ControlBuilder $controlBuilder,
                                TableFactory $tableFactory)
    {
        $this->syncLogRepository = $logRepository;
        $this->tableFactory = $tableFactory;
        $this->controlBuilder = $controlBuilder;
    }

    /**
     * @return string
     * @throws \ReflectionException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     *
     */
    public function process(): string
    {

        $orderId = input_get('order_id');

        if (!$orderId) {
            return 'Id заказа не указан, нет доступа к таблице логов';
        }

        $table = $this->tableFactory
            ->buildAdminTable($this->syncLogRepository, SyncLogCriteria::create()->setFilterByOrderId($orderId))
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_ACTION)
            ->removeControlAccess(DataTableEngine::CONTROL_ACCESS_ADD);

        $table
            ->addColumn(
                (new ColumnTable('datetime', 'Дата синхронизации'))
                    ->setFormat($this, 'formatDatetime')
                    ->setWidth(20, true)
            )
            ->addColumn(
                (new ColumnTable('order', 'Заказ'))
                    ->setFormat($this, 'formatOrder')
                    ->setWidth(15, true)
            )
            ->addColumn(
                new ColumnTable('desc', 'Детализация')
            );

        return $table->render();
    }

    /**
     * @param SyncLogEntityInterface|MoyskladSyncLogs $model
     * @return string
     */
    public function formatOrder(SyncLogEntityInterface $model): string
    {
        return $model->getOrder()->getOrderCode();
    }

    /**
     * @param SyncLogEntityInterface $model
     * @return string
     */
    public function formatDatetime(SyncLogEntityInterface $model): string
    {
        return $model->getDatetime()->format(Date::formatDisplay());
    }
}               