<?php

namespace Shop\Presentation\Modules\AdminOrderPrint;

use Core\Concrete\RequestAwareTrait;
use Core\Contracts\RequestAwareInterface;
use Core\ModuleController;
use Diamond\Application\Notification\NotificationService;
use Diamond\Helpers\Form;
use Shop\Application\Shopping\ShoppingService;
use Shop\Infrastructure\Repositories\CustomerOrder\CustomerOrderRepository;
use Shop\Infrastructure\Repositories\ProviderOrder\ProviderOrderRepository;



/**
 * Description of AdminOrderPrint
 *
 * @author Diamond Code Generator
 */
class AdminOrderPrint extends ModuleController implements RequestAwareInterface
{

    use RequestAwareTrait;
    protected $notification;
    protected $shoppingService;
    protected $customerOrderRepository;
    protected $providerOrderRepository;


    public function __construct(NotificationService $notification,
                                ShoppingService $shoppingService,
                                CustomerOrderRepository $customerOrderRepository,
                                ProviderOrderRepository $providerOrderRepository
    )
    {
        $this->notification = $notification;
        $this->shoppingService = $shoppingService;
        $this->customerOrderRepository = $customerOrderRepository;
        $this->providerOrderRepository = $providerOrderRepository;
    }

    /**
     * @return string
     * @throws \ReflectionException
     * @throws \Repo\Concrete\Exceptions\Collection
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function process(): string
    {
        if (!input_get('id')) {
            return '';
        }

        if (input_get('type') === 'provider_order') {
            $order = $this->providerOrderRepository->findById(input_get('id'));
            $data = $this->shoppingService->prepareProviderOrderDataForReport($order);
            $message = $this->notification->createMessageByReport('provider_order_notify', $data);
        } else {
            $order = $this->customerOrderRepository->findById(input_get('id'));
            $data = $this->shoppingService->prepareCustomerOrderDataForReport($order);
            $message =  $this->notification->createMessageByReport('order_notify', $data);
        }


        return
            $this->render([
                'order' => $message->getContent(),
                'print' =>  Form::buildIcon('print')
            ]);
    }
}               