<?php


namespace Shop\Infrastructure\Repositories\PriceAccess;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\PriceAccess\Contracts\PriceAccessCriteriaInterface;
use Shop\Domain\PriceAccess\PriceAccessCollection;
use Shop\Infrastructure\Models\PriceAccess\PriceAccess;
use Shop\Infrastructure\Models\PriceAccess\PriceAccessQuery;

class PriceAccessRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
       return new PriceAccess();
    }

    protected function createQuery(): ModelCriteria
    {
        return PriceAccessQuery::create();
    }

    /**
     * @param PaginationInterface|PriceAccessCriteriaInterface $criteria
     * @param ModelCriteria|PriceAccessQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $dbCriteria
            ->_if($criteria->getFilterByShopId()!==null)
            ->filterByShopId($criteria->getFilterByShopId() . ' LIKE shop_id', Criteria::CUSTOM)
            ->_endif();
    }


    protected function createCollection(): CollectionInterface
    {
        return new PriceAccessCollection();
    }

}