<?php

namespace Shop\Infrastructure\Models\DraftProduct\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\DraftProduct\DraftProduct;
use Shop\Infrastructure\Models\DraftProduct\DraftProductQuery;


/**
 * This class defines the structure of the 'shop_product_drafts' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class DraftProductTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.DraftProduct.Map.DraftProductTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_product_drafts';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\DraftProduct\\DraftProduct';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.DraftProduct.DraftProduct';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 24;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 24;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_product_drafts.id';

    /**
     * the column name for the title field
     */
    public const COL_TITLE = 'shop_product_drafts.title';

    /**
     * the column name for the desc field
     */
    public const COL_DESC = 'shop_product_drafts.desc';

    /**
     * the column name for the short_desc field
     */
    public const COL_SHORT_DESC = 'shop_product_drafts.short_desc';

    /**
     * the column name for the article field
     */
    public const COL_ARTICLE = 'shop_product_drafts.article';

    /**
     * the column name for the price field
     */
    public const COL_PRICE = 'shop_product_drafts.price';

    /**
     * the column name for the weight field
     */
    public const COL_WEIGHT = 'shop_product_drafts.weight';

    /**
     * the column name for the img field
     */
    public const COL_IMG = 'shop_product_drafts.img';

    /**
     * the column name for the special field
     */
    public const COL_SPECIAL = 'shop_product_drafts.special';

    /**
     * the column name for the active field
     */
    public const COL_ACTIVE = 'shop_product_drafts.active';

    /**
     * the column name for the mt_title field
     */
    public const COL_MT_TITLE = 'shop_product_drafts.mt_title';

    /**
     * the column name for the mt_description field
     */
    public const COL_MT_DESCRIPTION = 'shop_product_drafts.mt_description';

    /**
     * the column name for the mt_keywords field
     */
    public const COL_MT_KEYWORDS = 'shop_product_drafts.mt_keywords';

    /**
     * the column name for the remains field
     */
    public const COL_REMAINS = 'shop_product_drafts.remains';

    /**
     * the column name for the udate field
     */
    public const COL_UDATE = 'shop_product_drafts.udate';

    /**
     * the column name for the cdate field
     */
    public const COL_CDATE = 'shop_product_drafts.cdate';

    /**
     * the column name for the pdate field
     */
    public const COL_PDATE = 'shop_product_drafts.pdate';

    /**
     * the column name for the ref field
     */
    public const COL_REF = 'shop_product_drafts.ref';

    /**
     * the column name for the min_quality field
     */
    public const COL_MIN_QUALITY = 'shop_product_drafts.min_quality';

    /**
     * the column name for the seazon field
     */
    public const COL_SEAZON = 'shop_product_drafts.seazon';

    /**
     * the column name for the product_id field
     */
    public const COL_PRODUCT_ID = 'shop_product_drafts.product_id';

    /**
     * the column name for the category_id field
     */
    public const COL_CATEGORY_ID = 'shop_product_drafts.category_id';

    /**
     * the column name for the brand_id field
     */
    public const COL_BRAND_ID = 'shop_product_drafts.brand_id';

    /**
     * the column name for the customer_id field
     */
    public const COL_CUSTOMER_ID = 'shop_product_drafts.customer_id';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Title', 'Desc', 'ShortDesc', 'Article', 'Price', 'Weight', 'Img', 'Special', 'Active', 'MtTitle', 'MtDescription', 'MtKeywords', 'Remains', 'dateUpdate', 'dateCreate', 'datePublic', 'Ref', 'MinQuality', 'Seazon', 'ProductId', 'CategoryId', 'BrandId', 'CustomerId', ],
        self::TYPE_CAMELNAME     => ['id', 'title', 'desc', 'shortDesc', 'article', 'price', 'weight', 'img', 'special', 'active', 'mtTitle', 'mtDescription', 'mtKeywords', 'remains', 'dateUpdate', 'dateCreate', 'datePublic', 'ref', 'minQuality', 'seazon', 'productId', 'categoryId', 'brandId', 'customerId', ],
        self::TYPE_COLNAME       => [DraftProductTableMap::COL_ID, DraftProductTableMap::COL_TITLE, DraftProductTableMap::COL_DESC, DraftProductTableMap::COL_SHORT_DESC, DraftProductTableMap::COL_ARTICLE, DraftProductTableMap::COL_PRICE, DraftProductTableMap::COL_WEIGHT, DraftProductTableMap::COL_IMG, DraftProductTableMap::COL_SPECIAL, DraftProductTableMap::COL_ACTIVE, DraftProductTableMap::COL_MT_TITLE, DraftProductTableMap::COL_MT_DESCRIPTION, DraftProductTableMap::COL_MT_KEYWORDS, DraftProductTableMap::COL_REMAINS, DraftProductTableMap::COL_UDATE, DraftProductTableMap::COL_CDATE, DraftProductTableMap::COL_PDATE, DraftProductTableMap::COL_REF, DraftProductTableMap::COL_MIN_QUALITY, DraftProductTableMap::COL_SEAZON, DraftProductTableMap::COL_PRODUCT_ID, DraftProductTableMap::COL_CATEGORY_ID, DraftProductTableMap::COL_BRAND_ID, DraftProductTableMap::COL_CUSTOMER_ID, ],
        self::TYPE_FIELDNAME     => ['id', 'title', 'desc', 'short_desc', 'article', 'price', 'weight', 'img', 'special', 'active', 'mt_title', 'mt_description', 'mt_keywords', 'remains', 'udate', 'cdate', 'pdate', 'ref', 'min_quality', 'seazon', 'product_id', 'category_id', 'brand_id', 'customer_id', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Title' => 1, 'Desc' => 2, 'ShortDesc' => 3, 'Article' => 4, 'Price' => 5, 'Weight' => 6, 'Img' => 7, 'Special' => 8, 'Active' => 9, 'MtTitle' => 10, 'MtDescription' => 11, 'MtKeywords' => 12, 'Remains' => 13, 'dateUpdate' => 14, 'dateCreate' => 15, 'datePublic' => 16, 'Ref' => 17, 'MinQuality' => 18, 'Seazon' => 19, 'ProductId' => 20, 'CategoryId' => 21, 'BrandId' => 22, 'CustomerId' => 23, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'title' => 1, 'desc' => 2, 'shortDesc' => 3, 'article' => 4, 'price' => 5, 'weight' => 6, 'img' => 7, 'special' => 8, 'active' => 9, 'mtTitle' => 10, 'mtDescription' => 11, 'mtKeywords' => 12, 'remains' => 13, 'dateUpdate' => 14, 'dateCreate' => 15, 'datePublic' => 16, 'ref' => 17, 'minQuality' => 18, 'seazon' => 19, 'productId' => 20, 'categoryId' => 21, 'brandId' => 22, 'customerId' => 23, ],
        self::TYPE_COLNAME       => [DraftProductTableMap::COL_ID => 0, DraftProductTableMap::COL_TITLE => 1, DraftProductTableMap::COL_DESC => 2, DraftProductTableMap::COL_SHORT_DESC => 3, DraftProductTableMap::COL_ARTICLE => 4, DraftProductTableMap::COL_PRICE => 5, DraftProductTableMap::COL_WEIGHT => 6, DraftProductTableMap::COL_IMG => 7, DraftProductTableMap::COL_SPECIAL => 8, DraftProductTableMap::COL_ACTIVE => 9, DraftProductTableMap::COL_MT_TITLE => 10, DraftProductTableMap::COL_MT_DESCRIPTION => 11, DraftProductTableMap::COL_MT_KEYWORDS => 12, DraftProductTableMap::COL_REMAINS => 13, DraftProductTableMap::COL_UDATE => 14, DraftProductTableMap::COL_CDATE => 15, DraftProductTableMap::COL_PDATE => 16, DraftProductTableMap::COL_REF => 17, DraftProductTableMap::COL_MIN_QUALITY => 18, DraftProductTableMap::COL_SEAZON => 19, DraftProductTableMap::COL_PRODUCT_ID => 20, DraftProductTableMap::COL_CATEGORY_ID => 21, DraftProductTableMap::COL_BRAND_ID => 22, DraftProductTableMap::COL_CUSTOMER_ID => 23, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'title' => 1, 'desc' => 2, 'short_desc' => 3, 'article' => 4, 'price' => 5, 'weight' => 6, 'img' => 7, 'special' => 8, 'active' => 9, 'mt_title' => 10, 'mt_description' => 11, 'mt_keywords' => 12, 'remains' => 13, 'udate' => 14, 'cdate' => 15, 'pdate' => 16, 'ref' => 17, 'min_quality' => 18, 'seazon' => 19, 'product_id' => 20, 'category_id' => 21, 'brand_id' => 22, 'customer_id' => 23, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'DraftProduct.Id' => 'ID',
        'id' => 'ID',
        'draftProduct.id' => 'ID',
        'DraftProductTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_product_drafts.id' => 'ID',
        'Title' => 'TITLE',
        'DraftProduct.Title' => 'TITLE',
        'title' => 'TITLE',
        'draftProduct.title' => 'TITLE',
        'DraftProductTableMap::COL_TITLE' => 'TITLE',
        'COL_TITLE' => 'TITLE',
        'shop_product_drafts.title' => 'TITLE',
        'Desc' => 'DESC',
        'DraftProduct.Desc' => 'DESC',
        'desc' => 'DESC',
        'draftProduct.desc' => 'DESC',
        'DraftProductTableMap::COL_DESC' => 'DESC',
        'COL_DESC' => 'DESC',
        'shop_product_drafts.desc' => 'DESC',
        'ShortDesc' => 'SHORT_DESC',
        'DraftProduct.ShortDesc' => 'SHORT_DESC',
        'shortDesc' => 'SHORT_DESC',
        'draftProduct.shortDesc' => 'SHORT_DESC',
        'DraftProductTableMap::COL_SHORT_DESC' => 'SHORT_DESC',
        'COL_SHORT_DESC' => 'SHORT_DESC',
        'short_desc' => 'SHORT_DESC',
        'shop_product_drafts.short_desc' => 'SHORT_DESC',
        'Article' => 'ARTICLE',
        'DraftProduct.Article' => 'ARTICLE',
        'article' => 'ARTICLE',
        'draftProduct.article' => 'ARTICLE',
        'DraftProductTableMap::COL_ARTICLE' => 'ARTICLE',
        'COL_ARTICLE' => 'ARTICLE',
        'shop_product_drafts.article' => 'ARTICLE',
        'Price' => 'PRICE',
        'DraftProduct.Price' => 'PRICE',
        'price' => 'PRICE',
        'draftProduct.price' => 'PRICE',
        'DraftProductTableMap::COL_PRICE' => 'PRICE',
        'COL_PRICE' => 'PRICE',
        'shop_product_drafts.price' => 'PRICE',
        'Weight' => 'WEIGHT',
        'DraftProduct.Weight' => 'WEIGHT',
        'weight' => 'WEIGHT',
        'draftProduct.weight' => 'WEIGHT',
        'DraftProductTableMap::COL_WEIGHT' => 'WEIGHT',
        'COL_WEIGHT' => 'WEIGHT',
        'shop_product_drafts.weight' => 'WEIGHT',
        'Img' => 'IMG',
        'DraftProduct.Img' => 'IMG',
        'img' => 'IMG',
        'draftProduct.img' => 'IMG',
        'DraftProductTableMap::COL_IMG' => 'IMG',
        'COL_IMG' => 'IMG',
        'shop_product_drafts.img' => 'IMG',
        'Special' => 'SPECIAL',
        'DraftProduct.Special' => 'SPECIAL',
        'special' => 'SPECIAL',
        'draftProduct.special' => 'SPECIAL',
        'DraftProductTableMap::COL_SPECIAL' => 'SPECIAL',
        'COL_SPECIAL' => 'SPECIAL',
        'shop_product_drafts.special' => 'SPECIAL',
        'Active' => 'ACTIVE',
        'DraftProduct.Active' => 'ACTIVE',
        'active' => 'ACTIVE',
        'draftProduct.active' => 'ACTIVE',
        'DraftProductTableMap::COL_ACTIVE' => 'ACTIVE',
        'COL_ACTIVE' => 'ACTIVE',
        'shop_product_drafts.active' => 'ACTIVE',
        'MtTitle' => 'MT_TITLE',
        'DraftProduct.MtTitle' => 'MT_TITLE',
        'mtTitle' => 'MT_TITLE',
        'draftProduct.mtTitle' => 'MT_TITLE',
        'DraftProductTableMap::COL_MT_TITLE' => 'MT_TITLE',
        'COL_MT_TITLE' => 'MT_TITLE',
        'mt_title' => 'MT_TITLE',
        'shop_product_drafts.mt_title' => 'MT_TITLE',
        'MtDescription' => 'MT_DESCRIPTION',
        'DraftProduct.MtDescription' => 'MT_DESCRIPTION',
        'mtDescription' => 'MT_DESCRIPTION',
        'draftProduct.mtDescription' => 'MT_DESCRIPTION',
        'DraftProductTableMap::COL_MT_DESCRIPTION' => 'MT_DESCRIPTION',
        'COL_MT_DESCRIPTION' => 'MT_DESCRIPTION',
        'mt_description' => 'MT_DESCRIPTION',
        'shop_product_drafts.mt_description' => 'MT_DESCRIPTION',
        'MtKeywords' => 'MT_KEYWORDS',
        'DraftProduct.MtKeywords' => 'MT_KEYWORDS',
        'mtKeywords' => 'MT_KEYWORDS',
        'draftProduct.mtKeywords' => 'MT_KEYWORDS',
        'DraftProductTableMap::COL_MT_KEYWORDS' => 'MT_KEYWORDS',
        'COL_MT_KEYWORDS' => 'MT_KEYWORDS',
        'mt_keywords' => 'MT_KEYWORDS',
        'shop_product_drafts.mt_keywords' => 'MT_KEYWORDS',
        'Remains' => 'REMAINS',
        'DraftProduct.Remains' => 'REMAINS',
        'remains' => 'REMAINS',
        'draftProduct.remains' => 'REMAINS',
        'DraftProductTableMap::COL_REMAINS' => 'REMAINS',
        'COL_REMAINS' => 'REMAINS',
        'shop_product_drafts.remains' => 'REMAINS',
        'dateUpdate' => 'UDATE',
        'DraftProduct.dateUpdate' => 'UDATE',
        'draftProduct.dateUpdate' => 'UDATE',
        'DraftProductTableMap::COL_UDATE' => 'UDATE',
        'COL_UDATE' => 'UDATE',
        'udate' => 'UDATE',
        'shop_product_drafts.udate' => 'UDATE',
        'dateCreate' => 'CDATE',
        'DraftProduct.dateCreate' => 'CDATE',
        'draftProduct.dateCreate' => 'CDATE',
        'DraftProductTableMap::COL_CDATE' => 'CDATE',
        'COL_CDATE' => 'CDATE',
        'cdate' => 'CDATE',
        'shop_product_drafts.cdate' => 'CDATE',
        'datePublic' => 'PDATE',
        'DraftProduct.datePublic' => 'PDATE',
        'draftProduct.datePublic' => 'PDATE',
        'DraftProductTableMap::COL_PDATE' => 'PDATE',
        'COL_PDATE' => 'PDATE',
        'pdate' => 'PDATE',
        'shop_product_drafts.pdate' => 'PDATE',
        'Ref' => 'REF',
        'DraftProduct.Ref' => 'REF',
        'ref' => 'REF',
        'draftProduct.ref' => 'REF',
        'DraftProductTableMap::COL_REF' => 'REF',
        'COL_REF' => 'REF',
        'shop_product_drafts.ref' => 'REF',
        'MinQuality' => 'MIN_QUALITY',
        'DraftProduct.MinQuality' => 'MIN_QUALITY',
        'minQuality' => 'MIN_QUALITY',
        'draftProduct.minQuality' => 'MIN_QUALITY',
        'DraftProductTableMap::COL_MIN_QUALITY' => 'MIN_QUALITY',
        'COL_MIN_QUALITY' => 'MIN_QUALITY',
        'min_quality' => 'MIN_QUALITY',
        'shop_product_drafts.min_quality' => 'MIN_QUALITY',
        'Seazon' => 'SEAZON',
        'DraftProduct.Seazon' => 'SEAZON',
        'seazon' => 'SEAZON',
        'draftProduct.seazon' => 'SEAZON',
        'DraftProductTableMap::COL_SEAZON' => 'SEAZON',
        'COL_SEAZON' => 'SEAZON',
        'shop_product_drafts.seazon' => 'SEAZON',
        'ProductId' => 'PRODUCT_ID',
        'DraftProduct.ProductId' => 'PRODUCT_ID',
        'productId' => 'PRODUCT_ID',
        'draftProduct.productId' => 'PRODUCT_ID',
        'DraftProductTableMap::COL_PRODUCT_ID' => 'PRODUCT_ID',
        'COL_PRODUCT_ID' => 'PRODUCT_ID',
        'product_id' => 'PRODUCT_ID',
        'shop_product_drafts.product_id' => 'PRODUCT_ID',
        'CategoryId' => 'CATEGORY_ID',
        'DraftProduct.CategoryId' => 'CATEGORY_ID',
        'categoryId' => 'CATEGORY_ID',
        'draftProduct.categoryId' => 'CATEGORY_ID',
        'DraftProductTableMap::COL_CATEGORY_ID' => 'CATEGORY_ID',
        'COL_CATEGORY_ID' => 'CATEGORY_ID',
        'category_id' => 'CATEGORY_ID',
        'shop_product_drafts.category_id' => 'CATEGORY_ID',
        'BrandId' => 'BRAND_ID',
        'DraftProduct.BrandId' => 'BRAND_ID',
        'brandId' => 'BRAND_ID',
        'draftProduct.brandId' => 'BRAND_ID',
        'DraftProductTableMap::COL_BRAND_ID' => 'BRAND_ID',
        'COL_BRAND_ID' => 'BRAND_ID',
        'brand_id' => 'BRAND_ID',
        'shop_product_drafts.brand_id' => 'BRAND_ID',
        'CustomerId' => 'CUSTOMER_ID',
        'DraftProduct.CustomerId' => 'CUSTOMER_ID',
        'customerId' => 'CUSTOMER_ID',
        'draftProduct.customerId' => 'CUSTOMER_ID',
        'DraftProductTableMap::COL_CUSTOMER_ID' => 'CUSTOMER_ID',
        'COL_CUSTOMER_ID' => 'CUSTOMER_ID',
        'customer_id' => 'CUSTOMER_ID',
        'shop_product_drafts.customer_id' => 'CUSTOMER_ID',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_product_drafts');
        $this->setPhpName('DraftProduct');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\DraftProduct\\DraftProduct');
        $this->setPackage('Shop.Infrastructure.Models.DraftProduct');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('title', 'Title', 'VARCHAR', true, 255, null);
        $this->addColumn('desc', 'Desc', 'LONGVARCHAR', false, null, null);
        $this->addColumn('short_desc', 'ShortDesc', 'VARCHAR', false, 255, null);
        $this->addColumn('article', 'Article', 'VARCHAR', false, 120, null);
        $this->addColumn('price', 'Price', 'DECIMAL', false, 19, null);
        $this->addColumn('weight', 'Weight', 'DECIMAL', false, 19, null);
        $this->addColumn('img', 'Img', 'VARCHAR', false, 255, null);
        $this->addColumn('special', 'Special', 'CHAR', true, null, 'N');
        $this->addColumn('active', 'Active', 'CHAR', true, null, 'Y');
        $this->addColumn('mt_title', 'MtTitle', 'VARCHAR', false, 255, null);
        $this->addColumn('mt_description', 'MtDescription', 'LONGVARCHAR', false, null, null);
        $this->addColumn('mt_keywords', 'MtKeywords', 'LONGVARCHAR', false, null, null);
        $this->addColumn('remains', 'Remains', 'CHAR', false, 5, null);
        $this->addColumn('udate', 'dateUpdate', 'TIMESTAMP', false, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('cdate', 'dateCreate', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('pdate', 'datePublic', 'TIMESTAMP', false, null, null);
        $this->addColumn('ref', 'Ref', 'INTEGER', false, null, null);
        $this->addColumn('min_quality', 'MinQuality', 'VARCHAR', false, 10, null);
        $this->addColumn('seazon', 'Seazon', 'VARCHAR', false, 50, null);
        $this->addForeignKey('product_id', 'ProductId', 'INTEGER', 'shop_products', 'id', false, null, null);
        $this->addForeignKey('category_id', 'CategoryId', 'INTEGER', 'shop_categories', 'id', true, null, null);
        $this->addForeignKey('brand_id', 'BrandId', 'INTEGER', 'shop_brands', 'id', true, null, null);
        $this->addForeignKey('customer_id', 'CustomerId', 'INTEGER', 'shop_customer', 'id', true, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('Product', '\\Shop\\Infrastructure\\Models\\Product\\Product', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':product_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Category', '\\Shop\\Infrastructure\\Models\\Category\\Category', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':category_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Brand', '\\Shop\\Infrastructure\\Models\\Brand\\Brand', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':brand_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Customer', '\\Shop\\Infrastructure\\Models\\Customer\\Customer', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':customer_id',
    1 => ':id',
  ),
), null, null, null, false);
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? DraftProductTableMap::CLASS_DEFAULT : DraftProductTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (DraftProduct object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = DraftProductTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = DraftProductTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + DraftProductTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = DraftProductTableMap::OM_CLASS;
            /** @var DraftProduct $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            DraftProductTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = DraftProductTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = DraftProductTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var DraftProduct $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                DraftProductTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(DraftProductTableMap::COL_ID);
            $criteria->addSelectColumn(DraftProductTableMap::COL_TITLE);
            $criteria->addSelectColumn(DraftProductTableMap::COL_DESC);
            $criteria->addSelectColumn(DraftProductTableMap::COL_SHORT_DESC);
            $criteria->addSelectColumn(DraftProductTableMap::COL_ARTICLE);
            $criteria->addSelectColumn(DraftProductTableMap::COL_PRICE);
            $criteria->addSelectColumn(DraftProductTableMap::COL_WEIGHT);
            $criteria->addSelectColumn(DraftProductTableMap::COL_IMG);
            $criteria->addSelectColumn(DraftProductTableMap::COL_SPECIAL);
            $criteria->addSelectColumn(DraftProductTableMap::COL_ACTIVE);
            $criteria->addSelectColumn(DraftProductTableMap::COL_MT_TITLE);
            $criteria->addSelectColumn(DraftProductTableMap::COL_MT_DESCRIPTION);
            $criteria->addSelectColumn(DraftProductTableMap::COL_MT_KEYWORDS);
            $criteria->addSelectColumn(DraftProductTableMap::COL_REMAINS);
            $criteria->addSelectColumn(DraftProductTableMap::COL_UDATE);
            $criteria->addSelectColumn(DraftProductTableMap::COL_CDATE);
            $criteria->addSelectColumn(DraftProductTableMap::COL_PDATE);
            $criteria->addSelectColumn(DraftProductTableMap::COL_REF);
            $criteria->addSelectColumn(DraftProductTableMap::COL_MIN_QUALITY);
            $criteria->addSelectColumn(DraftProductTableMap::COL_SEAZON);
            $criteria->addSelectColumn(DraftProductTableMap::COL_PRODUCT_ID);
            $criteria->addSelectColumn(DraftProductTableMap::COL_CATEGORY_ID);
            $criteria->addSelectColumn(DraftProductTableMap::COL_BRAND_ID);
            $criteria->addSelectColumn(DraftProductTableMap::COL_CUSTOMER_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.title');
            $criteria->addSelectColumn($alias . '.desc');
            $criteria->addSelectColumn($alias . '.short_desc');
            $criteria->addSelectColumn($alias . '.article');
            $criteria->addSelectColumn($alias . '.price');
            $criteria->addSelectColumn($alias . '.weight');
            $criteria->addSelectColumn($alias . '.img');
            $criteria->addSelectColumn($alias . '.special');
            $criteria->addSelectColumn($alias . '.active');
            $criteria->addSelectColumn($alias . '.mt_title');
            $criteria->addSelectColumn($alias . '.mt_description');
            $criteria->addSelectColumn($alias . '.mt_keywords');
            $criteria->addSelectColumn($alias . '.remains');
            $criteria->addSelectColumn($alias . '.udate');
            $criteria->addSelectColumn($alias . '.cdate');
            $criteria->addSelectColumn($alias . '.pdate');
            $criteria->addSelectColumn($alias . '.ref');
            $criteria->addSelectColumn($alias . '.min_quality');
            $criteria->addSelectColumn($alias . '.seazon');
            $criteria->addSelectColumn($alias . '.product_id');
            $criteria->addSelectColumn($alias . '.category_id');
            $criteria->addSelectColumn($alias . '.brand_id');
            $criteria->addSelectColumn($alias . '.customer_id');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(DraftProductTableMap::COL_ID);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_TITLE);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_DESC);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_SHORT_DESC);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_ARTICLE);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_PRICE);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_WEIGHT);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_IMG);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_SPECIAL);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_ACTIVE);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_MT_TITLE);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_MT_DESCRIPTION);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_MT_KEYWORDS);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_REMAINS);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_UDATE);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_CDATE);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_PDATE);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_REF);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_MIN_QUALITY);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_SEAZON);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_PRODUCT_ID);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_CATEGORY_ID);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_BRAND_ID);
            $criteria->removeSelectColumn(DraftProductTableMap::COL_CUSTOMER_ID);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.title');
            $criteria->removeSelectColumn($alias . '.desc');
            $criteria->removeSelectColumn($alias . '.short_desc');
            $criteria->removeSelectColumn($alias . '.article');
            $criteria->removeSelectColumn($alias . '.price');
            $criteria->removeSelectColumn($alias . '.weight');
            $criteria->removeSelectColumn($alias . '.img');
            $criteria->removeSelectColumn($alias . '.special');
            $criteria->removeSelectColumn($alias . '.active');
            $criteria->removeSelectColumn($alias . '.mt_title');
            $criteria->removeSelectColumn($alias . '.mt_description');
            $criteria->removeSelectColumn($alias . '.mt_keywords');
            $criteria->removeSelectColumn($alias . '.remains');
            $criteria->removeSelectColumn($alias . '.udate');
            $criteria->removeSelectColumn($alias . '.cdate');
            $criteria->removeSelectColumn($alias . '.pdate');
            $criteria->removeSelectColumn($alias . '.ref');
            $criteria->removeSelectColumn($alias . '.min_quality');
            $criteria->removeSelectColumn($alias . '.seazon');
            $criteria->removeSelectColumn($alias . '.product_id');
            $criteria->removeSelectColumn($alias . '.category_id');
            $criteria->removeSelectColumn($alias . '.brand_id');
            $criteria->removeSelectColumn($alias . '.customer_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(DraftProductTableMap::DATABASE_NAME)->getTable(DraftProductTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a DraftProduct or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or DraftProduct object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(DraftProductTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\DraftProduct\DraftProduct) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(DraftProductTableMap::DATABASE_NAME);
            $criteria->add(DraftProductTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = DraftProductQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            DraftProductTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                DraftProductTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_product_drafts table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return DraftProductQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a DraftProduct or Criteria object.
     *
     * @param mixed $criteria Criteria or DraftProduct object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(DraftProductTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from DraftProduct object
        }


        // Set the correct dbName
        $query = DraftProductQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
