<?php

namespace Shop\Presentation\Modules\AdminProviders;

use Diamond\Helpers\Form;
use Shop\Domain\Provider\Contracts\ProviderEntityInterface;
use Shop\Infrastructure\Models\Customer\Customer;

trait ColumnsFormatTrait
{

    /**
     * @param ProviderEntityInterface $providerEntity
     * @return string
     */
    public function formatContractor(ProviderEntityInterface $providerEntity): string
    {
        /**
         * @var Customer $contractor
         */
        if($providerEntity->getContractorId() > 0){
            $contractor = $providerEntity->getContractor();

            $name = $contractor->getName() . ', ' .$contractor->getFullAddress() .', '. $contractor->getEmail() .
                ', '.$contractor->getPhone();

            return anchor('/admin/shop/stocks/contractors',$name,[],[
                'fn'    => 'edit',
                'id'    => $providerEntity->getContractorId()
            ]);
        }
        return Form::buildIcon('alert','Контрагент не определен.');
    }

    /**
     * @param ProviderEntityInterface $provider
     * @return mixed
     */
    public function formatCurrency(ProviderEntityInterface $provider)
    {
        return $provider->getCurrency()->getHtmlSign();
    }
}