<?php declare(strict_types=1);

namespace Shop\Presentation;


use Core\Console\Application;
use Core\Contracts\ServiceProviderInterface;

use Core\Template\Template;
use Diamond\Application\Mailing\MailingRecipientsCollection;
use Diamond\Config\Main;


use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;


use Psr\Container\ContainerInterface;
use Shop\Application\Analytics\CreateTransaction\CreateTransactionCommand;
use Shop\Application\Analytics\CreateTransaction\CreateTransactionHandler;
use Shop\Application\Catalog\CatalogService;
use Shop\Application\Notification\SendEmail\SendEmailCommand;
use Shop\Application\Notification\SendEmail\SendEmailHandler;
use Shop\Application\Office\AuthCustomer\AuthCustomerCommand;
use Shop\Application\Office\AuthCustomer\AuthCustomerHandler;
use Shop\Application\Office\ChangeCustomerPassword\ChangeCustomerPasswordCommand;
use Shop\Application\Office\ChangeCustomerPassword\ChangeCustomerPasswordHandler;
use Shop\Application\Office\CreateDealer\CreateDealerCommand;
use Shop\Application\Office\CreateDealer\CreateDealerHandler;
use Shop\Application\Office\CustomerRegistration\CustomerRegistrationCommand;
use Shop\Application\Office\CustomerRegistration\CustomerRegistrationHandler;
use Shop\Application\Office\OfficeService;
use Shop\Application\Office\SendNotifyCustomerPassword\SendNotifyCustomerPasswordCommand;
use Shop\Application\Office\SendNotifyCustomerPassword\SendNotifyCustomerPasswordHandler;
use Shop\Application\Office\SendNotifyCustomerRegistration\SendNotifyCustomerRegistrationCommand;
use Shop\Application\Office\SendNotifyCustomerRegistration\SendNotifyCustomerRegistrationHandler;
use Shop\Application\Shopping\ChangeOrderItemState\ChangeOrderItemStateCommand;
use Shop\Application\Shopping\ChangeOrderItemState\ChangeOrderItemStateHandler;
use Shop\Application\Shopping\ChangeOrderState\ChangeOrderStateCommand;
use Shop\Application\Shopping\ChangeOrderState\ChangeOrderStateHandler;
use Shop\Application\Shopping\CreateCustomerOrder\CreateCustomerOrderCommand;
use Shop\Application\Shopping\CreateCustomerOrder\CreateCustomerOrderHandler;

use Shop\Application\Shopping\CreateFileFromOrderItems\CreateFileFromOrderItemsCommand;
use Shop\Application\Shopping\CreateFileFromOrderItems\CreateFileFromOrderItemsHandler;
use Shop\Application\Shopping\CreateProviderOrder\CreateProviderOrderHandler;
use Shop\Application\Shopping\CreateProviderOrdersFromCustomerOrderItem\CreateProviderOrdersFromCustomerOrderItemCommand;
use Shop\Application\Shopping\CreateProviderOrdersFromCustomerOrderItem\CreateProviderOrdersFromCustomerOrderItemHandler;
use Shop\Application\Shopping\MergeCustomerOrders\MergeCustomerOrdersCommand;
use Shop\Application\Shopping\MergeCustomerOrders\MergeCustomerOrdersHandler;
use Shop\Application\Shopping\MergeProducts\MergeProductsCommand;
use Shop\Application\Shopping\MergeProducts\MergeProductsHandler;
use Shop\Application\Shopping\MergeProviderOrders\MergeProviderOrdersCommand;
use Shop\Application\Shopping\MergeProviderOrders\MergeProviderOrdersHandler;
use Shop\Application\Shopping\PrepareCustomerOrderDataForReport\PrepareCustomerOrderDataForReportCommand;
use Shop\Application\Shopping\PrepareCustomerOrderDataForReport\PrepareCustomerOrderDataForReportHandler;
use Shop\Application\Shopping\PrepareProviderOrderDataForReport\PrepareProviderOrderDataForReportCommand;
use Shop\Application\Shopping\PrepareProviderOrderDataForReport\PrepareProviderOrderDataForReportHandler;
use Shop\Application\Shopping\ResetOrderState\ResetOrderStateCommand;
use Shop\Application\Shopping\ResetOrderState\ResetOrderStateHandler;
use Shop\Application\Shopping\SendCustomerOrders\SendCustomerOrdersCommand;
use Shop\Application\Shopping\SendCustomerOrders\SendCustomerOrdersHandler;
use Shop\Application\Shopping\SendNotifyAboutPostCode\SendNotifyAboutPostCodeCommand;
use Shop\Application\Shopping\SendNotifyAboutPostCode\SendNotifyAboutPostCodeHandler;
use Shop\Application\Shopping\SendNotifyAboutState\SendNotifyAboutStateCommand;
use Shop\Application\Shopping\SendNotifyAboutState\SendNotifyAboutStateHandler;
use Shop\Application\Shopping\SendNotifyOrderChangeState\SendNotifyOrderChangeStateCommand;
use Shop\Application\Shopping\SendNotifyOrderChangeState\SendNotifyOrderChangeStateHandler;
use Shop\Application\Shopping\SendProviderOrders\SendProviderOrdersCommand;
use Shop\Application\Shopping\SendProviderOrders\SendProviderOrdersHandler;
use Shop\Presentation\Commands\Sitemap;
use Shop\Presentation\Controllers\CategoryController;
use Shop\Presentation\Controllers\CityController;
use Shop\Presentation\Controllers\OrderController;
use Shop\Presentation\Controllers\RegionController;
use Shop\Presentation\Controllers\StateController;
use Shop\Presentation\Controllers\StockController;
use Shop\Domain\Brand\Contracts\BrandRepositoryInterface;
use Shop\Domain\Product\Contracts\ProductRepositoryInterface;
use Shop\Domain\Product\Contracts\ProductThumbCreaterInterface;
use Shop\Domain\Product\ProductService;
use Shop\Domain\ProductCategory\Contracts\ProductCategoryRepositoryInterface;


use Shop\Application\Basket\AddItemInCurrentBasket\AddItemInCurrentBasketCommand;
use Shop\Application\Basket\AddItemInCurrentBasket\AddItemInCurrentBasketHandler;
use Shop\Application\Shopping\CreateProviderOrder\CreateProviderOrderCommand;
use Shop\Infrastructure\Repositories\Brand\BrandRepository;
use Shop\Infrastructure\Repositories\Product\ProductRepository;
use Shop\Infrastructure\Repositories\ProductCategory\ProductCategoryRepository;


use Shop\Presentation\Services\Customer\CustomerService;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Session\Storage\NativeSessionStorage;
use Twig\Environment;


/**
 * Description of SystemServiceProvider
 *
 * @author Dmitriy
 */
class ServiceProvider extends AbstractServiceProvider implements ServiceProviderInterface
{

    protected $provides = [
        \Core\Basket\Basket::class,
        BrandRepositoryInterface::class,
        ProductCategoryRepositoryInterface::class,
        ProductRepositoryInterface::class,
        ProductThumbCreaterInterface::class,
        'current_customer'
    ];

    /**
     * @return array
     */
    public static function getRoutes(): array
    {
        return [
            [['GET', 'POST'], '/_service/shop/cities', [CityController::class, 'index']],
            [['GET', 'POST'], '/_service/shop/regions', [RegionController::class, 'index']],
            [['GET'], '/_service/shop/stocks', [StockController::class, 'index']],
            [['GET'], '/_service/shop/order/{id}/state/image', [OrderController::class, 'stateImage']],
            [['GET'], '/_service/shop/order/aggregate_sum_day', [OrderController::class, 'aggregateSumDay']],
            [['GET'], '/_service/shop/catalog/category/{id}', [CategoryController::class, 'show']]
        ];
    }

    public static function getConsoleCommandMap(): array
    {
        return [
            Sitemap::class
        ];
    }

    public static function getAdminNavigation(): array
    {
        return [
            'Интернет-магазин' => [
                'clients' => [
                    'label' => 'Клиенты',
                    'icon' => 'fa fa-user',
                    'items' => [
                        'client_list' => [
                            'label' => 'Справочник клиентов',
                            'url' => admin_path('/shop/customers/customers'),
                        ],
                        'client_groups' => [
                            'label' => 'Группы клиентов',
                            'url' => admin_path('/shop/customers/customer_groups'),
                        ],
                        'client_guests' => [
                            'label' => 'Гости',
                            'url' => admin_path('/shop/customers/guests'),
                        ]
                    ]
                ],
                'orders' => [
                    'label' => 'Заказы клиентов',
                    'icon' => 'fa fa-shopping-cart',
                    'items' => [
                        'client_orders' => [
                            'label' => 'Заказы',
                            'url' => admin_path('/shop/customers/orders'),
                        ],
                        'client_order_items' => [
                            'label' => 'Позиции заказов',
                            'url' => admin_path('/shop/customers/order_items'),
                        ],
                        'order_states' => [
                            'label' => 'Состояния заказов',
                            'url' => admin_path('/shop/other/states'),
                        ],
                        'basket' => [
                            'label' => 'Корзины клиентов',
                            'url' => admin_path('/shop/customers/carts'),
                        ],
                        'transactions' => [
                            'label' => 'Транзакции оплат',
                            'url' => admin_path('/shop/customers/paymaster_trans'),
                        ]
                    ]
                ],

                'complex_rates' => [
                    'label' => 'Ценообразование',
                    'icon' => 'fa fa-usd',
                    'items' => [
                        'currencies' => [
                            'label' => 'Валюты',
                            'url' => admin_path('/shop/other/currencies'),
                        ],
                        'complex_rates' => [
                            'label' => 'Ценообразование',
                            'url' => admin_path('/shop/other/complex_rates'),
                        ],
                        'max_discounts' => [
                            'label' => 'Макс. скидки',
                            'url' => admin_path('/shop/other/max_discounts'),
                        ],
                        'discounts' => [
                            'label' => 'Скидки для заказа',
                            'url' => admin_path('/shop/other/discounts'),
                        ]
                    ]
                ],

                'stocks' => [
                    'label' => 'Офисы',
                    'icon' => 'fa fa-map-marker',
                    'items' => [
                        'stocks' => [
                            'label' => 'Офисы',
                            'url' => admin_path('/shop/stocks/stocks'),
                        ],
                        'managers' => [
                            'label' => 'Менеджеры',
                            'url' => admin_path('/shop/stocks/managers'),
                        ],
                        'contractors' => [
                            'label' => 'Контрагенты',
                            'url' => admin_path('/shop/stocks/contractors'),
                            'related' => [
                                admin_path('/shop/stocks/contractors-lite'),
                            ]
                        ]
                    ]
                ],

                'catalog' => [
                    'label' => 'Номенклатура',
                    'icon' => 'fa fa-sitemap',
                    'items' => [
                        'stocks' => [
                            'label' => 'Производители',
                            'url' => admin_path('/shop/catalog/brands'),
                        ],
                        'products' => [
                            'label' => 'Товары',
                            'url' => admin_path('/shop/catalog/products'),
                        ],
                        'product_groups' => [
                            'label' => 'Группы товаров',
                            'url' => admin_path('/shop/catalog/groups'),
                        ],
                        'catalogs' => [
                            'label' => 'Каталоги',
                            'url' => admin_path('/shop/catalog/catalogs'),
                        ],
                        'categories' => [
                            'label' => 'Категорий товаров',
                            'url' => admin_path('/shop/catalog/categories'),
                        ],
                    ]
                ],
                'providers' => [
                    'label' => 'Поставщики',
                    'icon' => 'fa fa-newspaper-o',
                    'items' => [
                        'providers' => [
                            'label' => 'Поставщики',
                            'url' => admin_path('/shop/stocks/providers'),
                        ],
                        'contractors' => [
                            'label' => 'Контрагенты',
                            'url' => admin_path('/shop/stocks/contractors'),
                        ],
                        'provider_orders' => [
                            'label' => 'Заказы поставщиков',
                            'url' => admin_path('/shop/customers/provider_orders'),
                        ],
                        'provider_order_items' => [
                            'label' => 'Содержимое заказов',
                            'url' => admin_path('/shop/customers/provider_order_items'),
                        ],
                    ]
                ],

                'prices' => [
                    'label' => 'Прайс-листы',
                    'icon' => 'fa fa-newspaper-o',
                    'items' => [
                        'providers' => [
                            'label' => 'Прайс-файлы',
                            'url' => admin_path('/shop/catalog/price-files'),
                        ],
                        'contractors' => [
                            'label' => 'Прайс-листы',
                            'url' => admin_path('/shop/catalog/price-scheets'),
                        ],
                        'provider_orders' => [
                            'label' => 'Содержимое прайс-листов',
                            'url' => admin_path('/shop/catalog/positions'),
                        ],
                        'price-access' => [
                            'label' => 'Права доступа',
                            'url' => admin_path('/shop/catalog/price-access'),
                        ],
                    ]
                ],

                'delivery' => [
                    'label' => 'Логистика',
                    'icon' => 'fa fa-truck',
                    'items' => [
                        'countries' => [
                            'label' => 'География',
                            'url' => admin_path('/shop/other/countries'),
                            'related' => [
                                admin_path('/shop/other/cities'),
                                admin_path('/shop/other/regions')
                            ]
                        ],
                        'delivery' => [
                            'label' => 'Виды доставки',
                            'url' => admin_path('/shop/other/delivery'),
                        ],
                    ]
                ],

                'settings' => [
                    'label' => 'Настройки',
                    'icon' => 'fa fa-gear',
                    'items' => [
                        'customers' => [
                            'label' => 'Заказы и клиенты',
                            'url' => admin_path('/shop/customers/settings'),
                            'related' => [
                                admin_path('/shop/customers/settings_positions'),
                                admin_path('/shop/customers/settings_moysklad'),
                                admin_path('/shop/customers/settings_bitrix24')
                            ]
                        ],
                        'paymaster' => [
                            'label' => 'PayMaster',
                            'url' => admin_path('/shop/customers/settings_paymaster'),
                        ],
                        'cms' => [
                            'label' => 'СМС',
                            'url' => admin_path('/shop/customers/settings_sms'),
                        ],
                        'stocks' => [
                            'label' => 'Офисы',
                            'url' => admin_path('/shop/stocks/settings'),
                        ],
                        'catalog' => [
                            'label' => 'Номеклатура',
                            'url' => admin_path('/shop/catalog/settings'),
                        ],
                        'other' => [
                            'label' => 'Прочее',
                            'url' => admin_path('/shop/other/settings_main'),
                        ],
                        'payments' => [
                            'label' => 'Способы оплаты',
                            'url' => admin_path('/shop/other/payments'),
                        ],
                        'state_logs' => [
                            'label' => 'Лог смены состояний',
                            'url' => admin_path('/shop/other/state_logs'),
                        ],
                    ]
                ],

            ]
        ];
    }

    public static function getPermissions(): array
    {
        return [
            // Клиенты -------------------------------
            'shop.clients_customers.read' => [
                'tab' => 'Интернет-магазин - Клиенты - Справочник клиентов',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.clients_customer_groups.read' => [
                'tab' => 'Интернет-магазин - Клиенты - Группы клиентов',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.clients_guests.read' => [
                'tab' => 'Интернет-магазин - Клиенты - Гости',
                'label' => 'Чтение',
                'order' => 1
            ],
            // Заказы -------------------------------
            'shop.clients_orders.read' => [
                'tab' => 'Интернет-магазин - Заказы - Заказы клиентов',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.provider_order_items.read' => [
                'tab' => 'Интернет-магазин - Заказы - Содержимое заказов',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.clients_states.read' => [
                'tab' => 'Интернет-магазин - Заказы - Состояния заказов',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.clients_baskets.read' => [
                'tab' => 'Интернет-магазин - Заказы - Корзины клиентов',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.clients_paymaster_trans.read' => [
                'tab' => 'Интернет-магазин - Заказы - Транзакции оплат',
                'label' => 'Чтение',
                'order' => 1
            ],
            // Ценообразование -------------------------------
            'shop.currencies.read' => [
                'tab' => 'Интернет-магазин - Ценообразование - Валюты',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.complex_rates.read' => [
                'tab' => 'Интернет-магазин - Ценообразование - Ценообразование',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.max_discounts.read' => [
                'tab' => 'Интернет-магазин - Ценообразование - Макс. скидки',
                'label' => 'Чтение',
                'order' => 1
            ],
            // Офисы -------------------------------
            'shop.stocks.read' => [
                'tab' => 'Интернет-магазин - Офисы - Офисы',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.managers.read' => [
                'tab' => 'Интернет-магазин - Офисы - Менеджеры',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.contractors.read' => [
                'tab' => 'Интернет-магазин - Офисы - Контрагенты',
                'label' => 'Чтение',
                'order' => 1
            ],
            // Номенклатура -------------------------------
            'shop.brands.read' => [
                'tab' => 'Интернет-магазин - Номенклатура - Производители',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.products.read' => [
                'tab' => 'Интернет-магазин - Номенклатура - Товары',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.product_groups.read' => [
                'tab' => 'Интернет-магазин - Номенклатура - Группы товаров',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.catalogs.read' => [
                'tab' => 'Интернет-магазин - Номенклатура - Каталоги',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.categories.read' => [
                'tab' => 'Интернет-магазин - Номенклатура - Категорий товаров',
                'label' => 'Чтение',
                'order' => 1
            ],
            // Поставщики -------------------------------
            'shop.providers.read' => [
                'tab' => 'Интернет-магазин - Поставщики - Поставщики',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.provider_orders.read' => [
                'tab' => 'Интернет-магазин - Поставщики - Заказы поставщиков',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.price_scheets.read' => [
                'tab' => 'Интернет-магазин - Поставщики - Прайс-листы',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.price_access.read' => [
                'tab' => 'Интернет-магазин - Поставщики - Права доступа',
                'label' => 'Чтение',
                'order' => 1
            ],
            // Логистика -------------------------------
            'shop.geografy.read' => [
                'tab' => 'Интернет-магазин - Логистика - География',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.delivery.read' => [
                'tab' => 'Интернет-магазин - Логистика - Виды доставки',
                'label' => 'Чтение',
                'order' => 1
            ],
            // Настройки -------------------------------
            'shop.settings_customers.read' => [
                'tab' => 'Интернет-магазин - Настройки - Заказы и клиенты',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.settings_paymaster.read' => [
                'tab' => 'Интернет-магазин - Настройки - PayMaster',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.settings_sms.read' => [
                'tab' => 'Интернет-магазин - Настройки - СМС',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.settings_stocks.read' => [
                'tab' => 'Интернет-магазин - Настройки - Офисы',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.settings_catalog.read' => [
                'tab' => 'Интернет-магазин - Настройки - Номеклатура',
                'label' => 'Чтение',
                'order' => 1
            ],
            'shop.settings_main.read' => [
                'tab' => 'Интернет-магазин - Настройки - Прочее',
                'label' => 'Чтение',
                'order' => 1
            ],
        ];
    }

    public static function getControllerPermissions(): array
    {
        return [
            admin_path('/shop/other/settings_main') => [
                'shop.settings_main.read',
            ],
            admin_path('/shop/catalog/settings') => [
                'shop.settings_catalog.read',
            ],
            admin_path('/shop/stocks/settings') => [
                'shop.settings_stocks.read',
            ],
            admin_path('/shop/customers/settings_sms') => [
                'shop.settings_sms.read',
            ],
            admin_path('/shop/customers/settings_paymaster') => [
                'shop.settings_paymaster.read',
            ],
            admin_path('/shop/customers/settings_bitrix24') => [
                'shop.settings_customers.read',
            ],
            admin_path('/shop/customers/settings_moysklad') => [
                'shop.settings_customers.read',
            ],
            admin_path('/shop/customers/settings_positions') => [
                'shop.settings_customers.read',
            ],
            admin_path('/shop/customers/settings') => [
                'shop.settings_customers.read',
            ],
            admin_path('/shop/other/delivery') => [
                'shop.delivery.read',
            ],
            admin_path('/shop/other/cities') => [
                'shop.geografy.read',
            ],
            admin_path('/shop/other/regions') => [
                'shop.geografy.read',
            ],
            admin_path('/shop/other/countries') => [
                'shop.geografy.read',
            ],
            admin_path('/shop/catalog/price-access') => [
                'shop.price_access.read'
            ],
            admin_path('/shop/catalog/price-scheets') => [
                'shop.price_scheets.read'
            ],
            admin_path('/shop/customers/provider_orders') => [
                'shop.provider_orders.read'
            ],
            admin_path('/shop/customers/order_items') => [
                'shop.provider_order_items.read'
            ],
            admin_path('/shop/stocks/providers') => [
                'shop.providers.read'
            ],
            admin_path('/shop/catalog/categories') => [
                'shop.categories.read'
            ],
            admin_path('/shop/catalog/catalogs') => [
                'shop.catalogs.read'
            ],
            admin_path('/shop/catalog/groups') => [
                'shop.product_groups.read'
            ],
            admin_path('/shop/catalog/products') => [
                'shop.products.read'
            ],
            admin_path('/shop/catalog/brands') => [
                'shop.brands.read'
            ],
            admin_path('/shop/stocks/contractors-lite') => [
                'shop.contractors.read'
            ],
            admin_path('/shop/stocks/contractors') => [
                'shop.contractors.read'
            ],
            admin_path('/shop/stocks/managers') => [
                'shop.managers.read'
            ],
            admin_path('/shop/stocks/stocks') => [
                'shop.stocks.read'
            ],
            admin_path('/shop/other/discounts') => [
                'shop.discounts.read'
            ],
            admin_path('/shop/other/max_discounts') => [
                'shop.max_discounts.read'
            ],
            admin_path('/shop/other/complex_rates') => [
                'shop.complex_rates.read'
            ],
            admin_path('/shop/other/currencies') => [
                'shop.currencies.read'
            ],
            admin_path('/shop/customers/paymaster_trans') => [
                'shop.clients_paymaster_trans.read'
            ],
            admin_path('/shop/customers/baskets') => [
                'shop.clients_baskets.read'
            ],
            admin_path('/shop/other/states') => [
                'shop.clients_states.read'
            ],
            admin_path('/shop/customers/orders') => [
                'shop.clients_orders.read'
            ],
            admin_path('/shop/customers/guests') => [
                'shop.clients_guests.read'
            ],
            admin_path('/shop/customers/customers') => [
                'shop.clients_customers.read'
            ],
            admin_path('/shop/customers/customer_groups') => [
                'shop.clients_customer_groups.read'
            ],
        ];
    }


    /**
     * @return array
     */
    public static function getCommandBusMap(): array
    {
        return [
            //Analitic
            CreateTransactionCommand::class => [CreateTransactionHandler::class, 'handle'],

            //Basket
            AddItemInCurrentBasketCommand::class => [AddItemInCurrentBasketHandler::class, 'handle'],

            //Office
            AuthCustomerCommand::class => [AuthCustomerHandler::class, 'handle'],
            CustomerRegistrationCommand::class => [CustomerRegistrationHandler::class, 'handle'],
            ChangeCustomerPasswordCommand::class => [ChangeCustomerPasswordHandler::class, 'handle'],
            SendNotifyCustomerPasswordCommand::class => [SendNotifyCustomerPasswordHandler::class, 'handle'],
            SendNotifyCustomerRegistrationCommand::class => [SendNotifyCustomerRegistrationHandler::class, 'handle'],
            CreateDealerCommand::class => [CreateDealerHandler::class, 'handle'],
            //Shopping
            ChangeOrderItemStateCommand::class => [ChangeOrderItemStateHandler::class, 'handle'],
            ChangeOrderStateCommand::class => [ChangeOrderStateHandler::class, 'handle'],

            CreateCustomerOrderCommand::class => [CreateCustomerOrderHandler::class, 'handle'],
            CreateFileFromOrderItemsCommand::class => [CreateFileFromOrderItemsHandler::class, 'handle'],
            CreateProviderOrderCommand::class => [CreateProviderOrderHandler::class, 'handle'],
            CreateProviderOrdersFromCustomerOrderItemCommand::class => [CreateProviderOrdersFromCustomerOrderItemHandler::class, 'handle'],
            MergeCustomerOrdersCommand::class => [MergeCustomerOrdersHandler::class, 'handle'],
            MergeProductsCommand::class => [MergeProductsHandler::class, 'handle'],
            MergeProviderOrdersCommand::class => [MergeProviderOrdersHandler::class, 'handle'],
            PrepareCustomerOrderDataForReportCommand::class => [PrepareCustomerOrderDataForReportHandler::class, 'handle'],
            PrepareProviderOrderDataForReportCommand::class => [PrepareProviderOrderDataForReportHandler::class, 'handle'],
            ResetOrderStateCommand::class => [ResetOrderStateHandler::class, 'handle'],
            SendCustomerOrdersCommand::class => [SendCustomerOrdersHandler::class, 'handle'],
            SendNotifyAboutPostCodeCommand::class => [SendNotifyAboutPostCodeHandler::class, 'handle'],
            SendNotifyAboutStateCommand::class => [SendNotifyAboutStateHandler::class, 'handle'],
            SendNotifyOrderChangeStateCommand::class => [SendNotifyOrderChangeStateHandler::class, 'handle'],
            SendProviderOrdersCommand::class => [SendProviderOrdersHandler::class, 'handle'],
            \Shop\Application\Payment\CreateTransaction\CreateTransactionCommand::class => [\Shop\Application\Payment\CreateTransaction\CreateTransactionHandler::class, 'handle']
        ];
    }


    public function register()
    {
        $di = $this->getContainer();

        $di->add(BrandRepositoryInterface::class, BrandRepository::class);
        $di->add(ProductCategoryRepositoryInterface::class, ProductCategoryRepository::class);
        $di->add(ProductRepositoryInterface::class, ProductRepository::class);
        $di->share('current_customer', function () use ($di) {
            return $di->get(OfficeService::class)->getCurrentCustomer();
        });

        $di->share(ProductThumbCreaterInterface::class, function () use ($di) {
            return $di->get(CatalogService::class);
        });

        /**
         * set Debug bar
         */
        $di->add(Session::class, function () use ($di) {
            $lifetime = $di->get(Main::class)->getSessionLife();
            if (!$lifetime) {
                $lifetime = 1;//час
            }
            session_set_cookie_params($lifetime * 60 * 60);

            return new Session(
                new NativeSessionStorage([
                    //"cache_expire" => $lifetime*10*60*60,
                    // "cookie_domain"=>   Url::createQookieMainDomain(),
                    'cookie_lifetime' => $lifetime * 60 * 60,
                    'gc_maxlifetime' => $lifetime * 60 * 60
                ])
            );
        }, true);

        $di->add(\Core\Basket\Basket::class, null, true)
            ->addArgument($di->get(Session::class));

    }

    /**
     * @return string
     */
    public static function getPackageName(): string
    {
        return 'shop';
    }

    /**
     * @return string
     */
    public static function getViewsPath(): string
    {
        return __DIR__ . '/Views/';
    }




    public function afterInit(ContainerInterface $container): void
    {
        $container
            ->get(Environment::class)
            ->addExtension(
                new TwigExtension()
            );

        /**
         * @var Template $template
         */
        $container->get(Template::class)->addStyleLink('/_diamond/shop/assets/css/custom.css');

        $container
            ->get(MailingRecipientsCollection::class)
            ->push(new CustomersAllRecipients())
            ->push(new CustomersNoAuthRecipients())
            ->push(new CustomersOnlyAuthRecipients())
            ->push(new CustomersBlockedRecipients());
    }

}
