<?php


namespace Shop\Domain\Provider;


class ContractorRequest
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $email;

    /**
     * @var string
     */
    protected $phone;

    /**
     * @var int
     */
    protected $countryId;


    /**
     * @var int
     */
    protected $regionId;


    /**
     * @var int
     */
    protected $cityId;

    /**
     * @var int
     */
    protected $groupId;

    /**
     * @var int
     */
    protected $managerId;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ContractorRequest
     */
    public function setName(string $name): ContractorRequest
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return ContractorRequest
     */
    public function setEmail(string $email): ContractorRequest
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getPhone(): string
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     * @return ContractorRequest
     */
    public function setPhone(string $phone): ContractorRequest
    {
        $this->phone = $phone;
        return $this;
    }

    /**
     * @return int
     */
    public function getCountryId(): int
    {
        return $this->countryId;
    }

    /**
     * @param int $countryId
     * @return ContractorRequest
     */
    public function setCountryId(int $countryId): ContractorRequest
    {
        $this->countryId = $countryId;
        return $this;
    }

    /**
     * @return int
     */
    public function getRegionId(): int
    {
        return $this->regionId;
    }

    /**
     * @param int $regionId
     * @return ContractorRequest
     */
    public function setRegionId(int $regionId): ContractorRequest
    {
        $this->regionId = $regionId;
        return $this;
    }

    /**
     * @return int
     */
    public function getCityId(): int
    {
        return $this->cityId;
    }

    /**
     * @param int $cityId
     * @return ContractorRequest
     */
    public function setCityId(int $cityId): ContractorRequest
    {
        $this->cityId = $cityId;
        return $this;
    }

    /**
     * @return int
     */
    public function getGroupId(): int
    {
        return $this->groupId;
    }

    /**
     * @param int $groupId
     * @return ContractorRequest
     */
    public function setGroupId(int $groupId): ContractorRequest
    {
        $this->groupId = $groupId;
        return $this;
    }

    /**
     * @return int
     */
    public function getManagerId(): int
    {
        return $this->managerId;
    }

    /**
     * @param int $managerId
     * @return ContractorRequest
     */
    public function setManagerId(int $managerId): ContractorRequest
    {
        $this->managerId = $managerId;
        return $this;
    }


}