<?php

namespace Shop\Presentation\Modules\AdminCategoriesLite;

use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Core\Form\Control\MenuItemWindowSelect;
use Core\ModuleController;
use Shop\Domain\ProductCategory\Contracts\ProductCategoryEntityInterface;
use Shop\Infrastructure\Models\Category\Category;
use Shop\Presentation\Modules\AdminCategories\AdminCategories;
use Shop\Presentation\Modules\Traits\FormatterTrait;

/**
 * Description of AdminCategoriesLite
 *
 * @author Diamond Code Generator
 */
class AdminCategoriesLite extends AdminCategories
{

    use FormatterTrait;

    protected function prepareColumns(DataTableEngine $table): void
    {
        $table
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_SELECT)
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_ACTION)
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
//            ->addColumn(
//                (new ColumnTable('parent', 'Родитель'))
//                    ->setFormat($this, 'formatParent')
//                    ->setWidth(10, true)
//            )
            ->addColumn(
                (new ColumnTable('title', 'Наименование'))
                    ->setFormat($this, 'formatTitle')
            )
            ->addColumn(
                (new ColumnTable('alias', 'Псевдоним'))
            )
            ->addColumn(
                (new ColumnTable('image', 'Изображение'))
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(120)
                    ->setFormat($this, 'formatSelect')
            );
    }

    /**
     * @param ProductCategoryEntityInterface|Category $model
     * @return string
     */
    public function formatSelect(ProductCategoryEntityInterface $model): string
    {
        $items = [];
        $items[] = new MenuItemWindowSelect($model->getNameWithParentName(), 'categoryId', $model->getId());
        return parent::formatActions($model, $items);
    }
}               