<?php

namespace Shop\Infrastructure\Repositories\StateLog;

use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\StateLog\Contracts\StateLogCriteriaInterface;
use Shop\Domain\StateLog\StateLogCollection;
use Shop\Infrastructure\Models\StateLog\StateLog;
use Shop\Infrastructure\Models\StateLog\StateLogQuery;

class StateLogRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface

{
    /**
     * @return EntityInterface
     */
    public static function createEntity(): EntityInterface
    {
        return new StateLog();
    }

    /**
     * @return ModelCriteria
     */
    protected function createQuery(): ModelCriteria
    {
        return StateLogQuery::create();
    }

    /**
     * @param PaginationInterface|StateLogCriteriaInterface $criteria
     * @param ModelCriteria|StateLogQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        
        $dbCriteria
            ->_if($criteria->getFilterByObjectId()!==null)
            ->filterByObjectId($criteria->getFilterByObjectId())
            ->_endif()
            ;
    }

    protected function createCollection(): CollectionInterface
    {
        return new StateLogCollection();
    }
}