<?php


namespace Shop\Infrastructure\Repositories\ProviderOrderItem;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\ProviderOrderItem\Contracts\ProviderOrderItemCriteriaInterface;

class ProviderOrderItemCriteria extends AbstractCriteria implements ProviderOrderItemCriteriaInterface
{
    /**
     * @var string|null
     */
    protected $sortById;

    /**
     * @var string|null
     */
    protected $filterByorderCode;
    /**
     * @var string|null
     */
    protected $searchByName;
    /**
     * @var string|null
     */
    protected $searchByArticle;
    /**
     * @var string|null
     */
    protected $searchByBrand;
    /**
     * @var int|null
     */
    protected $filterByProviderId;
    /**
     * @var int|null
     */
    protected $filterByStateId;

    /**
     * @var array|null
     */
    protected $filterByOrderIds;

    public static function create()
    {
        return new self();
    }

    /**
     * @return array|null
     */
    public function getFilterByOrderIds(): ?array
    {
        return $this->filterByOrderIds;
    }

    /**
     * @param array|null $filterByOrderIds
     * @return ProviderOrderItemCriteria
     */
    public function setFilterByOrderIds(?array $filterByOrderIds): ProviderOrderItemCriteria
    {
        $this->filterByOrderIds = $filterByOrderIds;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSortById(): ?string
    {
        return $this->sortById;
    }

    /**
     * @return string|null
     */
    public function getFilterByorderCode(): ?string
    {
        return $this->filterByorderCode;
    }

    /**
     * @param string|null $filterByorderCode
     * @return ProviderOrderItemCriteria
     */
    public function setFilterByorderCode(?string $filterByorderCode): ProviderOrderItemCriteria
    {
        $this->filterByorderCode = $filterByorderCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return ProviderOrderItemCriteria
     */
    public function setSearchByName(?string $searchByName): ProviderOrderItemCriteria
    {
        $this->searchByName = $searchByName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByArticle(): ?string
    {
        return $this->searchByArticle;
    }

    /**
     * @param string|null $searchByArticle
     * @return ProviderOrderItemCriteria
     */
    public function setSearchByArticle(?string $searchByArticle): ProviderOrderItemCriteria
    {
        $this->searchByArticle = $searchByArticle;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByBrand(): ?string
    {
        return $this->searchByBrand;
    }

    /**
     * @param string|null $searchByBrand
     * @return ProviderOrderItemCriteria
     */
    public function setSearchByBrand(?string $searchByBrand): ProviderOrderItemCriteria
    {
        $this->searchByBrand = $searchByBrand;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByProviderId(): ?int
    {
        return $this->filterByProviderId;
    }

    /**
     * @param int|null $filterByProviderId
     * @return ProviderOrderItemCriteria
     */
    public function setFilterByProviderId(?int $filterByProviderId): ProviderOrderItemCriteria
    {
        $this->filterByProviderId = $filterByProviderId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByStateId(): ?int
    {
        return $this->filterByStateId;
    }

    /**
     * @param int|null $filterByStateId
     * @return ProviderOrderItemCriteria
     */
    public function setFilterByStateId(?int $filterByStateId): ProviderOrderItemCriteria
    {
        $this->filterByStateId = $filterByStateId;
        return $this;
    }
}