<?php declare(strict_types=1);

namespace Shop\Infrastructure\Repositories\ProductGroup;

use Repo\Concrete\AbstractCriteria;
use Shop\Domain\ProductGroup\Contracts\ProductGroupCriteriaInterface;

class ProductGroupCriteria extends AbstractCriteria implements ProductGroupCriteriaInterface
{
    private string|null $filterByName = null;
    
    public static function create()
    {
        return new self;
    }

    public function getFilterByName(): ?string
    {
        return $this->filterByName;
    }

    public function setFilterByName(?string $filterByName): ProductGroupCriteriaInterface
    {
        $this->filterByName = $filterByName;
        return $this;
    }

}