<?php


namespace Shop\Infrastructure\Repositories\City;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\City\CityCollection;
use Shop\Domain\City\Contracts\CityCriteriaInterface;
use Shop\Infrastructure\Models\City\City;
use Shop\Infrastructure\Models\City\CityQuery;

class CityRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new City();
    }

    protected function createQuery(): ModelCriteria
    {
        return CityQuery::create();
    }

    /**
     * @param PaginationInterface|CityCriteriaInterface $criteria
     * @param ModelCriteria|CityQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dbCriteria
            ->_if($criteria->getFilterByName() !== null)
            ->filterByName($criteria->getFilterByName())
            ->_endif()
            ->_if($criteria->getFilterByCountryId() !== null)
            ->useCityRegionQuery()
            ->filterByCountryId($criteria->getFilterByCountryId())
            ->endUse()
            ->_endif()
            ->_if($criteria->getSortByName() !== null)
            ->orderByName($criteria->getSortByName())
            ->_endif()
            ->_if($criteria->getSearchByName() !== null)
            ->filterByName('%' . $criteria->getSearchByName() . '%', Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getFilterByRegionId() !== null)
            ->filterByRegionId($criteria->getFilterByRegionId())
            ->_endif();
    }


    protected function createCollection(): CollectionInterface
    {
        return new CityCollection();
    }

}