<?php

namespace Shop\Application\Basket\AddItemInCurrentBasket;

/**
 * Для создания
 *
 * @author Admin
 */
class BasketItemRequest
{

    /**
     * @var float
     */
    protected $price;
    /**
     * @var int
     */
    protected $amount;
    /**
     * @var string|null
     */
    protected $name;
    /**
     * @var string|null
     */
    protected $article;
    /**
     * @var string|null
     */
    protected $desc;
    /**
     * @var string|null
     */
    protected $ref;

    /**
     * @var string|null
     */
    protected $brand;
    /**
     * @var string|null
     */
    protected $providerId;
    /**
     * @var string|null
     */
    protected $menagerComment;
    /**
     * @var string|null
     */
    protected $destination;

    /**
     * @return float
     */
    public function getPrice(): float
    {
        return $this->price;
    }

    /**
     * @param float $price
     * @return BasketItemRequest
     */
    public function setPrice(float $price): BasketItemRequest
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return int
     */
    public function getAmount(): int
    {
        return $this->amount;
    }

    /**
     * @param int $amount
     * @return BasketItemRequest
     */
    public function setAmount(int $amount): BasketItemRequest
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return BasketItemRequest
     */
    public function setName(?string $name): BasketItemRequest
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getArticle(): ?string
    {
        return $this->article;
    }

    /**
     * @param string|null $article
     * @return BasketItemRequest
     */
    public function setArticle(?string $article): BasketItemRequest
    {
        $this->article = $article;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDesc(): ?string
    {
        return $this->desc;
    }

    /**
     * @param string|null $desc
     * @return BasketItemRequest
     */
    public function setDesc(?string $desc): BasketItemRequest
    {
        $this->desc = $desc;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getRef(): ?string
    {
        return $this->ref;
    }

    /**
     * @param string|null $ref
     * @return BasketItemRequest
     */
    public function setRef(?string $ref): BasketItemRequest
    {
        $this->ref = $ref;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBrand(): ?string
    {
        return $this->brand;
    }

    /**
     * @param string|null $brand
     * @return BasketItemRequest
     */
    public function setBrand(?string $brand): BasketItemRequest
    {
        $this->brand = $brand;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getProviderId(): ?string
    {
        return $this->providerId;
    }

    /**
     * @param string|null $providerId
     * @return BasketItemRequest
     */
    public function setProviderId(?string $providerId): BasketItemRequest
    {
        $this->providerId = $providerId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMenagerComment(): ?string
    {
        return $this->menagerComment;
    }

    /**
     * @param string|null $menagerComment
     * @return BasketItemRequest
     */
    public function setMenagerComment(?string $menagerComment): BasketItemRequest
    {
        $this->menagerComment = $menagerComment;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDestination(): ?string
    {
        return $this->destination;
    }

    /**
     * @param string|null $destination
     * @return BasketItemRequest
     */
    public function setDestination(?string $destination): BasketItemRequest
    {
        $this->destination = $destination;
        return $this;
    }


}