<?php

namespace Shop\Infrastructure\Models\Product\Base;

use \DateTime;
use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Propel\Runtime\Util\PropelDateTime;
use Shop\Infrastructure\Models\Brand\Brand;
use Shop\Infrastructure\Models\Brand\BrandQuery;
use Shop\Infrastructure\Models\Category\Category;
use Shop\Infrastructure\Models\Category\CategoryQuery;
use Shop\Infrastructure\Models\DraftProduct\DraftProduct;
use Shop\Infrastructure\Models\DraftProduct\DraftProductQuery;
use Shop\Infrastructure\Models\DraftProduct\Base\DraftProduct as BaseDraftProduct;
use Shop\Infrastructure\Models\DraftProduct\Map\DraftProductTableMap;
use Shop\Infrastructure\Models\Position\Position;
use Shop\Infrastructure\Models\Position\PositionQuery;
use Shop\Infrastructure\Models\Position\Base\Position as BasePosition;
use Shop\Infrastructure\Models\Position\Map\PositionTableMap;
use Shop\Infrastructure\Models\Product\Product as ChildProduct;
use Shop\Infrastructure\Models\Product\ProductQuery as ChildProductQuery;
use Shop\Infrastructure\Models\ProductGroup\ProductGroup;
use Shop\Infrastructure\Models\ProductGroup\ProductGroupQuery;
use Shop\Infrastructure\Models\ProductHitSale\ProductHitSale;
use Shop\Infrastructure\Models\ProductHitSale\ProductHitSaleQuery;
use Shop\Infrastructure\Models\ProductSuperPrice\ProductSuperPrice;
use Shop\Infrastructure\Models\ProductSuperPrice\ProductSuperPriceQuery;
use Shop\Infrastructure\Models\Product\Map\ProductTableMap;
use Shop\Infrastructure\Models\ShopProductGroupsRel\ShopProductGroupsRel;
use Shop\Infrastructure\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery;
use Shop\Infrastructure\Models\ShopProductGroupsRel\Base\ShopProductGroupsRel as BaseShopProductGroupsRel;
use Shop\Infrastructure\Models\ShopProductGroupsRel\Map\ShopProductGroupsRelTableMap;

/**
 * Base class that represents a row from the 'shop_products' table.
 *
 *
 *
 * @package    propel.generator.Shop.Infrastructure.Models.Product.Base
 */
abstract class Product implements ActiveRecordInterface
{
    /**
     * TableMap class name
     *
     * @var string
     */
    public const TABLE_MAP = '\\Shop\\Infrastructure\\Models\\Product\\Map\\ProductTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var bool
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var bool
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = [];

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = [];

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the title field.
     *
     * @var        string
     */
    protected $title;

    /**
     * The value for the desc field.
     *
     * @var        string|null
     */
    protected $desc;

    /**
     * The value for the short_desc field.
     *
     * @var        string|null
     */
    protected $short_desc;

    /**
     * The value for the article field.
     *
     * @var        string|null
     */
    protected $article;

    /**
     * The value for the price field.
     *
     * @var        string|null
     */
    protected $price;

    /**
     * The value for the weight field.
     *
     * @var        string|null
     */
    protected $weight;

    /**
     * The value for the img field.
     *
     * @var        string|null
     */
    protected $img;

    /**
     * The value for the img1 field.
     *
     * @var        string|null
     */
    protected $img1;

    /**
     * The value for the img2 field.
     *
     * @var        string|null
     */
    protected $img2;

    /**
     * The value for the img3 field.
     *
     * @var        string|null
     */
    protected $img3;

    /**
     * The value for the img4 field.
     *
     * @var        string|null
     */
    protected $img4;

    /**
     * The value for the img5 field.
     *
     * @var        string|null
     */
    protected $img5;

    /**
     * The value for the img6 field.
     *
     * @var        string|null
     */
    protected $img6;

    /**
     * The value for the img7 field.
     *
     * @var        string|null
     */
    protected $img7;

    /**
     * The value for the img8 field.
     *
     * @var        string|null
     */
    protected $img8;

    /**
     * The value for the img9 field.
     *
     * @var        string|null
     */
    protected $img9;

    /**
     * The value for the special field.
     *
     * Note: this column has a database default value of: 'N'
     * @var        string
     */
    protected $special;

    /**
     * The value for the active field.
     *
     * Note: this column has a database default value of: 'Y'
     * @var        string
     */
    protected $active;

    /**
     * The value for the mt_title field.
     *
     * @var        string|null
     */
    protected $mt_title;

    /**
     * The value for the mt_description field.
     *
     * @var        string|null
     */
    protected $mt_description;

    /**
     * The value for the mt_keywords field.
     *
     * @var        string|null
     */
    protected $mt_keywords;

    /**
     * The value for the remains field.
     *
     * @var        string|null
     */
    protected $remains;

    /**
     * The value for the udate field.
     *
     * Note: this column has a database default value of: (expression) CURRENT_TIMESTAMP
     * @var        DateTime|null
     */
    protected $udate;

    /**
     * The value for the cdate field.
     *
     * Note: this column has a database default value of: (expression) CURRENT_TIMESTAMP
     * @var        DateTime
     */
    protected $cdate;

    /**
     * The value for the pdate field.
     *
     * @var        DateTime|null
     */
    protected $pdate;

    /**
     * The value for the ref field.
     *
     * @var        int|null
     */
    protected $ref;

    /**
     * The value for the min_quality field.
     *
     * @var        string|null
     */
    protected $min_quality;

    /**
     * The value for the seazon field.
     *
     * @var        string|null
     */
    protected $seazon;

    /**
     * The value for the category_id field.
     *
     * @var        int
     */
    protected $category_id;

    /**
     * The value for the brand_id field.
     *
     * @var        int
     */
    protected $brand_id;

    /**
     * @var        Category
     */
    protected $aCategory;

    /**
     * @var        Brand
     */
    protected $aBrand;

    /**
     * @var        ObjectCollection|ShopProductGroupsRel[] Collection to store aggregation of ShopProductGroupsRel objects.
     * @phpstan-var ObjectCollection&\Traversable<ShopProductGroupsRel> Collection to store aggregation of ShopProductGroupsRel objects.
     */
    protected $collShopProductGroupsRels;
    protected $collShopProductGroupsRelsPartial;

    /**
     * @var        ObjectCollection|Position[] Collection to store aggregation of Position objects.
     * @phpstan-var ObjectCollection&\Traversable<Position> Collection to store aggregation of Position objects.
     */
    protected $collPositions;
    protected $collPositionsPartial;

    /**
     * @var        ProductHitSale one-to-one related ProductHitSale object
     */
    protected $singleProductHitSale;

    /**
     * @var        ProductSuperPrice one-to-one related ProductSuperPrice object
     */
    protected $singleProductSuperPrice;

    /**
     * @var        ObjectCollection|DraftProduct[] Collection to store aggregation of DraftProduct objects.
     * @phpstan-var ObjectCollection&\Traversable<DraftProduct> Collection to store aggregation of DraftProduct objects.
     */
    protected $collDraftProducts;
    protected $collDraftProductsPartial;

    /**
     * @var        ObjectCollection|ProductGroup[] Cross Collection to store aggregation of ProductGroup objects.
     * @phpstan-var ObjectCollection&\Traversable<ProductGroup> Cross Collection to store aggregation of ProductGroup objects.
     */
    protected $collProductGroups;

    /**
     * @var bool
     */
    protected $collProductGroupsPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var bool
     */
    protected $alreadyInSave = false;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ProductGroup[]
     * @phpstan-var ObjectCollection&\Traversable<ProductGroup>
     */
    protected $productGroupsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ShopProductGroupsRel[]
     * @phpstan-var ObjectCollection&\Traversable<ShopProductGroupsRel>
     */
    protected $shopProductGroupsRelsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Position[]
     * @phpstan-var ObjectCollection&\Traversable<Position>
     */
    protected $positionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|DraftProduct[]
     * @phpstan-var ObjectCollection&\Traversable<DraftProduct>
     */
    protected $draftProductsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues(): void
    {
        $this->special = 'N';
        $this->active = 'Y';
    }

    /**
     * Initializes internal state of Shop\Infrastructure\Models\Product\Base\Product object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return bool True if the object has been modified.
     */
    public function isModified(): bool
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param string $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return bool True if $col has been modified.
     */
    public function isColumnModified(string $col): bool
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns(): array
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return bool True, if the object has never been persisted.
     */
    public function isNew(): bool
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param bool $b the state of the object.
     */
    public function setNew(bool $b): void
    {
        $this->new = $b;
    }

    /**
     * Whether this object has been deleted.
     * @return bool The deleted state of this object.
     */
    public function isDeleted(): bool
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param bool $b The deleted state of this object.
     * @return void
     */
    public function setDeleted(bool $b): void
    {
        $this->deleted = $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified(?string $col = null): void
    {
        if (null !== $col) {
            unset($this->modifiedColumns[$col]);
        } else {
            $this->modifiedColumns = [];
        }
    }

    /**
     * Compares this with another <code>Product</code> instance.  If
     * <code>obj</code> is an instance of <code>Product</code>, delegates to
     * <code>equals(Product)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param mixed $obj The object to compare to.
     * @return bool Whether equal to the object specified.
     */
    public function equals($obj): bool
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns(): array
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return bool
     */
    public function hasVirtualColumn(string $name): bool
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return mixed
     *
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getVirtualColumn(string $name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of nonexistent virtual column `%s`.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @param mixed $value The value to give to the virtual column
     *
     * @return $this The current object, for fluid interface
     */
    public function setVirtualColumn(string $name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param string $msg
     * @param int $priority One of the Propel::LOG_* logging levels
     * @return void
     */
    protected function log(string $msg, int $priority = Propel::LOG_INFO): void
    {
        Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param \Propel\Runtime\Parser\AbstractParser|string $parser An AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME, TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM. Defaults to TableMap::TYPE_PHPNAME.
     * @return string The exported data
     */
    public function exportTo($parser, bool $includeLazyLoadColumns = true, string $keyType = TableMap::TYPE_PHPNAME): string
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray($keyType, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     *
     * @return array<string>
     */
    public function __sleep(): array
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [title] column value.
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Get the [desc] column value.
     *
     * @return string|null
     */
    public function getDesc()
    {
        return $this->desc;
    }

    /**
     * Get the [short_desc] column value.
     *
     * @return string|null
     */
    public function getShortDesc()
    {
        return $this->short_desc;
    }

    /**
     * Get the [article] column value.
     *
     * @return string|null
     */
    public function getArticle()
    {
        return $this->article;
    }

    /**
     * Get the [price] column value.
     *
     * @return string|null
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Get the [weight] column value.
     *
     * @return string|null
     */
    public function getWeight()
    {
        return $this->weight;
    }

    /**
     * Get the [img] column value.
     *
     * @return string|null
     */
    public function getImg()
    {
        return $this->img;
    }

    /**
     * Get the [img1] column value.
     *
     * @return string|null
     */
    public function getImg1()
    {
        return $this->img1;
    }

    /**
     * Get the [img2] column value.
     *
     * @return string|null
     */
    public function getImg2()
    {
        return $this->img2;
    }

    /**
     * Get the [img3] column value.
     *
     * @return string|null
     */
    public function getImg3()
    {
        return $this->img3;
    }

    /**
     * Get the [img4] column value.
     *
     * @return string|null
     */
    public function getImg4()
    {
        return $this->img4;
    }

    /**
     * Get the [img5] column value.
     *
     * @return string|null
     */
    public function getImg5()
    {
        return $this->img5;
    }

    /**
     * Get the [img6] column value.
     *
     * @return string|null
     */
    public function getimg6()
    {
        return $this->img6;
    }

    /**
     * Get the [img7] column value.
     *
     * @return string|null
     */
    public function getImg7()
    {
        return $this->img7;
    }

    /**
     * Get the [img8] column value.
     *
     * @return string|null
     */
    public function getImg8()
    {
        return $this->img8;
    }

    /**
     * Get the [img9] column value.
     *
     * @return string|null
     */
    public function getImg9()
    {
        return $this->img9;
    }

    /**
     * Get the [special] column value.
     *
     * @return string
     */
    public function getSpecial()
    {
        return $this->special;
    }

    /**
     * Get the [active] column value.
     *
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Get the [mt_title] column value.
     *
     * @return string|null
     */
    public function getMtTitle()
    {
        return $this->mt_title;
    }

    /**
     * Get the [mt_description] column value.
     *
     * @return string|null
     */
    public function getMtDescription()
    {
        return $this->mt_description;
    }

    /**
     * Get the [mt_keywords] column value.
     *
     * @return string|null
     */
    public function getMtKeywords()
    {
        return $this->mt_keywords;
    }

    /**
     * Get the [remains] column value.
     *
     * @return string|null
     */
    public function getRemains()
    {
        return $this->remains;
    }

    /**
     * Get the [optionally formatted] temporal [udate] column value.
     *
     *
     * @param string|null $format The date/time format string (either date()-style or strftime()-style).
     *   If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime|null Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00.
     *
     * @throws \Propel\Runtime\Exception\PropelException - if unable to parse/validate the date/time value.
     *
     * @psalm-return ($format is null ? DateTime|null : string|null)
     */
    public function getdateUpdate($format = null)
    {
        if ($format === null) {
            return $this->udate;
        } else {
            return $this->udate instanceof \DateTimeInterface ? $this->udate->format($format) : null;
        }
    }

    /**
     * Get the [optionally formatted] temporal [cdate] column value.
     *
     *
     * @param string|null $format The date/time format string (either date()-style or strftime()-style).
     *   If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), and 0 if column value is 0000-00-00 00:00:00.
     *
     * @throws \Propel\Runtime\Exception\PropelException - if unable to parse/validate the date/time value.
     *
     * @psalm-return ($format is null ? DateTime : string)
     */
    public function getdateCreate($format = null)
    {
        if ($format === null) {
            return $this->cdate;
        } else {
            return $this->cdate instanceof \DateTimeInterface ? $this->cdate->format($format) : null;
        }
    }

    /**
     * Get the [optionally formatted] temporal [pdate] column value.
     *
     *
     * @param string|null $format The date/time format string (either date()-style or strftime()-style).
     *   If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime|null Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00.
     *
     * @throws \Propel\Runtime\Exception\PropelException - if unable to parse/validate the date/time value.
     *
     * @psalm-return ($format is null ? DateTime|null : string|null)
     */
    public function getdatePublic($format = null)
    {
        if ($format === null) {
            return $this->pdate;
        } else {
            return $this->pdate instanceof \DateTimeInterface ? $this->pdate->format($format) : null;
        }
    }

    /**
     * Get the [ref] column value.
     *
     * @return int|null
     */
    public function getRef()
    {
        return $this->ref;
    }

    /**
     * Get the [min_quality] column value.
     *
     * @return string|null
     */
    public function getMinQuality()
    {
        return $this->min_quality;
    }

    /**
     * Get the [seazon] column value.
     *
     * @return string|null
     */
    public function getSeazon()
    {
        return $this->seazon;
    }

    /**
     * Get the [category_id] column value.
     *
     * @return int
     */
    public function getCategoryId()
    {
        return $this->category_id;
    }

    /**
     * Get the [brand_id] column value.
     *
     * @return int
     */
    public function getBrandId()
    {
        return $this->brand_id;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[ProductTableMap::COL_ID] = true;
        }

        return $this;
    }

    /**
     * Set the value of [title] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->title !== $v) {
            $this->title = $v;
            $this->modifiedColumns[ProductTableMap::COL_TITLE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [desc] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setDesc($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->desc !== $v) {
            $this->desc = $v;
            $this->modifiedColumns[ProductTableMap::COL_DESC] = true;
        }

        return $this;
    }

    /**
     * Set the value of [short_desc] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setShortDesc($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->short_desc !== $v) {
            $this->short_desc = $v;
            $this->modifiedColumns[ProductTableMap::COL_SHORT_DESC] = true;
        }

        return $this;
    }

    /**
     * Set the value of [article] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setArticle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->article !== $v) {
            $this->article = $v;
            $this->modifiedColumns[ProductTableMap::COL_ARTICLE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [price] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setPrice($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->price !== $v) {
            $this->price = $v;
            $this->modifiedColumns[ProductTableMap::COL_PRICE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [weight] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setWeight($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->weight !== $v) {
            $this->weight = $v;
            $this->modifiedColumns[ProductTableMap::COL_WEIGHT] = true;
        }

        return $this;
    }

    /**
     * Set the value of [img] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setImg($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->img !== $v) {
            $this->img = $v;
            $this->modifiedColumns[ProductTableMap::COL_IMG] = true;
        }

        return $this;
    }

    /**
     * Set the value of [img1] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setImg1($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->img1 !== $v) {
            $this->img1 = $v;
            $this->modifiedColumns[ProductTableMap::COL_IMG1] = true;
        }

        return $this;
    }

    /**
     * Set the value of [img2] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setImg2($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->img2 !== $v) {
            $this->img2 = $v;
            $this->modifiedColumns[ProductTableMap::COL_IMG2] = true;
        }

        return $this;
    }

    /**
     * Set the value of [img3] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setImg3($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->img3 !== $v) {
            $this->img3 = $v;
            $this->modifiedColumns[ProductTableMap::COL_IMG3] = true;
        }

        return $this;
    }

    /**
     * Set the value of [img4] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setImg4($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->img4 !== $v) {
            $this->img4 = $v;
            $this->modifiedColumns[ProductTableMap::COL_IMG4] = true;
        }

        return $this;
    }

    /**
     * Set the value of [img5] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setImg5($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->img5 !== $v) {
            $this->img5 = $v;
            $this->modifiedColumns[ProductTableMap::COL_IMG5] = true;
        }

        return $this;
    }

    /**
     * Set the value of [img6] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setimg6($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->img6 !== $v) {
            $this->img6 = $v;
            $this->modifiedColumns[ProductTableMap::COL_IMG6] = true;
        }

        return $this;
    }

    /**
     * Set the value of [img7] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setImg7($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->img7 !== $v) {
            $this->img7 = $v;
            $this->modifiedColumns[ProductTableMap::COL_IMG7] = true;
        }

        return $this;
    }

    /**
     * Set the value of [img8] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setImg8($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->img8 !== $v) {
            $this->img8 = $v;
            $this->modifiedColumns[ProductTableMap::COL_IMG8] = true;
        }

        return $this;
    }

    /**
     * Set the value of [img9] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setImg9($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->img9 !== $v) {
            $this->img9 = $v;
            $this->modifiedColumns[ProductTableMap::COL_IMG9] = true;
        }

        return $this;
    }

    /**
     * Set the value of [special] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setSpecial($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->special !== $v) {
            $this->special = $v;
            $this->modifiedColumns[ProductTableMap::COL_SPECIAL] = true;
        }

        return $this;
    }

    /**
     * Set the value of [active] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setActive($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->active !== $v) {
            $this->active = $v;
            $this->modifiedColumns[ProductTableMap::COL_ACTIVE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [mt_title] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setMtTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mt_title !== $v) {
            $this->mt_title = $v;
            $this->modifiedColumns[ProductTableMap::COL_MT_TITLE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [mt_description] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setMtDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mt_description !== $v) {
            $this->mt_description = $v;
            $this->modifiedColumns[ProductTableMap::COL_MT_DESCRIPTION] = true;
        }

        return $this;
    }

    /**
     * Set the value of [mt_keywords] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setMtKeywords($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mt_keywords !== $v) {
            $this->mt_keywords = $v;
            $this->modifiedColumns[ProductTableMap::COL_MT_KEYWORDS] = true;
        }

        return $this;
    }

    /**
     * Set the value of [remains] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setRemains($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->remains !== $v) {
            $this->remains = $v;
            $this->modifiedColumns[ProductTableMap::COL_REMAINS] = true;
        }

        return $this;
    }

    /**
     * Sets the value of [udate] column to a normalized version of the date/time value specified.
     *
     * @param string|integer|\DateTimeInterface|null $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this The current object (for fluent API support)
     */
    public function setdateUpdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->udate !== null || $dt !== null) {
            if ($this->udate === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->udate->format("Y-m-d H:i:s.u")) {
                $this->udate = $dt === null ? null : clone $dt;
                $this->modifiedColumns[ProductTableMap::COL_UDATE] = true;
            }
        } // if either are not null

        return $this;
    }

    /**
     * Sets the value of [cdate] column to a normalized version of the date/time value specified.
     *
     * @param string|integer|\DateTimeInterface $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this The current object (for fluent API support)
     */
    public function setdateCreate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->cdate !== null || $dt !== null) {
            if ($this->cdate === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->cdate->format("Y-m-d H:i:s.u")) {
                $this->cdate = $dt === null ? null : clone $dt;
                $this->modifiedColumns[ProductTableMap::COL_CDATE] = true;
            }
        } // if either are not null

        return $this;
    }

    /**
     * Sets the value of [pdate] column to a normalized version of the date/time value specified.
     *
     * @param string|integer|\DateTimeInterface|null $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this The current object (for fluent API support)
     */
    public function setdatePublic($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->pdate !== null || $dt !== null) {
            if ($this->pdate === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->pdate->format("Y-m-d H:i:s.u")) {
                $this->pdate = $dt === null ? null : clone $dt;
                $this->modifiedColumns[ProductTableMap::COL_PDATE] = true;
            }
        } // if either are not null

        return $this;
    }

    /**
     * Set the value of [ref] column.
     *
     * @param int|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setRef($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->ref !== $v) {
            $this->ref = $v;
            $this->modifiedColumns[ProductTableMap::COL_REF] = true;
        }

        return $this;
    }

    /**
     * Set the value of [min_quality] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setMinQuality($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->min_quality !== $v) {
            $this->min_quality = $v;
            $this->modifiedColumns[ProductTableMap::COL_MIN_QUALITY] = true;
        }

        return $this;
    }

    /**
     * Set the value of [seazon] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setSeazon($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->seazon !== $v) {
            $this->seazon = $v;
            $this->modifiedColumns[ProductTableMap::COL_SEAZON] = true;
        }

        return $this;
    }

    /**
     * Set the value of [category_id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setCategoryId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->category_id !== $v) {
            $this->category_id = $v;
            $this->modifiedColumns[ProductTableMap::COL_CATEGORY_ID] = true;
        }

        if ($this->aCategory !== null && $this->aCategory->getId() !== $v) {
            $this->aCategory = null;
        }

        return $this;
    }

    /**
     * Set the value of [brand_id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setBrandId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->brand_id !== $v) {
            $this->brand_id = $v;
            $this->modifiedColumns[ProductTableMap::COL_BRAND_ID] = true;
        }

        if ($this->aBrand !== null && $this->aBrand->getId() !== $v) {
            $this->aBrand = null;
        }

        return $this;
    }

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return bool Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues(): bool
    {
            if ($this->special !== 'N') {
                return false;
            }

            if ($this->active !== 'Y') {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    }

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by DataFetcher->fetch().
     * @param int $startcol 0-based offset column which indicates which resultset column to start with.
     * @param bool $rehydrate Whether this object is being re-hydrated from the database.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int next starting column
     * @throws \Propel\Runtime\Exception\PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate(array $row, int $startcol = 0, bool $rehydrate = false, string $indexType = TableMap::TYPE_NUM): int
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : ProductTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : ProductTableMap::translateFieldName('Title', TableMap::TYPE_PHPNAME, $indexType)];
            $this->title = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : ProductTableMap::translateFieldName('Desc', TableMap::TYPE_PHPNAME, $indexType)];
            $this->desc = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : ProductTableMap::translateFieldName('ShortDesc', TableMap::TYPE_PHPNAME, $indexType)];
            $this->short_desc = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : ProductTableMap::translateFieldName('Article', TableMap::TYPE_PHPNAME, $indexType)];
            $this->article = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : ProductTableMap::translateFieldName('Price', TableMap::TYPE_PHPNAME, $indexType)];
            $this->price = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : ProductTableMap::translateFieldName('Weight', TableMap::TYPE_PHPNAME, $indexType)];
            $this->weight = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : ProductTableMap::translateFieldName('Img', TableMap::TYPE_PHPNAME, $indexType)];
            $this->img = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : ProductTableMap::translateFieldName('Img1', TableMap::TYPE_PHPNAME, $indexType)];
            $this->img1 = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 9 + $startcol : ProductTableMap::translateFieldName('Img2', TableMap::TYPE_PHPNAME, $indexType)];
            $this->img2 = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 10 + $startcol : ProductTableMap::translateFieldName('Img3', TableMap::TYPE_PHPNAME, $indexType)];
            $this->img3 = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 11 + $startcol : ProductTableMap::translateFieldName('Img4', TableMap::TYPE_PHPNAME, $indexType)];
            $this->img4 = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 12 + $startcol : ProductTableMap::translateFieldName('Img5', TableMap::TYPE_PHPNAME, $indexType)];
            $this->img5 = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 13 + $startcol : ProductTableMap::translateFieldName('img6', TableMap::TYPE_PHPNAME, $indexType)];
            $this->img6 = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 14 + $startcol : ProductTableMap::translateFieldName('Img7', TableMap::TYPE_PHPNAME, $indexType)];
            $this->img7 = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 15 + $startcol : ProductTableMap::translateFieldName('Img8', TableMap::TYPE_PHPNAME, $indexType)];
            $this->img8 = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 16 + $startcol : ProductTableMap::translateFieldName('Img9', TableMap::TYPE_PHPNAME, $indexType)];
            $this->img9 = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 17 + $startcol : ProductTableMap::translateFieldName('Special', TableMap::TYPE_PHPNAME, $indexType)];
            $this->special = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 18 + $startcol : ProductTableMap::translateFieldName('Active', TableMap::TYPE_PHPNAME, $indexType)];
            $this->active = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 19 + $startcol : ProductTableMap::translateFieldName('MtTitle', TableMap::TYPE_PHPNAME, $indexType)];
            $this->mt_title = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 20 + $startcol : ProductTableMap::translateFieldName('MtDescription', TableMap::TYPE_PHPNAME, $indexType)];
            $this->mt_description = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 21 + $startcol : ProductTableMap::translateFieldName('MtKeywords', TableMap::TYPE_PHPNAME, $indexType)];
            $this->mt_keywords = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 22 + $startcol : ProductTableMap::translateFieldName('Remains', TableMap::TYPE_PHPNAME, $indexType)];
            $this->remains = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 23 + $startcol : ProductTableMap::translateFieldName('dateUpdate', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->udate = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 24 + $startcol : ProductTableMap::translateFieldName('dateCreate', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->cdate = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 25 + $startcol : ProductTableMap::translateFieldName('datePublic', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->pdate = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 26 + $startcol : ProductTableMap::translateFieldName('Ref', TableMap::TYPE_PHPNAME, $indexType)];
            $this->ref = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 27 + $startcol : ProductTableMap::translateFieldName('MinQuality', TableMap::TYPE_PHPNAME, $indexType)];
            $this->min_quality = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 28 + $startcol : ProductTableMap::translateFieldName('Seazon', TableMap::TYPE_PHPNAME, $indexType)];
            $this->seazon = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 29 + $startcol : ProductTableMap::translateFieldName('CategoryId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->category_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 30 + $startcol : ProductTableMap::translateFieldName('BrandId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->brand_id = (null !== $col) ? (int) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 31; // 31 = ProductTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Shop\\Infrastructure\\Models\\Product\\Product'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function ensureConsistency(): void
    {
        if ($this->aCategory !== null && $this->category_id !== $this->aCategory->getId()) {
            $this->aCategory = null;
        }
        if ($this->aBrand !== null && $this->brand_id !== $this->aBrand->getId()) {
            $this->aBrand = null;
        }
    }

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param bool $deep (optional) Whether to also de-associated any related objects.
     * @param ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload(bool $deep = false, ?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ProductTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildProductQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aCategory = null;
            $this->aBrand = null;
            $this->collShopProductGroupsRels = null;

            $this->collPositions = null;

            $this->singleProductHitSale = null;

            $this->singleProductSuperPrice = null;

            $this->collDraftProducts = null;

            $this->collProductGroups = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param ConnectionInterface $con
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     * @see Product::setDeleted()
     * @see Product::isDeleted()
     */
    public function delete(?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildProductQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    public function save(?ConnectionInterface $con = null): int
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ProductTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con): int
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their corresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aCategory !== null) {
                if ($this->aCategory->isModified() || $this->aCategory->isNew()) {
                    $affectedRows += $this->aCategory->save($con);
                }
                $this->setCategory($this->aCategory);
            }

            if ($this->aBrand !== null) {
                if ($this->aBrand->isModified() || $this->aBrand->isNew()) {
                    $affectedRows += $this->aBrand->save($con);
                }
                $this->setBrand($this->aBrand);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->productGroupsScheduledForDeletion !== null) {
                if (!$this->productGroupsScheduledForDeletion->isEmpty()) {
                    $pks = [];
                    foreach ($this->productGroupsScheduledForDeletion as $entry) {
                        $entryPk = [];

                        $entryPk[0] = $this->getId();
                        $entryPk[1] = $entry->getId();
                        $pks[] = $entryPk;
                    }

                    \Shop\Infrastructure\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);

                    $this->productGroupsScheduledForDeletion = null;
                }

            }

            if ($this->collProductGroups) {
                foreach ($this->collProductGroups as $productGroup) {
                    if (!$productGroup->isDeleted() && ($productGroup->isNew() || $productGroup->isModified())) {
                        $productGroup->save($con);
                    }
                }
            }


            if ($this->shopProductGroupsRelsScheduledForDeletion !== null) {
                if (!$this->shopProductGroupsRelsScheduledForDeletion->isEmpty()) {
                    \Shop\Infrastructure\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery::create()
                        ->filterByPrimaryKeys($this->shopProductGroupsRelsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->shopProductGroupsRelsScheduledForDeletion = null;
                }
            }

            if ($this->collShopProductGroupsRels !== null) {
                foreach ($this->collShopProductGroupsRels as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->positionsScheduledForDeletion !== null) {
                if (!$this->positionsScheduledForDeletion->isEmpty()) {
                    \Shop\Infrastructure\Models\Position\PositionQuery::create()
                        ->filterByPrimaryKeys($this->positionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->positionsScheduledForDeletion = null;
                }
            }

            if ($this->collPositions !== null) {
                foreach ($this->collPositions as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->singleProductHitSale !== null) {
                if (!$this->singleProductHitSale->isDeleted() && ($this->singleProductHitSale->isNew() || $this->singleProductHitSale->isModified())) {
                    $affectedRows += $this->singleProductHitSale->save($con);
                }
            }

            if ($this->singleProductSuperPrice !== null) {
                if (!$this->singleProductSuperPrice->isDeleted() && ($this->singleProductSuperPrice->isNew() || $this->singleProductSuperPrice->isModified())) {
                    $affectedRows += $this->singleProductSuperPrice->save($con);
                }
            }

            if ($this->draftProductsScheduledForDeletion !== null) {
                if (!$this->draftProductsScheduledForDeletion->isEmpty()) {
                    foreach ($this->draftProductsScheduledForDeletion as $draftProduct) {
                        // need to save related object because we set the relation to null
                        $draftProduct->save($con);
                    }
                    $this->draftProductsScheduledForDeletion = null;
                }
            }

            if ($this->collDraftProducts !== null) {
                foreach ($this->collDraftProducts as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    }

    /**
     * Insert the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con): void
    {
        $modifiedColumns = [];
        $index = 0;

        $this->modifiedColumns[ProductTableMap::COL_ID] = true;

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ProductTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`title`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_DESC)) {
            $modifiedColumns[':p' . $index++]  = '`desc`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_SHORT_DESC)) {
            $modifiedColumns[':p' . $index++]  = '`short_desc`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_ARTICLE)) {
            $modifiedColumns[':p' . $index++]  = '`article`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_PRICE)) {
            $modifiedColumns[':p' . $index++]  = '`price`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_WEIGHT)) {
            $modifiedColumns[':p' . $index++]  = '`weight`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG)) {
            $modifiedColumns[':p' . $index++]  = '`img`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG1)) {
            $modifiedColumns[':p' . $index++]  = '`img1`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG2)) {
            $modifiedColumns[':p' . $index++]  = '`img2`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG3)) {
            $modifiedColumns[':p' . $index++]  = '`img3`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG4)) {
            $modifiedColumns[':p' . $index++]  = '`img4`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG5)) {
            $modifiedColumns[':p' . $index++]  = '`img5`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG6)) {
            $modifiedColumns[':p' . $index++]  = '`img6`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG7)) {
            $modifiedColumns[':p' . $index++]  = '`img7`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG8)) {
            $modifiedColumns[':p' . $index++]  = '`img8`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG9)) {
            $modifiedColumns[':p' . $index++]  = '`img9`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_SPECIAL)) {
            $modifiedColumns[':p' . $index++]  = '`special`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_ACTIVE)) {
            $modifiedColumns[':p' . $index++]  = '`active`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_MT_TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`mt_title`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_MT_DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`mt_description`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_MT_KEYWORDS)) {
            $modifiedColumns[':p' . $index++]  = '`mt_keywords`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_REMAINS)) {
            $modifiedColumns[':p' . $index++]  = '`remains`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_UDATE)) {
            $modifiedColumns[':p' . $index++]  = '`udate`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_CDATE)) {
            $modifiedColumns[':p' . $index++]  = '`cdate`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_PDATE)) {
            $modifiedColumns[':p' . $index++]  = '`pdate`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_REF)) {
            $modifiedColumns[':p' . $index++]  = '`ref`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_MIN_QUALITY)) {
            $modifiedColumns[':p' . $index++]  = '`min_quality`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_SEAZON)) {
            $modifiedColumns[':p' . $index++]  = '`seazon`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_CATEGORY_ID)) {
            $modifiedColumns[':p' . $index++]  = '`category_id`';
        }
        if ($this->isColumnModified(ProductTableMap::COL_BRAND_ID)) {
            $modifiedColumns[':p' . $index++]  = '`brand_id`';
        }

        $sql = sprintf(
            'INSERT INTO `shop_products` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`title`':
                        $stmt->bindValue($identifier, $this->title, PDO::PARAM_STR);
                        break;
                    case '`desc`':
                        $stmt->bindValue($identifier, $this->desc, PDO::PARAM_STR);
                        break;
                    case '`short_desc`':
                        $stmt->bindValue($identifier, $this->short_desc, PDO::PARAM_STR);
                        break;
                    case '`article`':
                        $stmt->bindValue($identifier, $this->article, PDO::PARAM_STR);
                        break;
                    case '`price`':
                        $stmt->bindValue($identifier, $this->price, PDO::PARAM_STR);
                        break;
                    case '`weight`':
                        $stmt->bindValue($identifier, $this->weight, PDO::PARAM_STR);
                        break;
                    case '`img`':
                        $stmt->bindValue($identifier, $this->img, PDO::PARAM_STR);
                        break;
                    case '`img1`':
                        $stmt->bindValue($identifier, $this->img1, PDO::PARAM_STR);
                        break;
                    case '`img2`':
                        $stmt->bindValue($identifier, $this->img2, PDO::PARAM_STR);
                        break;
                    case '`img3`':
                        $stmt->bindValue($identifier, $this->img3, PDO::PARAM_STR);
                        break;
                    case '`img4`':
                        $stmt->bindValue($identifier, $this->img4, PDO::PARAM_STR);
                        break;
                    case '`img5`':
                        $stmt->bindValue($identifier, $this->img5, PDO::PARAM_STR);
                        break;
                    case '`img6`':
                        $stmt->bindValue($identifier, $this->img6, PDO::PARAM_STR);
                        break;
                    case '`img7`':
                        $stmt->bindValue($identifier, $this->img7, PDO::PARAM_STR);
                        break;
                    case '`img8`':
                        $stmt->bindValue($identifier, $this->img8, PDO::PARAM_STR);
                        break;
                    case '`img9`':
                        $stmt->bindValue($identifier, $this->img9, PDO::PARAM_STR);
                        break;
                    case '`special`':
                        $stmt->bindValue($identifier, $this->special, PDO::PARAM_STR);
                        break;
                    case '`active`':
                        $stmt->bindValue($identifier, $this->active, PDO::PARAM_STR);
                        break;
                    case '`mt_title`':
                        $stmt->bindValue($identifier, $this->mt_title, PDO::PARAM_STR);
                        break;
                    case '`mt_description`':
                        $stmt->bindValue($identifier, $this->mt_description, PDO::PARAM_STR);
                        break;
                    case '`mt_keywords`':
                        $stmt->bindValue($identifier, $this->mt_keywords, PDO::PARAM_STR);
                        break;
                    case '`remains`':
                        $stmt->bindValue($identifier, $this->remains, PDO::PARAM_STR);
                        break;
                    case '`udate`':
                        $stmt->bindValue($identifier, $this->udate ? $this->udate->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`cdate`':
                        $stmt->bindValue($identifier, $this->cdate ? $this->cdate->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`pdate`':
                        $stmt->bindValue($identifier, $this->pdate ? $this->pdate->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`ref`':
                        $stmt->bindValue($identifier, $this->ref, PDO::PARAM_INT);
                        break;
                    case '`min_quality`':
                        $stmt->bindValue($identifier, $this->min_quality, PDO::PARAM_STR);
                        break;
                    case '`seazon`':
                        $stmt->bindValue($identifier, $this->seazon, PDO::PARAM_STR);
                        break;
                    case '`category_id`':
                        $stmt->bindValue($identifier, $this->category_id, PDO::PARAM_INT);
                        break;
                    case '`brand_id`':
                        $stmt->bindValue($identifier, $this->brand_id, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        if ($pk !== null) {
            $this->setId($pk);
        }

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @return int Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con): int
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName(string $name, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = ProductTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos Position in XML schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition(int $pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();

            case 1:
                return $this->getTitle();

            case 2:
                return $this->getDesc();

            case 3:
                return $this->getShortDesc();

            case 4:
                return $this->getArticle();

            case 5:
                return $this->getPrice();

            case 6:
                return $this->getWeight();

            case 7:
                return $this->getImg();

            case 8:
                return $this->getImg1();

            case 9:
                return $this->getImg2();

            case 10:
                return $this->getImg3();

            case 11:
                return $this->getImg4();

            case 12:
                return $this->getImg5();

            case 13:
                return $this->getimg6();

            case 14:
                return $this->getImg7();

            case 15:
                return $this->getImg8();

            case 16:
                return $this->getImg9();

            case 17:
                return $this->getSpecial();

            case 18:
                return $this->getActive();

            case 19:
                return $this->getMtTitle();

            case 20:
                return $this->getMtDescription();

            case 21:
                return $this->getMtKeywords();

            case 22:
                return $this->getRemains();

            case 23:
                return $this->getdateUpdate();

            case 24:
                return $this->getdateCreate();

            case 25:
                return $this->getdatePublic();

            case 26:
                return $this->getRef();

            case 27:
                return $this->getMinQuality();

            case 28:
                return $this->getSeazon();

            case 29:
                return $this->getCategoryId();

            case 30:
                return $this->getBrandId();

            default:
                return null;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param bool $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array An associative array containing the field names (as keys) and field values
     */
    public function toArray(string $keyType = TableMap::TYPE_PHPNAME, bool $includeLazyLoadColumns = true, array $alreadyDumpedObjects = [], bool $includeForeignObjects = false): array
    {
        if (isset($alreadyDumpedObjects['Product'][$this->hashCode()])) {
            return ['*RECURSION*'];
        }
        $alreadyDumpedObjects['Product'][$this->hashCode()] = true;
        $keys = ProductTableMap::getFieldNames($keyType);
        $result = [
            $keys[0] => $this->getId(),
            $keys[1] => $this->getTitle(),
            $keys[2] => $this->getDesc(),
            $keys[3] => $this->getShortDesc(),
            $keys[4] => $this->getArticle(),
            $keys[5] => $this->getPrice(),
            $keys[6] => $this->getWeight(),
            $keys[7] => $this->getImg(),
            $keys[8] => $this->getImg1(),
            $keys[9] => $this->getImg2(),
            $keys[10] => $this->getImg3(),
            $keys[11] => $this->getImg4(),
            $keys[12] => $this->getImg5(),
            $keys[13] => $this->getimg6(),
            $keys[14] => $this->getImg7(),
            $keys[15] => $this->getImg8(),
            $keys[16] => $this->getImg9(),
            $keys[17] => $this->getSpecial(),
            $keys[18] => $this->getActive(),
            $keys[19] => $this->getMtTitle(),
            $keys[20] => $this->getMtDescription(),
            $keys[21] => $this->getMtKeywords(),
            $keys[22] => $this->getRemains(),
            $keys[23] => $this->getdateUpdate(),
            $keys[24] => $this->getdateCreate(),
            $keys[25] => $this->getdatePublic(),
            $keys[26] => $this->getRef(),
            $keys[27] => $this->getMinQuality(),
            $keys[28] => $this->getSeazon(),
            $keys[29] => $this->getCategoryId(),
            $keys[30] => $this->getBrandId(),
        ];
        if ($result[$keys[23]] instanceof \DateTimeInterface) {
            $result[$keys[23]] = $result[$keys[23]]->format('Y-m-d H:i:s.u');
        }

        if ($result[$keys[24]] instanceof \DateTimeInterface) {
            $result[$keys[24]] = $result[$keys[24]]->format('Y-m-d H:i:s.u');
        }

        if ($result[$keys[25]] instanceof \DateTimeInterface) {
            $result[$keys[25]] = $result[$keys[25]]->format('Y-m-d H:i:s.u');
        }

        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->aCategory) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'category';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_categories';
                        break;
                    default:
                        $key = 'Category';
                }

                $result[$key] = $this->aCategory->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aBrand) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'brand';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_brands';
                        break;
                    default:
                        $key = 'Brand';
                }

                $result[$key] = $this->aBrand->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collShopProductGroupsRels) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'shopProductGroupsRels';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_product_groups_rels';
                        break;
                    default:
                        $key = 'ShopProductGroupsRels';
                }

                $result[$key] = $this->collShopProductGroupsRels->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collPositions) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'positions';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_positionss';
                        break;
                    default:
                        $key = 'Positions';
                }

                $result[$key] = $this->collPositions->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->singleProductHitSale) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'productHitSale';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_product_hit_sale';
                        break;
                    default:
                        $key = 'ProductHitSale';
                }

                $result[$key] = $this->singleProductHitSale->toArray($keyType, $includeLazyLoadColumns, $alreadyDumpedObjects, true);
            }
            if (null !== $this->singleProductSuperPrice) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'productSuperPrice';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_product_super_price';
                        break;
                    default:
                        $key = 'ProductSuperPrice';
                }

                $result[$key] = $this->singleProductSuperPrice->toArray($keyType, $includeLazyLoadColumns, $alreadyDumpedObjects, true);
            }
            if (null !== $this->collDraftProducts) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'draftProducts';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_product_draftss';
                        break;
                    default:
                        $key = 'DraftProducts';
                }

                $result[$key] = $this->collDraftProducts->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this
     */
    public function setByName(string $name, $value, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = ProductTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        $this->setByPosition($pos, $value);

        return $this;
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return $this
     */
    public function setByPosition(int $pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setTitle($value);
                break;
            case 2:
                $this->setDesc($value);
                break;
            case 3:
                $this->setShortDesc($value);
                break;
            case 4:
                $this->setArticle($value);
                break;
            case 5:
                $this->setPrice($value);
                break;
            case 6:
                $this->setWeight($value);
                break;
            case 7:
                $this->setImg($value);
                break;
            case 8:
                $this->setImg1($value);
                break;
            case 9:
                $this->setImg2($value);
                break;
            case 10:
                $this->setImg3($value);
                break;
            case 11:
                $this->setImg4($value);
                break;
            case 12:
                $this->setImg5($value);
                break;
            case 13:
                $this->setimg6($value);
                break;
            case 14:
                $this->setImg7($value);
                break;
            case 15:
                $this->setImg8($value);
                break;
            case 16:
                $this->setImg9($value);
                break;
            case 17:
                $this->setSpecial($value);
                break;
            case 18:
                $this->setActive($value);
                break;
            case 19:
                $this->setMtTitle($value);
                break;
            case 20:
                $this->setMtDescription($value);
                break;
            case 21:
                $this->setMtKeywords($value);
                break;
            case 22:
                $this->setRemains($value);
                break;
            case 23:
                $this->setdateUpdate($value);
                break;
            case 24:
                $this->setdateCreate($value);
                break;
            case 25:
                $this->setdatePublic($value);
                break;
            case 26:
                $this->setRef($value);
                break;
            case 27:
                $this->setMinQuality($value);
                break;
            case 28:
                $this->setSeazon($value);
                break;
            case 29:
                $this->setCategoryId($value);
                break;
            case 30:
                $this->setBrandId($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param array $arr An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return $this
     */
    public function fromArray(array $arr, string $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = ProductTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setTitle($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setDesc($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setShortDesc($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setArticle($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setPrice($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setWeight($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setImg($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setImg1($arr[$keys[8]]);
        }
        if (array_key_exists($keys[9], $arr)) {
            $this->setImg2($arr[$keys[9]]);
        }
        if (array_key_exists($keys[10], $arr)) {
            $this->setImg3($arr[$keys[10]]);
        }
        if (array_key_exists($keys[11], $arr)) {
            $this->setImg4($arr[$keys[11]]);
        }
        if (array_key_exists($keys[12], $arr)) {
            $this->setImg5($arr[$keys[12]]);
        }
        if (array_key_exists($keys[13], $arr)) {
            $this->setimg6($arr[$keys[13]]);
        }
        if (array_key_exists($keys[14], $arr)) {
            $this->setImg7($arr[$keys[14]]);
        }
        if (array_key_exists($keys[15], $arr)) {
            $this->setImg8($arr[$keys[15]]);
        }
        if (array_key_exists($keys[16], $arr)) {
            $this->setImg9($arr[$keys[16]]);
        }
        if (array_key_exists($keys[17], $arr)) {
            $this->setSpecial($arr[$keys[17]]);
        }
        if (array_key_exists($keys[18], $arr)) {
            $this->setActive($arr[$keys[18]]);
        }
        if (array_key_exists($keys[19], $arr)) {
            $this->setMtTitle($arr[$keys[19]]);
        }
        if (array_key_exists($keys[20], $arr)) {
            $this->setMtDescription($arr[$keys[20]]);
        }
        if (array_key_exists($keys[21], $arr)) {
            $this->setMtKeywords($arr[$keys[21]]);
        }
        if (array_key_exists($keys[22], $arr)) {
            $this->setRemains($arr[$keys[22]]);
        }
        if (array_key_exists($keys[23], $arr)) {
            $this->setdateUpdate($arr[$keys[23]]);
        }
        if (array_key_exists($keys[24], $arr)) {
            $this->setdateCreate($arr[$keys[24]]);
        }
        if (array_key_exists($keys[25], $arr)) {
            $this->setdatePublic($arr[$keys[25]]);
        }
        if (array_key_exists($keys[26], $arr)) {
            $this->setRef($arr[$keys[26]]);
        }
        if (array_key_exists($keys[27], $arr)) {
            $this->setMinQuality($arr[$keys[27]]);
        }
        if (array_key_exists($keys[28], $arr)) {
            $this->setSeazon($arr[$keys[28]]);
        }
        if (array_key_exists($keys[29], $arr)) {
            $this->setCategoryId($arr[$keys[29]]);
        }
        if (array_key_exists($keys[30], $arr)) {
            $this->setBrandId($arr[$keys[30]]);
        }

        return $this;
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this The current object, for fluid interface
     */
    public function importFrom($parser, string $data, string $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria(): Criteria
    {
        $criteria = new Criteria(ProductTableMap::DATABASE_NAME);

        if ($this->isColumnModified(ProductTableMap::COL_ID)) {
            $criteria->add(ProductTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(ProductTableMap::COL_TITLE)) {
            $criteria->add(ProductTableMap::COL_TITLE, $this->title);
        }
        if ($this->isColumnModified(ProductTableMap::COL_DESC)) {
            $criteria->add(ProductTableMap::COL_DESC, $this->desc);
        }
        if ($this->isColumnModified(ProductTableMap::COL_SHORT_DESC)) {
            $criteria->add(ProductTableMap::COL_SHORT_DESC, $this->short_desc);
        }
        if ($this->isColumnModified(ProductTableMap::COL_ARTICLE)) {
            $criteria->add(ProductTableMap::COL_ARTICLE, $this->article);
        }
        if ($this->isColumnModified(ProductTableMap::COL_PRICE)) {
            $criteria->add(ProductTableMap::COL_PRICE, $this->price);
        }
        if ($this->isColumnModified(ProductTableMap::COL_WEIGHT)) {
            $criteria->add(ProductTableMap::COL_WEIGHT, $this->weight);
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG)) {
            $criteria->add(ProductTableMap::COL_IMG, $this->img);
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG1)) {
            $criteria->add(ProductTableMap::COL_IMG1, $this->img1);
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG2)) {
            $criteria->add(ProductTableMap::COL_IMG2, $this->img2);
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG3)) {
            $criteria->add(ProductTableMap::COL_IMG3, $this->img3);
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG4)) {
            $criteria->add(ProductTableMap::COL_IMG4, $this->img4);
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG5)) {
            $criteria->add(ProductTableMap::COL_IMG5, $this->img5);
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG6)) {
            $criteria->add(ProductTableMap::COL_IMG6, $this->img6);
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG7)) {
            $criteria->add(ProductTableMap::COL_IMG7, $this->img7);
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG8)) {
            $criteria->add(ProductTableMap::COL_IMG8, $this->img8);
        }
        if ($this->isColumnModified(ProductTableMap::COL_IMG9)) {
            $criteria->add(ProductTableMap::COL_IMG9, $this->img9);
        }
        if ($this->isColumnModified(ProductTableMap::COL_SPECIAL)) {
            $criteria->add(ProductTableMap::COL_SPECIAL, $this->special);
        }
        if ($this->isColumnModified(ProductTableMap::COL_ACTIVE)) {
            $criteria->add(ProductTableMap::COL_ACTIVE, $this->active);
        }
        if ($this->isColumnModified(ProductTableMap::COL_MT_TITLE)) {
            $criteria->add(ProductTableMap::COL_MT_TITLE, $this->mt_title);
        }
        if ($this->isColumnModified(ProductTableMap::COL_MT_DESCRIPTION)) {
            $criteria->add(ProductTableMap::COL_MT_DESCRIPTION, $this->mt_description);
        }
        if ($this->isColumnModified(ProductTableMap::COL_MT_KEYWORDS)) {
            $criteria->add(ProductTableMap::COL_MT_KEYWORDS, $this->mt_keywords);
        }
        if ($this->isColumnModified(ProductTableMap::COL_REMAINS)) {
            $criteria->add(ProductTableMap::COL_REMAINS, $this->remains);
        }
        if ($this->isColumnModified(ProductTableMap::COL_UDATE)) {
            $criteria->add(ProductTableMap::COL_UDATE, $this->udate);
        }
        if ($this->isColumnModified(ProductTableMap::COL_CDATE)) {
            $criteria->add(ProductTableMap::COL_CDATE, $this->cdate);
        }
        if ($this->isColumnModified(ProductTableMap::COL_PDATE)) {
            $criteria->add(ProductTableMap::COL_PDATE, $this->pdate);
        }
        if ($this->isColumnModified(ProductTableMap::COL_REF)) {
            $criteria->add(ProductTableMap::COL_REF, $this->ref);
        }
        if ($this->isColumnModified(ProductTableMap::COL_MIN_QUALITY)) {
            $criteria->add(ProductTableMap::COL_MIN_QUALITY, $this->min_quality);
        }
        if ($this->isColumnModified(ProductTableMap::COL_SEAZON)) {
            $criteria->add(ProductTableMap::COL_SEAZON, $this->seazon);
        }
        if ($this->isColumnModified(ProductTableMap::COL_CATEGORY_ID)) {
            $criteria->add(ProductTableMap::COL_CATEGORY_ID, $this->category_id);
        }
        if ($this->isColumnModified(ProductTableMap::COL_BRAND_ID)) {
            $criteria->add(ProductTableMap::COL_BRAND_ID, $this->brand_id);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria(): Criteria
    {
        $criteria = ChildProductQuery::create();
        $criteria->add(ProductTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int|string Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param int|null $key Primary key.
     * @return void
     */
    public function setPrimaryKey(?int $key = null): void
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     *
     * @return bool
     */
    public function isPrimaryKeyNull(): bool
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of \Shop\Infrastructure\Models\Product\Product (or compatible) type.
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param bool $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function copyInto(object $copyObj, bool $deepCopy = false, bool $makeNew = true): void
    {
        $copyObj->setTitle($this->getTitle());
        $copyObj->setDesc($this->getDesc());
        $copyObj->setShortDesc($this->getShortDesc());
        $copyObj->setArticle($this->getArticle());
        $copyObj->setPrice($this->getPrice());
        $copyObj->setWeight($this->getWeight());
        $copyObj->setImg($this->getImg());
        $copyObj->setImg1($this->getImg1());
        $copyObj->setImg2($this->getImg2());
        $copyObj->setImg3($this->getImg3());
        $copyObj->setImg4($this->getImg4());
        $copyObj->setImg5($this->getImg5());
        $copyObj->setimg6($this->getimg6());
        $copyObj->setImg7($this->getImg7());
        $copyObj->setImg8($this->getImg8());
        $copyObj->setImg9($this->getImg9());
        $copyObj->setSpecial($this->getSpecial());
        $copyObj->setActive($this->getActive());
        $copyObj->setMtTitle($this->getMtTitle());
        $copyObj->setMtDescription($this->getMtDescription());
        $copyObj->setMtKeywords($this->getMtKeywords());
        $copyObj->setRemains($this->getRemains());
        $copyObj->setdateUpdate($this->getdateUpdate());
        $copyObj->setdateCreate($this->getdateCreate());
        $copyObj->setdatePublic($this->getdatePublic());
        $copyObj->setRef($this->getRef());
        $copyObj->setMinQuality($this->getMinQuality());
        $copyObj->setSeazon($this->getSeazon());
        $copyObj->setCategoryId($this->getCategoryId());
        $copyObj->setBrandId($this->getBrandId());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            foreach ($this->getShopProductGroupsRels() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addShopProductGroupsRel($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getPositions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addPosition($relObj->copy($deepCopy));
                }
            }

            $relObj = $this->getProductHitSale();
            if ($relObj) {
                $copyObj->setProductHitSale($relObj->copy($deepCopy));
            }

            $relObj = $this->getProductSuperPrice();
            if ($relObj) {
                $copyObj->setProductSuperPrice($relObj->copy($deepCopy));
            }

            foreach ($this->getDraftProducts() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addDraftProduct($relObj->copy($deepCopy));
                }
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Shop\Infrastructure\Models\Product\Product Clone of current object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function copy(bool $deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Declares an association between this object and a Category object.
     *
     * @param Category $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setCategory(Category $v = null)
    {
        if ($v === null) {
            $this->setCategoryId(NULL);
        } else {
            $this->setCategoryId($v->getId());
        }

        $this->aCategory = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Category object, it will not be re-added.
        if ($v !== null) {
            $v->addProduct($this);
        }


        return $this;
    }


    /**
     * Get the associated Category object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return Category The associated Category object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getCategory(?ConnectionInterface $con = null)
    {
        if ($this->aCategory === null && ($this->category_id != 0)) {
            $this->aCategory = CategoryQuery::create()->findPk($this->category_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCategory->addProducts($this);
             */
        }

        return $this->aCategory;
    }

    /**
     * Declares an association between this object and a Brand object.
     *
     * @param Brand $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setBrand(Brand $v = null)
    {
        if ($v === null) {
            $this->setBrandId(NULL);
        } else {
            $this->setBrandId($v->getId());
        }

        $this->aBrand = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Brand object, it will not be re-added.
        if ($v !== null) {
            $v->addProduct($this);
        }


        return $this;
    }


    /**
     * Get the associated Brand object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return Brand The associated Brand object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getBrand(?ConnectionInterface $con = null)
    {
        if ($this->aBrand === null && ($this->brand_id != 0)) {
            $this->aBrand = BrandQuery::create()->findPk($this->brand_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aBrand->addProducts($this);
             */
        }

        return $this->aBrand;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName): void
    {
        if ('ShopProductGroupsRel' === $relationName) {
            $this->initShopProductGroupsRels();
            return;
        }
        if ('Position' === $relationName) {
            $this->initPositions();
            return;
        }
        if ('DraftProduct' === $relationName) {
            $this->initDraftProducts();
            return;
        }
    }

    /**
     * Clears out the collShopProductGroupsRels collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addShopProductGroupsRels()
     */
    public function clearShopProductGroupsRels()
    {
        $this->collShopProductGroupsRels = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collShopProductGroupsRels collection loaded partially.
     *
     * @return void
     */
    public function resetPartialShopProductGroupsRels($v = true): void
    {
        $this->collShopProductGroupsRelsPartial = $v;
    }

    /**
     * Initializes the collShopProductGroupsRels collection.
     *
     * By default this just sets the collShopProductGroupsRels collection to an empty array (like clearcollShopProductGroupsRels());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initShopProductGroupsRels(bool $overrideExisting = true): void
    {
        if (null !== $this->collShopProductGroupsRels && !$overrideExisting) {
            return;
        }

        $collectionClassName = ShopProductGroupsRelTableMap::getTableMap()->getCollectionClassName();

        $this->collShopProductGroupsRels = new $collectionClassName;
        $this->collShopProductGroupsRels->setModel('\Shop\Infrastructure\Models\ShopProductGroupsRel\ShopProductGroupsRel');
    }

    /**
     * Gets an array of ShopProductGroupsRel objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildProduct is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|ShopProductGroupsRel[] List of ShopProductGroupsRel objects
     * @phpstan-return ObjectCollection&\Traversable<ShopProductGroupsRel> List of ShopProductGroupsRel objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getShopProductGroupsRels(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collShopProductGroupsRelsPartial && !$this->isNew();
        if (null === $this->collShopProductGroupsRels || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collShopProductGroupsRels) {
                    $this->initShopProductGroupsRels();
                } else {
                    $collectionClassName = ShopProductGroupsRelTableMap::getTableMap()->getCollectionClassName();

                    $collShopProductGroupsRels = new $collectionClassName;
                    $collShopProductGroupsRels->setModel('\Shop\Infrastructure\Models\ShopProductGroupsRel\ShopProductGroupsRel');

                    return $collShopProductGroupsRels;
                }
            } else {
                $collShopProductGroupsRels = ShopProductGroupsRelQuery::create(null, $criteria)
                    ->filterByProduct($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collShopProductGroupsRelsPartial && count($collShopProductGroupsRels)) {
                        $this->initShopProductGroupsRels(false);

                        foreach ($collShopProductGroupsRels as $obj) {
                            if (false == $this->collShopProductGroupsRels->contains($obj)) {
                                $this->collShopProductGroupsRels->append($obj);
                            }
                        }

                        $this->collShopProductGroupsRelsPartial = true;
                    }

                    return $collShopProductGroupsRels;
                }

                if ($partial && $this->collShopProductGroupsRels) {
                    foreach ($this->collShopProductGroupsRels as $obj) {
                        if ($obj->isNew()) {
                            $collShopProductGroupsRels[] = $obj;
                        }
                    }
                }

                $this->collShopProductGroupsRels = $collShopProductGroupsRels;
                $this->collShopProductGroupsRelsPartial = false;
            }
        }

        return $this->collShopProductGroupsRels;
    }

    /**
     * Sets a collection of ShopProductGroupsRel objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $shopProductGroupsRels A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setShopProductGroupsRels(Collection $shopProductGroupsRels, ?ConnectionInterface $con = null)
    {
        /** @var ShopProductGroupsRel[] $shopProductGroupsRelsToDelete */
        $shopProductGroupsRelsToDelete = $this->getShopProductGroupsRels(new Criteria(), $con)->diff($shopProductGroupsRels);


        //since at least one column in the foreign key is at the same time a PK
        //we can not just set a PK to NULL in the lines below. We have to store
        //a backup of all values, so we are able to manipulate these items based on the onDelete value later.
        $this->shopProductGroupsRelsScheduledForDeletion = clone $shopProductGroupsRelsToDelete;

        foreach ($shopProductGroupsRelsToDelete as $shopProductGroupsRelRemoved) {
            $shopProductGroupsRelRemoved->setProduct(null);
        }

        $this->collShopProductGroupsRels = null;
        foreach ($shopProductGroupsRels as $shopProductGroupsRel) {
            $this->addShopProductGroupsRel($shopProductGroupsRel);
        }

        $this->collShopProductGroupsRels = $shopProductGroupsRels;
        $this->collShopProductGroupsRelsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseShopProductGroupsRel objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseShopProductGroupsRel objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countShopProductGroupsRels(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collShopProductGroupsRelsPartial && !$this->isNew();
        if (null === $this->collShopProductGroupsRels || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collShopProductGroupsRels) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getShopProductGroupsRels());
            }

            $query = ShopProductGroupsRelQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByProduct($this)
                ->count($con);
        }

        return count($this->collShopProductGroupsRels);
    }

    /**
     * Method called to associate a ShopProductGroupsRel object to this object
     * through the ShopProductGroupsRel foreign key attribute.
     *
     * @param ShopProductGroupsRel $l ShopProductGroupsRel
     * @return $this The current object (for fluent API support)
     */
    public function addShopProductGroupsRel(ShopProductGroupsRel $l)
    {
        if ($this->collShopProductGroupsRels === null) {
            $this->initShopProductGroupsRels();
            $this->collShopProductGroupsRelsPartial = true;
        }

        if (!$this->collShopProductGroupsRels->contains($l)) {
            $this->doAddShopProductGroupsRel($l);

            if ($this->shopProductGroupsRelsScheduledForDeletion and $this->shopProductGroupsRelsScheduledForDeletion->contains($l)) {
                $this->shopProductGroupsRelsScheduledForDeletion->remove($this->shopProductGroupsRelsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param ShopProductGroupsRel $shopProductGroupsRel The ShopProductGroupsRel object to add.
     */
    protected function doAddShopProductGroupsRel(ShopProductGroupsRel $shopProductGroupsRel): void
    {
        $this->collShopProductGroupsRels[]= $shopProductGroupsRel;
        $shopProductGroupsRel->setProduct($this);
    }

    /**
     * @param ShopProductGroupsRel $shopProductGroupsRel The ShopProductGroupsRel object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeShopProductGroupsRel(ShopProductGroupsRel $shopProductGroupsRel)
    {
        if ($this->getShopProductGroupsRels()->contains($shopProductGroupsRel)) {
            $pos = $this->collShopProductGroupsRels->search($shopProductGroupsRel);
            $this->collShopProductGroupsRels->remove($pos);
            if (null === $this->shopProductGroupsRelsScheduledForDeletion) {
                $this->shopProductGroupsRelsScheduledForDeletion = clone $this->collShopProductGroupsRels;
                $this->shopProductGroupsRelsScheduledForDeletion->clear();
            }
            $this->shopProductGroupsRelsScheduledForDeletion[]= clone $shopProductGroupsRel;
            $shopProductGroupsRel->setProduct(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Product is new, it will return
     * an empty collection; or if this Product has previously
     * been saved, it will retrieve related ShopProductGroupsRels from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Product.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|ShopProductGroupsRel[] List of ShopProductGroupsRel objects
     * @phpstan-return ObjectCollection&\Traversable<ShopProductGroupsRel}> List of ShopProductGroupsRel objects
     */
    public function getShopProductGroupsRelsJoinProductGroup(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = ShopProductGroupsRelQuery::create(null, $criteria);
        $query->joinWith('ProductGroup', $joinBehavior);

        return $this->getShopProductGroupsRels($query, $con);
    }

    /**
     * Clears out the collPositions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addPositions()
     */
    public function clearPositions()
    {
        $this->collPositions = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collPositions collection loaded partially.
     *
     * @return void
     */
    public function resetPartialPositions($v = true): void
    {
        $this->collPositionsPartial = $v;
    }

    /**
     * Initializes the collPositions collection.
     *
     * By default this just sets the collPositions collection to an empty array (like clearcollPositions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initPositions(bool $overrideExisting = true): void
    {
        if (null !== $this->collPositions && !$overrideExisting) {
            return;
        }

        $collectionClassName = PositionTableMap::getTableMap()->getCollectionClassName();

        $this->collPositions = new $collectionClassName;
        $this->collPositions->setModel('\Shop\Infrastructure\Models\Position\Position');
    }

    /**
     * Gets an array of Position objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildProduct is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|Position[] List of Position objects
     * @phpstan-return ObjectCollection&\Traversable<Position> List of Position objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getPositions(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collPositionsPartial && !$this->isNew();
        if (null === $this->collPositions || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collPositions) {
                    $this->initPositions();
                } else {
                    $collectionClassName = PositionTableMap::getTableMap()->getCollectionClassName();

                    $collPositions = new $collectionClassName;
                    $collPositions->setModel('\Shop\Infrastructure\Models\Position\Position');

                    return $collPositions;
                }
            } else {
                $collPositions = PositionQuery::create(null, $criteria)
                    ->filterByProduct($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collPositionsPartial && count($collPositions)) {
                        $this->initPositions(false);

                        foreach ($collPositions as $obj) {
                            if (false == $this->collPositions->contains($obj)) {
                                $this->collPositions->append($obj);
                            }
                        }

                        $this->collPositionsPartial = true;
                    }

                    return $collPositions;
                }

                if ($partial && $this->collPositions) {
                    foreach ($this->collPositions as $obj) {
                        if ($obj->isNew()) {
                            $collPositions[] = $obj;
                        }
                    }
                }

                $this->collPositions = $collPositions;
                $this->collPositionsPartial = false;
            }
        }

        return $this->collPositions;
    }

    /**
     * Sets a collection of Position objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $positions A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setPositions(Collection $positions, ?ConnectionInterface $con = null)
    {
        /** @var Position[] $positionsToDelete */
        $positionsToDelete = $this->getPositions(new Criteria(), $con)->diff($positions);


        $this->positionsScheduledForDeletion = $positionsToDelete;

        foreach ($positionsToDelete as $positionRemoved) {
            $positionRemoved->setProduct(null);
        }

        $this->collPositions = null;
        foreach ($positions as $position) {
            $this->addPosition($position);
        }

        $this->collPositions = $positions;
        $this->collPositionsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BasePosition objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BasePosition objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countPositions(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collPositionsPartial && !$this->isNew();
        if (null === $this->collPositions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collPositions) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getPositions());
            }

            $query = PositionQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByProduct($this)
                ->count($con);
        }

        return count($this->collPositions);
    }

    /**
     * Method called to associate a Position object to this object
     * through the Position foreign key attribute.
     *
     * @param Position $l Position
     * @return $this The current object (for fluent API support)
     */
    public function addPosition(Position $l)
    {
        if ($this->collPositions === null) {
            $this->initPositions();
            $this->collPositionsPartial = true;
        }

        if (!$this->collPositions->contains($l)) {
            $this->doAddPosition($l);

            if ($this->positionsScheduledForDeletion and $this->positionsScheduledForDeletion->contains($l)) {
                $this->positionsScheduledForDeletion->remove($this->positionsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Position $position The Position object to add.
     */
    protected function doAddPosition(Position $position): void
    {
        $this->collPositions[]= $position;
        $position->setProduct($this);
    }

    /**
     * @param Position $position The Position object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removePosition(Position $position)
    {
        if ($this->getPositions()->contains($position)) {
            $pos = $this->collPositions->search($position);
            $this->collPositions->remove($pos);
            if (null === $this->positionsScheduledForDeletion) {
                $this->positionsScheduledForDeletion = clone $this->collPositions;
                $this->positionsScheduledForDeletion->clear();
            }
            $this->positionsScheduledForDeletion[]= clone $position;
            $position->setProduct(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Product is new, it will return
     * an empty collection; or if this Product has previously
     * been saved, it will retrieve related Positions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Product.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Position[] List of Position objects
     * @phpstan-return ObjectCollection&\Traversable<Position}> List of Position objects
     */
    public function getPositionsJoinSale(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = PositionQuery::create(null, $criteria);
        $query->joinWith('Sale', $joinBehavior);

        return $this->getPositions($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Product is new, it will return
     * an empty collection; or if this Product has previously
     * been saved, it will retrieve related Positions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Product.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Position[] List of Position objects
     * @phpstan-return ObjectCollection&\Traversable<Position}> List of Position objects
     */
    public function getPositionsJoinPricelistSheet(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = PositionQuery::create(null, $criteria);
        $query->joinWith('PricelistSheet', $joinBehavior);

        return $this->getPositions($query, $con);
    }

    /**
     * Gets a single ProductHitSale object, which is related to this object by a one-to-one relationship.
     *
     * @param ConnectionInterface $con optional connection object
     * @return ProductHitSale|null
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getProductHitSale(?ConnectionInterface $con = null)
    {

        if ($this->singleProductHitSale === null && !$this->isNew()) {
            $this->singleProductHitSale = ProductHitSaleQuery::create()->findPk($this->getPrimaryKey(), $con);
        }

        return $this->singleProductHitSale;
    }

    /**
     * Sets a single ProductHitSale object as related to this object by a one-to-one relationship.
     *
     * @param ProductHitSale $v ProductHitSale
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setProductHitSale(ProductHitSale $v = null)
    {
        $this->singleProductHitSale = $v;

        // Make sure that that the passed-in ProductHitSale isn't already associated with this object
        if ($v !== null && $v->getProduct(null, false) === null) {
            $v->setProduct($this);
        }

        return $this;
    }

    /**
     * Gets a single ProductSuperPrice object, which is related to this object by a one-to-one relationship.
     *
     * @param ConnectionInterface $con optional connection object
     * @return ProductSuperPrice|null
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getProductSuperPrice(?ConnectionInterface $con = null)
    {

        if ($this->singleProductSuperPrice === null && !$this->isNew()) {
            $this->singleProductSuperPrice = ProductSuperPriceQuery::create()->findPk($this->getPrimaryKey(), $con);
        }

        return $this->singleProductSuperPrice;
    }

    /**
     * Sets a single ProductSuperPrice object as related to this object by a one-to-one relationship.
     *
     * @param ProductSuperPrice $v ProductSuperPrice
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setProductSuperPrice(ProductSuperPrice $v = null)
    {
        $this->singleProductSuperPrice = $v;

        // Make sure that that the passed-in ProductSuperPrice isn't already associated with this object
        if ($v !== null && $v->getProduct(null, false) === null) {
            $v->setProduct($this);
        }

        return $this;
    }

    /**
     * Clears out the collDraftProducts collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addDraftProducts()
     */
    public function clearDraftProducts()
    {
        $this->collDraftProducts = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collDraftProducts collection loaded partially.
     *
     * @return void
     */
    public function resetPartialDraftProducts($v = true): void
    {
        $this->collDraftProductsPartial = $v;
    }

    /**
     * Initializes the collDraftProducts collection.
     *
     * By default this just sets the collDraftProducts collection to an empty array (like clearcollDraftProducts());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initDraftProducts(bool $overrideExisting = true): void
    {
        if (null !== $this->collDraftProducts && !$overrideExisting) {
            return;
        }

        $collectionClassName = DraftProductTableMap::getTableMap()->getCollectionClassName();

        $this->collDraftProducts = new $collectionClassName;
        $this->collDraftProducts->setModel('\Shop\Infrastructure\Models\DraftProduct\DraftProduct');
    }

    /**
     * Gets an array of DraftProduct objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildProduct is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     * @phpstan-return ObjectCollection&\Traversable<DraftProduct> List of DraftProduct objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getDraftProducts(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collDraftProductsPartial && !$this->isNew();
        if (null === $this->collDraftProducts || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collDraftProducts) {
                    $this->initDraftProducts();
                } else {
                    $collectionClassName = DraftProductTableMap::getTableMap()->getCollectionClassName();

                    $collDraftProducts = new $collectionClassName;
                    $collDraftProducts->setModel('\Shop\Infrastructure\Models\DraftProduct\DraftProduct');

                    return $collDraftProducts;
                }
            } else {
                $collDraftProducts = DraftProductQuery::create(null, $criteria)
                    ->filterByProduct($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collDraftProductsPartial && count($collDraftProducts)) {
                        $this->initDraftProducts(false);

                        foreach ($collDraftProducts as $obj) {
                            if (false == $this->collDraftProducts->contains($obj)) {
                                $this->collDraftProducts->append($obj);
                            }
                        }

                        $this->collDraftProductsPartial = true;
                    }

                    return $collDraftProducts;
                }

                if ($partial && $this->collDraftProducts) {
                    foreach ($this->collDraftProducts as $obj) {
                        if ($obj->isNew()) {
                            $collDraftProducts[] = $obj;
                        }
                    }
                }

                $this->collDraftProducts = $collDraftProducts;
                $this->collDraftProductsPartial = false;
            }
        }

        return $this->collDraftProducts;
    }

    /**
     * Sets a collection of DraftProduct objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $draftProducts A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setDraftProducts(Collection $draftProducts, ?ConnectionInterface $con = null)
    {
        /** @var DraftProduct[] $draftProductsToDelete */
        $draftProductsToDelete = $this->getDraftProducts(new Criteria(), $con)->diff($draftProducts);


        $this->draftProductsScheduledForDeletion = $draftProductsToDelete;

        foreach ($draftProductsToDelete as $draftProductRemoved) {
            $draftProductRemoved->setProduct(null);
        }

        $this->collDraftProducts = null;
        foreach ($draftProducts as $draftProduct) {
            $this->addDraftProduct($draftProduct);
        }

        $this->collDraftProducts = $draftProducts;
        $this->collDraftProductsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseDraftProduct objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseDraftProduct objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countDraftProducts(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collDraftProductsPartial && !$this->isNew();
        if (null === $this->collDraftProducts || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collDraftProducts) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getDraftProducts());
            }

            $query = DraftProductQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByProduct($this)
                ->count($con);
        }

        return count($this->collDraftProducts);
    }

    /**
     * Method called to associate a DraftProduct object to this object
     * through the DraftProduct foreign key attribute.
     *
     * @param DraftProduct $l DraftProduct
     * @return $this The current object (for fluent API support)
     */
    public function addDraftProduct(DraftProduct $l)
    {
        if ($this->collDraftProducts === null) {
            $this->initDraftProducts();
            $this->collDraftProductsPartial = true;
        }

        if (!$this->collDraftProducts->contains($l)) {
            $this->doAddDraftProduct($l);

            if ($this->draftProductsScheduledForDeletion and $this->draftProductsScheduledForDeletion->contains($l)) {
                $this->draftProductsScheduledForDeletion->remove($this->draftProductsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param DraftProduct $draftProduct The DraftProduct object to add.
     */
    protected function doAddDraftProduct(DraftProduct $draftProduct): void
    {
        $this->collDraftProducts[]= $draftProduct;
        $draftProduct->setProduct($this);
    }

    /**
     * @param DraftProduct $draftProduct The DraftProduct object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeDraftProduct(DraftProduct $draftProduct)
    {
        if ($this->getDraftProducts()->contains($draftProduct)) {
            $pos = $this->collDraftProducts->search($draftProduct);
            $this->collDraftProducts->remove($pos);
            if (null === $this->draftProductsScheduledForDeletion) {
                $this->draftProductsScheduledForDeletion = clone $this->collDraftProducts;
                $this->draftProductsScheduledForDeletion->clear();
            }
            $this->draftProductsScheduledForDeletion[]= $draftProduct;
            $draftProduct->setProduct(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Product is new, it will return
     * an empty collection; or if this Product has previously
     * been saved, it will retrieve related DraftProducts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Product.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     * @phpstan-return ObjectCollection&\Traversable<DraftProduct}> List of DraftProduct objects
     */
    public function getDraftProductsJoinCategory(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DraftProductQuery::create(null, $criteria);
        $query->joinWith('Category', $joinBehavior);

        return $this->getDraftProducts($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Product is new, it will return
     * an empty collection; or if this Product has previously
     * been saved, it will retrieve related DraftProducts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Product.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     * @phpstan-return ObjectCollection&\Traversable<DraftProduct}> List of DraftProduct objects
     */
    public function getDraftProductsJoinBrand(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DraftProductQuery::create(null, $criteria);
        $query->joinWith('Brand', $joinBehavior);

        return $this->getDraftProducts($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Product is new, it will return
     * an empty collection; or if this Product has previously
     * been saved, it will retrieve related DraftProducts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Product.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     * @phpstan-return ObjectCollection&\Traversable<DraftProduct}> List of DraftProduct objects
     */
    public function getDraftProductsJoinCustomer(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DraftProductQuery::create(null, $criteria);
        $query->joinWith('Customer', $joinBehavior);

        return $this->getDraftProducts($query, $con);
    }

    /**
     * Clears out the collProductGroups collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProductGroups()
     */
    public function clearProductGroups()
    {
        $this->collProductGroups = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Initializes the collProductGroups crossRef collection.
     *
     * By default this just sets the collProductGroups collection to an empty collection (like clearProductGroups());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initProductGroups()
    {
        $collectionClassName = ShopProductGroupsRelTableMap::getTableMap()->getCollectionClassName();

        $this->collProductGroups = new $collectionClassName;
        $this->collProductGroupsPartial = true;
        $this->collProductGroups->setModel('\Shop\Infrastructure\Models\ProductGroup\ProductGroup');
    }

    /**
     * Checks if the collProductGroups collection is loaded.
     *
     * @return bool
     */
    public function isProductGroupsLoaded(): bool
    {
        return null !== $this->collProductGroups;
    }

    /**
     * Gets a collection of ProductGroup objects related by a many-to-many relationship
     * to the current object by way of the shop_product_groups_rel cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildProduct is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param ConnectionInterface $con Optional connection object
     *
     * @return ObjectCollection|ProductGroup[] List of ProductGroup objects
     * @phpstan-return ObjectCollection&\Traversable<ProductGroup> List of ProductGroup objects
     */
    public function getProductGroups(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collProductGroupsPartial && !$this->isNew();
        if (null === $this->collProductGroups || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collProductGroups) {
                    $this->initProductGroups();
                }
            } else {

                $query = ProductGroupQuery::create(null, $criteria)
                    ->filterByProduct($this);
                $collProductGroups = $query->find($con);
                if (null !== $criteria) {
                    return $collProductGroups;
                }

                if ($partial && $this->collProductGroups) {
                    //make sure that already added objects gets added to the list of the database.
                    foreach ($this->collProductGroups as $obj) {
                        if (!$collProductGroups->contains($obj)) {
                            $collProductGroups[] = $obj;
                        }
                    }
                }

                $this->collProductGroups = $collProductGroups;
                $this->collProductGroupsPartial = false;
            }
        }

        return $this->collProductGroups;
    }

    /**
     * Sets a collection of ProductGroup objects related by a many-to-many relationship
     * to the current object by way of the shop_product_groups_rel cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $productGroups A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setProductGroups(Collection $productGroups, ?ConnectionInterface $con = null)
    {
        $this->clearProductGroups();
        $currentProductGroups = $this->getProductGroups();

        $productGroupsScheduledForDeletion = $currentProductGroups->diff($productGroups);

        foreach ($productGroupsScheduledForDeletion as $toDelete) {
            $this->removeProductGroup($toDelete);
        }

        foreach ($productGroups as $productGroup) {
            if (!$currentProductGroups->contains($productGroup)) {
                $this->doAddProductGroup($productGroup);
            }
        }

        $this->collProductGroupsPartial = false;
        $this->collProductGroups = $productGroups;

        return $this;
    }

    /**
     * Gets the number of ProductGroup objects related by a many-to-many relationship
     * to the current object by way of the shop_product_groups_rel cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param bool $distinct Set to true to force count distinct
     * @param ConnectionInterface $con Optional connection object
     *
     * @return int The number of related ProductGroup objects
     */
    public function countProductGroups(?Criteria $criteria = null, $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collProductGroupsPartial && !$this->isNew();
        if (null === $this->collProductGroups || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProductGroups) {
                return 0;
            } else {

                if ($partial && !$criteria) {
                    return count($this->getProductGroups());
                }

                $query = ProductGroupQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProduct($this)
                    ->count($con);
            }
        } else {
            return count($this->collProductGroups);
        }
    }

    /**
     * Associate a ProductGroup to this object
     * through the shop_product_groups_rel cross reference table.
     *
     * @param ProductGroup $productGroup
     * @return ChildProduct The current object (for fluent API support)
     */
    public function addProductGroup(ProductGroup $productGroup)
    {
        if ($this->collProductGroups === null) {
            $this->initProductGroups();
        }

        if (!$this->getProductGroups()->contains($productGroup)) {
            // only add it if the **same** object is not already associated
            $this->collProductGroups->push($productGroup);
            $this->doAddProductGroup($productGroup);
        }

        return $this;
    }

    /**
     *
     * @param ProductGroup $productGroup
     */
    protected function doAddProductGroup(ProductGroup $productGroup)
    {
        $shopProductGroupsRel = new ShopProductGroupsRel();

        $shopProductGroupsRel->setProductGroup($productGroup);

        $shopProductGroupsRel->setProduct($this);

        $this->addShopProductGroupsRel($shopProductGroupsRel);

        // set the back reference to this object directly as using provided method either results
        // in endless loop or in multiple relations
        if (!$productGroup->isProductsLoaded()) {
            $productGroup->initProducts();
            $productGroup->getProducts()->push($this);
        } elseif (!$productGroup->getProducts()->contains($this)) {
            $productGroup->getProducts()->push($this);
        }

    }

    /**
     * Remove productGroup of this object
     * through the shop_product_groups_rel cross reference table.
     *
     * @param ProductGroup $productGroup
     * @return ChildProduct The current object (for fluent API support)
     */
    public function removeProductGroup(ProductGroup $productGroup)
    {
        if ($this->getProductGroups()->contains($productGroup)) {
            $shopProductGroupsRel = new ShopProductGroupsRel();
            $shopProductGroupsRel->setProductGroup($productGroup);
            if ($productGroup->isProductsLoaded()) {
                //remove the back reference if available
                $productGroup->getProducts()->removeObject($this);
            }

            $shopProductGroupsRel->setProduct($this);
            $this->removeShopProductGroupsRel(clone $shopProductGroupsRel);
            $shopProductGroupsRel->clear();

            $this->collProductGroups->remove($this->collProductGroups->search($productGroup));

            if (null === $this->productGroupsScheduledForDeletion) {
                $this->productGroupsScheduledForDeletion = clone $this->collProductGroups;
                $this->productGroupsScheduledForDeletion->clear();
            }

            $this->productGroupsScheduledForDeletion->push($productGroup);
        }


        return $this;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     *
     * @return $this
     */
    public function clear()
    {
        if (null !== $this->aCategory) {
            $this->aCategory->removeProduct($this);
        }
        if (null !== $this->aBrand) {
            $this->aBrand->removeProduct($this);
        }
        $this->id = null;
        $this->title = null;
        $this->desc = null;
        $this->short_desc = null;
        $this->article = null;
        $this->price = null;
        $this->weight = null;
        $this->img = null;
        $this->img1 = null;
        $this->img2 = null;
        $this->img3 = null;
        $this->img4 = null;
        $this->img5 = null;
        $this->img6 = null;
        $this->img7 = null;
        $this->img8 = null;
        $this->img9 = null;
        $this->special = null;
        $this->active = null;
        $this->mt_title = null;
        $this->mt_description = null;
        $this->mt_keywords = null;
        $this->remains = null;
        $this->udate = null;
        $this->cdate = null;
        $this->pdate = null;
        $this->ref = null;
        $this->min_quality = null;
        $this->seazon = null;
        $this->category_id = null;
        $this->brand_id = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);

        return $this;
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param bool $deep Whether to also clear the references on all referrer objects.
     * @return $this
     */
    public function clearAllReferences(bool $deep = false)
    {
        if ($deep) {
            if ($this->collShopProductGroupsRels) {
                foreach ($this->collShopProductGroupsRels as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collPositions) {
                foreach ($this->collPositions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->singleProductHitSale) {
                $this->singleProductHitSale->clearAllReferences($deep);
            }
            if ($this->singleProductSuperPrice) {
                $this->singleProductSuperPrice->clearAllReferences($deep);
            }
            if ($this->collDraftProducts) {
                foreach ($this->collDraftProducts as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProductGroups) {
                foreach ($this->collProductGroups as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        $this->collShopProductGroupsRels = null;
        $this->collPositions = null;
        $this->singleProductHitSale = null;
        $this->singleProductSuperPrice = null;
        $this->collDraftProducts = null;
        $this->collProductGroups = null;
        $this->aCategory = null;
        $this->aBrand = null;
        return $this;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(ProductTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preSave(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postSave(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before inserting to database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preInsert(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postInsert(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preUpdate(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postUpdate(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preDelete(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postDelete(?ConnectionInterface $con = null): void
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);
            $inputData = $params[0];
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->importFrom($format, $inputData, $keyType);
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = $params[0] ?? true;
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->exportTo($format, $includeLazyLoadColumns, $keyType);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
