<?php

namespace Shop\Infrastructure\Models\Category\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Catalog\Catalog;
use Shop\Infrastructure\Models\Category\Category as ChildCategory;
use Shop\Infrastructure\Models\Category\CategoryQuery as ChildCategoryQuery;
use Shop\Infrastructure\Models\Category\Map\CategoryTableMap;
use Shop\Infrastructure\Models\DiscountRule\DiscountRule;
use Shop\Infrastructure\Models\DraftProduct\DraftProduct;
use Shop\Infrastructure\Models\ImageDefault\ImageDefault;
use Shop\Infrastructure\Models\Product\Product;
use Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel;

/**
 * Base class that represents a query for the 'shop_categories' table.
 *
 *
 *
 * @method     ChildCategoryQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildCategoryQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildCategoryQuery orderByAlias($order = Criteria::ASC) Order by the alias column
 * @method     ChildCategoryQuery orderByFullTitle($order = Criteria::ASC) Order by the full_title column
 * @method     ChildCategoryQuery orderByImage($order = Criteria::ASC) Order by the image column
 * @method     ChildCategoryQuery orderByDesc($order = Criteria::ASC) Order by the desc column
 * @method     ChildCategoryQuery orderByParentId($order = Criteria::ASC) Order by the parent_id column
 * @method     ChildCategoryQuery orderByCatalogId($order = Criteria::ASC) Order by the catalog_id column
 *
 * @method     ChildCategoryQuery groupById() Group by the id column
 * @method     ChildCategoryQuery groupByTitle() Group by the title column
 * @method     ChildCategoryQuery groupByAlias() Group by the alias column
 * @method     ChildCategoryQuery groupByFullTitle() Group by the full_title column
 * @method     ChildCategoryQuery groupByImage() Group by the image column
 * @method     ChildCategoryQuery groupByDesc() Group by the desc column
 * @method     ChildCategoryQuery groupByParentId() Group by the parent_id column
 * @method     ChildCategoryQuery groupByCatalogId() Group by the catalog_id column
 *
 * @method     ChildCategoryQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildCategoryQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildCategoryQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildCategoryQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildCategoryQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildCategoryQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildCategoryQuery leftJoinParentCategory($relationAlias = null) Adds a LEFT JOIN clause to the query using the ParentCategory relation
 * @method     ChildCategoryQuery rightJoinParentCategory($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ParentCategory relation
 * @method     ChildCategoryQuery innerJoinParentCategory($relationAlias = null) Adds a INNER JOIN clause to the query using the ParentCategory relation
 *
 * @method     ChildCategoryQuery joinWithParentCategory($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ParentCategory relation
 *
 * @method     ChildCategoryQuery leftJoinWithParentCategory() Adds a LEFT JOIN clause and with to the query using the ParentCategory relation
 * @method     ChildCategoryQuery rightJoinWithParentCategory() Adds a RIGHT JOIN clause and with to the query using the ParentCategory relation
 * @method     ChildCategoryQuery innerJoinWithParentCategory() Adds a INNER JOIN clause and with to the query using the ParentCategory relation
 *
 * @method     ChildCategoryQuery leftJoinCatalog($relationAlias = null) Adds a LEFT JOIN clause to the query using the Catalog relation
 * @method     ChildCategoryQuery rightJoinCatalog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Catalog relation
 * @method     ChildCategoryQuery innerJoinCatalog($relationAlias = null) Adds a INNER JOIN clause to the query using the Catalog relation
 *
 * @method     ChildCategoryQuery joinWithCatalog($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Catalog relation
 *
 * @method     ChildCategoryQuery leftJoinWithCatalog() Adds a LEFT JOIN clause and with to the query using the Catalog relation
 * @method     ChildCategoryQuery rightJoinWithCatalog() Adds a RIGHT JOIN clause and with to the query using the Catalog relation
 * @method     ChildCategoryQuery innerJoinWithCatalog() Adds a INNER JOIN clause and with to the query using the Catalog relation
 *
 * @method     ChildCategoryQuery leftJoinCategoryRelatedById($relationAlias = null) Adds a LEFT JOIN clause to the query using the CategoryRelatedById relation
 * @method     ChildCategoryQuery rightJoinCategoryRelatedById($relationAlias = null) Adds a RIGHT JOIN clause to the query using the CategoryRelatedById relation
 * @method     ChildCategoryQuery innerJoinCategoryRelatedById($relationAlias = null) Adds a INNER JOIN clause to the query using the CategoryRelatedById relation
 *
 * @method     ChildCategoryQuery joinWithCategoryRelatedById($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the CategoryRelatedById relation
 *
 * @method     ChildCategoryQuery leftJoinWithCategoryRelatedById() Adds a LEFT JOIN clause and with to the query using the CategoryRelatedById relation
 * @method     ChildCategoryQuery rightJoinWithCategoryRelatedById() Adds a RIGHT JOIN clause and with to the query using the CategoryRelatedById relation
 * @method     ChildCategoryQuery innerJoinWithCategoryRelatedById() Adds a INNER JOIN clause and with to the query using the CategoryRelatedById relation
 *
 * @method     ChildCategoryQuery leftJoinProduct($relationAlias = null) Adds a LEFT JOIN clause to the query using the Product relation
 * @method     ChildCategoryQuery rightJoinProduct($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Product relation
 * @method     ChildCategoryQuery innerJoinProduct($relationAlias = null) Adds a INNER JOIN clause to the query using the Product relation
 *
 * @method     ChildCategoryQuery joinWithProduct($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Product relation
 *
 * @method     ChildCategoryQuery leftJoinWithProduct() Adds a LEFT JOIN clause and with to the query using the Product relation
 * @method     ChildCategoryQuery rightJoinWithProduct() Adds a RIGHT JOIN clause and with to the query using the Product relation
 * @method     ChildCategoryQuery innerJoinWithProduct() Adds a INNER JOIN clause and with to the query using the Product relation
 *
 * @method     ChildCategoryQuery leftJoinSizeGridCategoryRel($relationAlias = null) Adds a LEFT JOIN clause to the query using the SizeGridCategoryRel relation
 * @method     ChildCategoryQuery rightJoinSizeGridCategoryRel($relationAlias = null) Adds a RIGHT JOIN clause to the query using the SizeGridCategoryRel relation
 * @method     ChildCategoryQuery innerJoinSizeGridCategoryRel($relationAlias = null) Adds a INNER JOIN clause to the query using the SizeGridCategoryRel relation
 *
 * @method     ChildCategoryQuery joinWithSizeGridCategoryRel($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the SizeGridCategoryRel relation
 *
 * @method     ChildCategoryQuery leftJoinWithSizeGridCategoryRel() Adds a LEFT JOIN clause and with to the query using the SizeGridCategoryRel relation
 * @method     ChildCategoryQuery rightJoinWithSizeGridCategoryRel() Adds a RIGHT JOIN clause and with to the query using the SizeGridCategoryRel relation
 * @method     ChildCategoryQuery innerJoinWithSizeGridCategoryRel() Adds a INNER JOIN clause and with to the query using the SizeGridCategoryRel relation
 *
 * @method     ChildCategoryQuery leftJoinDiscountRule($relationAlias = null) Adds a LEFT JOIN clause to the query using the DiscountRule relation
 * @method     ChildCategoryQuery rightJoinDiscountRule($relationAlias = null) Adds a RIGHT JOIN clause to the query using the DiscountRule relation
 * @method     ChildCategoryQuery innerJoinDiscountRule($relationAlias = null) Adds a INNER JOIN clause to the query using the DiscountRule relation
 *
 * @method     ChildCategoryQuery joinWithDiscountRule($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the DiscountRule relation
 *
 * @method     ChildCategoryQuery leftJoinWithDiscountRule() Adds a LEFT JOIN clause and with to the query using the DiscountRule relation
 * @method     ChildCategoryQuery rightJoinWithDiscountRule() Adds a RIGHT JOIN clause and with to the query using the DiscountRule relation
 * @method     ChildCategoryQuery innerJoinWithDiscountRule() Adds a INNER JOIN clause and with to the query using the DiscountRule relation
 *
 * @method     ChildCategoryQuery leftJoinImageDefault($relationAlias = null) Adds a LEFT JOIN clause to the query using the ImageDefault relation
 * @method     ChildCategoryQuery rightJoinImageDefault($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ImageDefault relation
 * @method     ChildCategoryQuery innerJoinImageDefault($relationAlias = null) Adds a INNER JOIN clause to the query using the ImageDefault relation
 *
 * @method     ChildCategoryQuery joinWithImageDefault($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ImageDefault relation
 *
 * @method     ChildCategoryQuery leftJoinWithImageDefault() Adds a LEFT JOIN clause and with to the query using the ImageDefault relation
 * @method     ChildCategoryQuery rightJoinWithImageDefault() Adds a RIGHT JOIN clause and with to the query using the ImageDefault relation
 * @method     ChildCategoryQuery innerJoinWithImageDefault() Adds a INNER JOIN clause and with to the query using the ImageDefault relation
 *
 * @method     ChildCategoryQuery leftJoinDraftProduct($relationAlias = null) Adds a LEFT JOIN clause to the query using the DraftProduct relation
 * @method     ChildCategoryQuery rightJoinDraftProduct($relationAlias = null) Adds a RIGHT JOIN clause to the query using the DraftProduct relation
 * @method     ChildCategoryQuery innerJoinDraftProduct($relationAlias = null) Adds a INNER JOIN clause to the query using the DraftProduct relation
 *
 * @method     ChildCategoryQuery joinWithDraftProduct($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the DraftProduct relation
 *
 * @method     ChildCategoryQuery leftJoinWithDraftProduct() Adds a LEFT JOIN clause and with to the query using the DraftProduct relation
 * @method     ChildCategoryQuery rightJoinWithDraftProduct() Adds a RIGHT JOIN clause and with to the query using the DraftProduct relation
 * @method     ChildCategoryQuery innerJoinWithDraftProduct() Adds a INNER JOIN clause and with to the query using the DraftProduct relation
 *
 * @method     \Shop\Infrastructure\Models\Category\CategoryQuery|\Shop\Infrastructure\Models\Catalog\CatalogQuery|\Shop\Infrastructure\Models\Product\ProductQuery|\Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery|\Shop\Infrastructure\Models\DiscountRule\DiscountRuleQuery|\Shop\Infrastructure\Models\ImageDefault\ImageDefaultQuery|\Shop\Infrastructure\Models\DraftProduct\DraftProductQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildCategory|null findOne(?ConnectionInterface $con = null) Return the first ChildCategory matching the query
 * @method     ChildCategory findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildCategory matching the query, or a new ChildCategory object populated from the query conditions when no match is found
 *
 * @method     ChildCategory|null findOneById(int $id) Return the first ChildCategory filtered by the id column
 * @method     ChildCategory|null findOneByTitle(string $title) Return the first ChildCategory filtered by the title column
 * @method     ChildCategory|null findOneByAlias(string $alias) Return the first ChildCategory filtered by the alias column
 * @method     ChildCategory|null findOneByFullTitle(string $full_title) Return the first ChildCategory filtered by the full_title column
 * @method     ChildCategory|null findOneByImage(string $image) Return the first ChildCategory filtered by the image column
 * @method     ChildCategory|null findOneByDesc(string $desc) Return the first ChildCategory filtered by the desc column
 * @method     ChildCategory|null findOneByParentId(int $parent_id) Return the first ChildCategory filtered by the parent_id column
 * @method     ChildCategory|null findOneByCatalogId(int $catalog_id) Return the first ChildCategory filtered by the catalog_id column *

 * @method     ChildCategory requirePk($key, ?ConnectionInterface $con = null) Return the ChildCategory by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCategory requireOne(?ConnectionInterface $con = null) Return the first ChildCategory matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildCategory requireOneById(int $id) Return the first ChildCategory filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCategory requireOneByTitle(string $title) Return the first ChildCategory filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCategory requireOneByAlias(string $alias) Return the first ChildCategory filtered by the alias column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCategory requireOneByFullTitle(string $full_title) Return the first ChildCategory filtered by the full_title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCategory requireOneByImage(string $image) Return the first ChildCategory filtered by the image column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCategory requireOneByDesc(string $desc) Return the first ChildCategory filtered by the desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCategory requireOneByParentId(int $parent_id) Return the first ChildCategory filtered by the parent_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCategory requireOneByCatalogId(int $catalog_id) Return the first ChildCategory filtered by the catalog_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildCategory[]|Collection find(?ConnectionInterface $con = null) Return ChildCategory objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildCategory> find(?ConnectionInterface $con = null) Return ChildCategory objects based on current ModelCriteria
 * @method     ChildCategory[]|Collection findById(int $id) Return ChildCategory objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildCategory> findById(int $id) Return ChildCategory objects filtered by the id column
 * @method     ChildCategory[]|Collection findByTitle(string $title) Return ChildCategory objects filtered by the title column
 * @psalm-method Collection&\Traversable<ChildCategory> findByTitle(string $title) Return ChildCategory objects filtered by the title column
 * @method     ChildCategory[]|Collection findByAlias(string $alias) Return ChildCategory objects filtered by the alias column
 * @psalm-method Collection&\Traversable<ChildCategory> findByAlias(string $alias) Return ChildCategory objects filtered by the alias column
 * @method     ChildCategory[]|Collection findByFullTitle(string $full_title) Return ChildCategory objects filtered by the full_title column
 * @psalm-method Collection&\Traversable<ChildCategory> findByFullTitle(string $full_title) Return ChildCategory objects filtered by the full_title column
 * @method     ChildCategory[]|Collection findByImage(string $image) Return ChildCategory objects filtered by the image column
 * @psalm-method Collection&\Traversable<ChildCategory> findByImage(string $image) Return ChildCategory objects filtered by the image column
 * @method     ChildCategory[]|Collection findByDesc(string $desc) Return ChildCategory objects filtered by the desc column
 * @psalm-method Collection&\Traversable<ChildCategory> findByDesc(string $desc) Return ChildCategory objects filtered by the desc column
 * @method     ChildCategory[]|Collection findByParentId(int $parent_id) Return ChildCategory objects filtered by the parent_id column
 * @psalm-method Collection&\Traversable<ChildCategory> findByParentId(int $parent_id) Return ChildCategory objects filtered by the parent_id column
 * @method     ChildCategory[]|Collection findByCatalogId(int $catalog_id) Return ChildCategory objects filtered by the catalog_id column
 * @psalm-method Collection&\Traversable<ChildCategory> findByCatalogId(int $catalog_id) Return ChildCategory objects filtered by the catalog_id column
 * @method     ChildCategory[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildCategory> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class CategoryQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\Category\Base\CategoryQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Infrastructure\\Models\\Category\\Category', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildCategoryQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildCategoryQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildCategoryQuery) {
            return $criteria;
        }
        $query = new ChildCategoryQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildCategory|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(CategoryTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = CategoryTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildCategory A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `title`, `alias`, `full_title`, `image`, `desc`, `parent_id`, `catalog_id` FROM `shop_categories` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildCategory $obj */
            $obj = new ChildCategory();
            $obj->hydrate($row);
            CategoryTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildCategory|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(CategoryTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(CategoryTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(CategoryTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(CategoryTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CategoryTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * $query->filterByTitle(['foo', 'bar']); // WHERE title IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $title The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByTitle($title = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CategoryTableMap::COL_TITLE, $title, $comparison);

        return $this;
    }

    /**
     * Filter the query on the alias column
     *
     * Example usage:
     * <code>
     * $query->filterByAlias('fooValue');   // WHERE alias = 'fooValue'
     * $query->filterByAlias('%fooValue%', Criteria::LIKE); // WHERE alias LIKE '%fooValue%'
     * $query->filterByAlias(['foo', 'bar']); // WHERE alias IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $alias The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByAlias($alias = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($alias)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CategoryTableMap::COL_ALIAS, $alias, $comparison);

        return $this;
    }

    /**
     * Filter the query on the full_title column
     *
     * Example usage:
     * <code>
     * $query->filterByFullTitle('fooValue');   // WHERE full_title = 'fooValue'
     * $query->filterByFullTitle('%fooValue%', Criteria::LIKE); // WHERE full_title LIKE '%fooValue%'
     * $query->filterByFullTitle(['foo', 'bar']); // WHERE full_title IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $fullTitle The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByFullTitle($fullTitle = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($fullTitle)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CategoryTableMap::COL_FULL_TITLE, $fullTitle, $comparison);

        return $this;
    }

    /**
     * Filter the query on the image column
     *
     * Example usage:
     * <code>
     * $query->filterByImage('fooValue');   // WHERE image = 'fooValue'
     * $query->filterByImage('%fooValue%', Criteria::LIKE); // WHERE image LIKE '%fooValue%'
     * $query->filterByImage(['foo', 'bar']); // WHERE image IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $image The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByImage($image = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($image)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CategoryTableMap::COL_IMAGE, $image, $comparison);

        return $this;
    }

    /**
     * Filter the query on the desc column
     *
     * Example usage:
     * <code>
     * $query->filterByDesc('fooValue');   // WHERE desc = 'fooValue'
     * $query->filterByDesc('%fooValue%', Criteria::LIKE); // WHERE desc LIKE '%fooValue%'
     * $query->filterByDesc(['foo', 'bar']); // WHERE desc IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $desc The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDesc($desc = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($desc)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CategoryTableMap::COL_DESC, $desc, $comparison);

        return $this;
    }

    /**
     * Filter the query on the parent_id column
     *
     * Example usage:
     * <code>
     * $query->filterByParentId(1234); // WHERE parent_id = 1234
     * $query->filterByParentId(array(12, 34)); // WHERE parent_id IN (12, 34)
     * $query->filterByParentId(array('min' => 12)); // WHERE parent_id > 12
     * </code>
     *
     * @see       filterByParentCategory()
     *
     * @param mixed $parentId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByParentId($parentId = null, ?string $comparison = null)
    {
        if (is_array($parentId)) {
            $useMinMax = false;
            if (isset($parentId['min'])) {
                $this->addUsingAlias(CategoryTableMap::COL_PARENT_ID, $parentId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($parentId['max'])) {
                $this->addUsingAlias(CategoryTableMap::COL_PARENT_ID, $parentId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CategoryTableMap::COL_PARENT_ID, $parentId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the catalog_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCatalogId(1234); // WHERE catalog_id = 1234
     * $query->filterByCatalogId(array(12, 34)); // WHERE catalog_id IN (12, 34)
     * $query->filterByCatalogId(array('min' => 12)); // WHERE catalog_id > 12
     * </code>
     *
     * @see       filterByCatalog()
     *
     * @param mixed $catalogId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCatalogId($catalogId = null, ?string $comparison = null)
    {
        if (is_array($catalogId)) {
            $useMinMax = false;
            if (isset($catalogId['min'])) {
                $this->addUsingAlias(CategoryTableMap::COL_CATALOG_ID, $catalogId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($catalogId['max'])) {
                $this->addUsingAlias(CategoryTableMap::COL_CATALOG_ID, $catalogId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CategoryTableMap::COL_CATALOG_ID, $catalogId, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Category\Category object
     *
     * @param \Shop\Infrastructure\Models\Category\Category|ObjectCollection $category The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByParentCategory($category, ?string $comparison = null)
    {
        if ($category instanceof \Shop\Infrastructure\Models\Category\Category) {
            return $this
                ->addUsingAlias(CategoryTableMap::COL_PARENT_ID, $category->getId(), $comparison);
        } elseif ($category instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(CategoryTableMap::COL_PARENT_ID, $category->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByParentCategory() only accepts arguments of type \Shop\Infrastructure\Models\Category\Category or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ParentCategory relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinParentCategory(?string $relationAlias = null, ?string $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ParentCategory');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ParentCategory');
        }

        return $this;
    }

    /**
     * Use the ParentCategory relation Category object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Category\CategoryQuery A secondary query class using the current class as primary query
     */
    public function useParentCategoryQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinParentCategory($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ParentCategory', '\Shop\Infrastructure\Models\Category\CategoryQuery');
    }

    /**
     * Use the ParentCategory relation Category object
     *
     * @param callable(\Shop\Infrastructure\Models\Category\CategoryQuery):\Shop\Infrastructure\Models\Category\CategoryQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withParentCategoryQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::LEFT_JOIN
    ) {
        $relatedQuery = $this->useParentCategoryQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the ParentCategory relation to the Category table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Category\CategoryQuery The inner query object of the EXISTS statement
     */
    public function useParentCategoryExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('ParentCategory', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the ParentCategory relation to the Category table for a NOT EXISTS query.
     *
     * @see useParentCategoryExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Category\CategoryQuery The inner query object of the NOT EXISTS statement
     */
    public function useParentCategoryNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('ParentCategory', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Catalog\Catalog object
     *
     * @param \Shop\Infrastructure\Models\Catalog\Catalog|ObjectCollection $catalog The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCatalog($catalog, ?string $comparison = null)
    {
        if ($catalog instanceof \Shop\Infrastructure\Models\Catalog\Catalog) {
            return $this
                ->addUsingAlias(CategoryTableMap::COL_CATALOG_ID, $catalog->getId(), $comparison);
        } elseif ($catalog instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(CategoryTableMap::COL_CATALOG_ID, $catalog->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByCatalog() only accepts arguments of type \Shop\Infrastructure\Models\Catalog\Catalog or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Catalog relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinCatalog(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Catalog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Catalog');
        }

        return $this;
    }

    /**
     * Use the Catalog relation Catalog object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Catalog\CatalogQuery A secondary query class using the current class as primary query
     */
    public function useCatalogQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCatalog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Catalog', '\Shop\Infrastructure\Models\Catalog\CatalogQuery');
    }

    /**
     * Use the Catalog relation Catalog object
     *
     * @param callable(\Shop\Infrastructure\Models\Catalog\CatalogQuery):\Shop\Infrastructure\Models\Catalog\CatalogQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withCatalogQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useCatalogQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Catalog table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Catalog\CatalogQuery The inner query object of the EXISTS statement
     */
    public function useCatalogExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Catalog', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Catalog table for a NOT EXISTS query.
     *
     * @see useCatalogExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Catalog\CatalogQuery The inner query object of the NOT EXISTS statement
     */
    public function useCatalogNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Catalog', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Category\Category object
     *
     * @param \Shop\Infrastructure\Models\Category\Category|ObjectCollection $category the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCategoryRelatedById($category, ?string $comparison = null)
    {
        if ($category instanceof \Shop\Infrastructure\Models\Category\Category) {
            $this
                ->addUsingAlias(CategoryTableMap::COL_ID, $category->getParentId(), $comparison);

            return $this;
        } elseif ($category instanceof ObjectCollection) {
            $this
                ->useCategoryRelatedByIdQuery()
                ->filterByPrimaryKeys($category->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByCategoryRelatedById() only accepts arguments of type \Shop\Infrastructure\Models\Category\Category or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the CategoryRelatedById relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinCategoryRelatedById(?string $relationAlias = null, ?string $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('CategoryRelatedById');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'CategoryRelatedById');
        }

        return $this;
    }

    /**
     * Use the CategoryRelatedById relation Category object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Category\CategoryQuery A secondary query class using the current class as primary query
     */
    public function useCategoryRelatedByIdQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinCategoryRelatedById($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'CategoryRelatedById', '\Shop\Infrastructure\Models\Category\CategoryQuery');
    }

    /**
     * Use the CategoryRelatedById relation Category object
     *
     * @param callable(\Shop\Infrastructure\Models\Category\CategoryQuery):\Shop\Infrastructure\Models\Category\CategoryQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withCategoryRelatedByIdQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::LEFT_JOIN
    ) {
        $relatedQuery = $this->useCategoryRelatedByIdQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the CategoryRelatedById relation to the Category table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Category\CategoryQuery The inner query object of the EXISTS statement
     */
    public function useCategoryRelatedByIdExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('CategoryRelatedById', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the CategoryRelatedById relation to the Category table for a NOT EXISTS query.
     *
     * @see useCategoryRelatedByIdExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Category\CategoryQuery The inner query object of the NOT EXISTS statement
     */
    public function useCategoryRelatedByIdNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('CategoryRelatedById', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Product\Product object
     *
     * @param \Shop\Infrastructure\Models\Product\Product|ObjectCollection $product the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByProduct($product, ?string $comparison = null)
    {
        if ($product instanceof \Shop\Infrastructure\Models\Product\Product) {
            $this
                ->addUsingAlias(CategoryTableMap::COL_ID, $product->getCategoryId(), $comparison);

            return $this;
        } elseif ($product instanceof ObjectCollection) {
            $this
                ->useProductQuery()
                ->filterByPrimaryKeys($product->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByProduct() only accepts arguments of type \Shop\Infrastructure\Models\Product\Product or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Product relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinProduct(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Product');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Product');
        }

        return $this;
    }

    /**
     * Use the Product relation Product object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Product\ProductQuery A secondary query class using the current class as primary query
     */
    public function useProductQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProduct($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Product', '\Shop\Infrastructure\Models\Product\ProductQuery');
    }

    /**
     * Use the Product relation Product object
     *
     * @param callable(\Shop\Infrastructure\Models\Product\ProductQuery):\Shop\Infrastructure\Models\Product\ProductQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withProductQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useProductQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Product table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Product\ProductQuery The inner query object of the EXISTS statement
     */
    public function useProductExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Product', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Product table for a NOT EXISTS query.
     *
     * @see useProductExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Product\ProductQuery The inner query object of the NOT EXISTS statement
     */
    public function useProductNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Product', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel object
     *
     * @param \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel|ObjectCollection $sizeGridCategoryRel the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterBySizeGridCategoryRel($sizeGridCategoryRel, ?string $comparison = null)
    {
        if ($sizeGridCategoryRel instanceof \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel) {
            $this
                ->addUsingAlias(CategoryTableMap::COL_ID, $sizeGridCategoryRel->getCategoryId(), $comparison);

            return $this;
        } elseif ($sizeGridCategoryRel instanceof ObjectCollection) {
            $this
                ->useSizeGridCategoryRelQuery()
                ->filterByPrimaryKeys($sizeGridCategoryRel->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterBySizeGridCategoryRel() only accepts arguments of type \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the SizeGridCategoryRel relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinSizeGridCategoryRel(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('SizeGridCategoryRel');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'SizeGridCategoryRel');
        }

        return $this;
    }

    /**
     * Use the SizeGridCategoryRel relation SizeGridCategoryRel object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery A secondary query class using the current class as primary query
     */
    public function useSizeGridCategoryRelQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinSizeGridCategoryRel($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'SizeGridCategoryRel', '\Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery');
    }

    /**
     * Use the SizeGridCategoryRel relation SizeGridCategoryRel object
     *
     * @param callable(\Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery):\Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withSizeGridCategoryRelQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useSizeGridCategoryRelQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to SizeGridCategoryRel table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery The inner query object of the EXISTS statement
     */
    public function useSizeGridCategoryRelExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('SizeGridCategoryRel', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to SizeGridCategoryRel table for a NOT EXISTS query.
     *
     * @see useSizeGridCategoryRelExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery The inner query object of the NOT EXISTS statement
     */
    public function useSizeGridCategoryRelNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('SizeGridCategoryRel', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\DiscountRule\DiscountRule object
     *
     * @param \Shop\Infrastructure\Models\DiscountRule\DiscountRule|ObjectCollection $discountRule the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDiscountRule($discountRule, ?string $comparison = null)
    {
        if ($discountRule instanceof \Shop\Infrastructure\Models\DiscountRule\DiscountRule) {
            $this
                ->addUsingAlias(CategoryTableMap::COL_ID, $discountRule->getCategoryId(), $comparison);

            return $this;
        } elseif ($discountRule instanceof ObjectCollection) {
            $this
                ->useDiscountRuleQuery()
                ->filterByPrimaryKeys($discountRule->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByDiscountRule() only accepts arguments of type \Shop\Infrastructure\Models\DiscountRule\DiscountRule or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the DiscountRule relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinDiscountRule(?string $relationAlias = null, ?string $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('DiscountRule');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'DiscountRule');
        }

        return $this;
    }

    /**
     * Use the DiscountRule relation DiscountRule object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\DiscountRule\DiscountRuleQuery A secondary query class using the current class as primary query
     */
    public function useDiscountRuleQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinDiscountRule($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'DiscountRule', '\Shop\Infrastructure\Models\DiscountRule\DiscountRuleQuery');
    }

    /**
     * Use the DiscountRule relation DiscountRule object
     *
     * @param callable(\Shop\Infrastructure\Models\DiscountRule\DiscountRuleQuery):\Shop\Infrastructure\Models\DiscountRule\DiscountRuleQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withDiscountRuleQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::LEFT_JOIN
    ) {
        $relatedQuery = $this->useDiscountRuleQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to DiscountRule table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\DiscountRule\DiscountRuleQuery The inner query object of the EXISTS statement
     */
    public function useDiscountRuleExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('DiscountRule', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to DiscountRule table for a NOT EXISTS query.
     *
     * @see useDiscountRuleExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\DiscountRule\DiscountRuleQuery The inner query object of the NOT EXISTS statement
     */
    public function useDiscountRuleNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('DiscountRule', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\ImageDefault\ImageDefault object
     *
     * @param \Shop\Infrastructure\Models\ImageDefault\ImageDefault|ObjectCollection $imageDefault the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByImageDefault($imageDefault, ?string $comparison = null)
    {
        if ($imageDefault instanceof \Shop\Infrastructure\Models\ImageDefault\ImageDefault) {
            $this
                ->addUsingAlias(CategoryTableMap::COL_ID, $imageDefault->getCategoryId(), $comparison);

            return $this;
        } elseif ($imageDefault instanceof ObjectCollection) {
            $this
                ->useImageDefaultQuery()
                ->filterByPrimaryKeys($imageDefault->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByImageDefault() only accepts arguments of type \Shop\Infrastructure\Models\ImageDefault\ImageDefault or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ImageDefault relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinImageDefault(?string $relationAlias = null, ?string $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ImageDefault');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ImageDefault');
        }

        return $this;
    }

    /**
     * Use the ImageDefault relation ImageDefault object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\ImageDefault\ImageDefaultQuery A secondary query class using the current class as primary query
     */
    public function useImageDefaultQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinImageDefault($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ImageDefault', '\Shop\Infrastructure\Models\ImageDefault\ImageDefaultQuery');
    }

    /**
     * Use the ImageDefault relation ImageDefault object
     *
     * @param callable(\Shop\Infrastructure\Models\ImageDefault\ImageDefaultQuery):\Shop\Infrastructure\Models\ImageDefault\ImageDefaultQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withImageDefaultQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::LEFT_JOIN
    ) {
        $relatedQuery = $this->useImageDefaultQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to ImageDefault table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\ImageDefault\ImageDefaultQuery The inner query object of the EXISTS statement
     */
    public function useImageDefaultExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('ImageDefault', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to ImageDefault table for a NOT EXISTS query.
     *
     * @see useImageDefaultExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\ImageDefault\ImageDefaultQuery The inner query object of the NOT EXISTS statement
     */
    public function useImageDefaultNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('ImageDefault', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\DraftProduct\DraftProduct object
     *
     * @param \Shop\Infrastructure\Models\DraftProduct\DraftProduct|ObjectCollection $draftProduct the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDraftProduct($draftProduct, ?string $comparison = null)
    {
        if ($draftProduct instanceof \Shop\Infrastructure\Models\DraftProduct\DraftProduct) {
            $this
                ->addUsingAlias(CategoryTableMap::COL_ID, $draftProduct->getCategoryId(), $comparison);

            return $this;
        } elseif ($draftProduct instanceof ObjectCollection) {
            $this
                ->useDraftProductQuery()
                ->filterByPrimaryKeys($draftProduct->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByDraftProduct() only accepts arguments of type \Shop\Infrastructure\Models\DraftProduct\DraftProduct or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the DraftProduct relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinDraftProduct(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('DraftProduct');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'DraftProduct');
        }

        return $this;
    }

    /**
     * Use the DraftProduct relation DraftProduct object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\DraftProduct\DraftProductQuery A secondary query class using the current class as primary query
     */
    public function useDraftProductQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinDraftProduct($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'DraftProduct', '\Shop\Infrastructure\Models\DraftProduct\DraftProductQuery');
    }

    /**
     * Use the DraftProduct relation DraftProduct object
     *
     * @param callable(\Shop\Infrastructure\Models\DraftProduct\DraftProductQuery):\Shop\Infrastructure\Models\DraftProduct\DraftProductQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withDraftProductQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useDraftProductQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to DraftProduct table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\DraftProduct\DraftProductQuery The inner query object of the EXISTS statement
     */
    public function useDraftProductExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('DraftProduct', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to DraftProduct table for a NOT EXISTS query.
     *
     * @see useDraftProductExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\DraftProduct\DraftProductQuery The inner query object of the NOT EXISTS statement
     */
    public function useDraftProductNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('DraftProduct', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related SizeGrid object
     * using the shop_size_grid_category_rel table as cross reference
     *
     * @param SizeGrid $sizeGrid the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterBySizeGrid($sizeGrid, string $comparison = Criteria::EQUAL)
    {
        $this
            ->useSizeGridCategoryRelQuery()
            ->filterBySizeGrid($sizeGrid, $comparison)
            ->endUse();

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildCategory $category Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($category = null)
    {
        if ($category) {
            $this->addUsingAlias(CategoryTableMap::COL_ID, $category->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_categories table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CategoryTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            CategoryTableMap::clearInstancePool();
            CategoryTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CategoryTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(CategoryTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            CategoryTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            CategoryTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
