<?php


namespace Shop\Infrastructure\Repositories\Basket;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\Basket\Contracts\BasketCriteriaInterface;
use Shop\Domain\Customer\Contracts\CustomerEntityInterface;

class BasketCriteria extends AbstractCriteria implements BasketCriteriaInterface
{
    public static function create()
    {
        return new self;
    }

    /**
     * @var CustomerEntityInterface
     */
    protected $filterByCustomer;

    /**
     * @return CustomerEntityInterface
     */
    public function getFilterByCustomer(): CustomerEntityInterface
    {
        return $this->filterByCustomer;
    }

    /**
     * @param CustomerEntityInterface $filterByCustomer
     * @return BasketCriteria
     */
    public function setFilterByCustomer(CustomerEntityInterface $filterByCustomer): BasketCriteria
    {
        $this->filterByCustomer = $filterByCustomer;
        return $this;
    }






}