<?php

namespace Shop\Infrastructure\Models\Address\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Address\Address as ChildAddress;
use Shop\Infrastructure\Models\Address\AddressQuery as ChildAddressQuery;
use Shop\Infrastructure\Models\Address\Map\AddressTableMap;
use Shop\Infrastructure\Models\City\City;
use Shop\Infrastructure\Models\Shop\Shop;

/**
 * Base class that represents a query for the 'shop_addresses' table.
 *
 *
 *
 * @method     ChildAddressQuery orderByPostCode($order = Criteria::ASC) Order by the post_code column
 * @method     ChildAddressQuery orderByStreet($order = Criteria::ASC) Order by the street column
 * @method     ChildAddressQuery orderByHouse($order = Criteria::ASC) Order by the house column
 * @method     ChildAddressQuery orderByRoom($order = Criteria::ASC) Order by the room column
 * @method     ChildAddressQuery orderByCityId($order = Criteria::ASC) Order by the city_id column
 * @method     ChildAddressQuery orderByMapLng($order = Criteria::ASC) Order by the mapLng column
 * @method     ChildAddressQuery orderByMapLat($order = Criteria::ASC) Order by the mapLat column
 * @method     ChildAddressQuery orderById($order = Criteria::ASC) Order by the id column
 *
 * @method     ChildAddressQuery groupByPostCode() Group by the post_code column
 * @method     ChildAddressQuery groupByStreet() Group by the street column
 * @method     ChildAddressQuery groupByHouse() Group by the house column
 * @method     ChildAddressQuery groupByRoom() Group by the room column
 * @method     ChildAddressQuery groupByCityId() Group by the city_id column
 * @method     ChildAddressQuery groupByMapLng() Group by the mapLng column
 * @method     ChildAddressQuery groupByMapLat() Group by the mapLat column
 * @method     ChildAddressQuery groupById() Group by the id column
 *
 * @method     ChildAddressQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildAddressQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildAddressQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildAddressQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildAddressQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildAddressQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildAddressQuery leftJoinCity($relationAlias = null) Adds a LEFT JOIN clause to the query using the City relation
 * @method     ChildAddressQuery rightJoinCity($relationAlias = null) Adds a RIGHT JOIN clause to the query using the City relation
 * @method     ChildAddressQuery innerJoinCity($relationAlias = null) Adds a INNER JOIN clause to the query using the City relation
 *
 * @method     ChildAddressQuery joinWithCity($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the City relation
 *
 * @method     ChildAddressQuery leftJoinWithCity() Adds a LEFT JOIN clause and with to the query using the City relation
 * @method     ChildAddressQuery rightJoinWithCity() Adds a RIGHT JOIN clause and with to the query using the City relation
 * @method     ChildAddressQuery innerJoinWithCity() Adds a INNER JOIN clause and with to the query using the City relation
 *
 * @method     ChildAddressQuery leftJoinShop($relationAlias = null) Adds a LEFT JOIN clause to the query using the Shop relation
 * @method     ChildAddressQuery rightJoinShop($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Shop relation
 * @method     ChildAddressQuery innerJoinShop($relationAlias = null) Adds a INNER JOIN clause to the query using the Shop relation
 *
 * @method     ChildAddressQuery joinWithShop($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Shop relation
 *
 * @method     ChildAddressQuery leftJoinWithShop() Adds a LEFT JOIN clause and with to the query using the Shop relation
 * @method     ChildAddressQuery rightJoinWithShop() Adds a RIGHT JOIN clause and with to the query using the Shop relation
 * @method     ChildAddressQuery innerJoinWithShop() Adds a INNER JOIN clause and with to the query using the Shop relation
 *
 * @method     \Shop\Infrastructure\Models\City\CityQuery|\Shop\Infrastructure\Models\Shop\ShopQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildAddress|null findOne(?ConnectionInterface $con = null) Return the first ChildAddress matching the query
 * @method     ChildAddress findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildAddress matching the query, or a new ChildAddress object populated from the query conditions when no match is found
 *
 * @method     ChildAddress|null findOneByPostCode(string $post_code) Return the first ChildAddress filtered by the post_code column
 * @method     ChildAddress|null findOneByStreet(string $street) Return the first ChildAddress filtered by the street column
 * @method     ChildAddress|null findOneByHouse(string $house) Return the first ChildAddress filtered by the house column
 * @method     ChildAddress|null findOneByRoom(string $room) Return the first ChildAddress filtered by the room column
 * @method     ChildAddress|null findOneByCityId(int $city_id) Return the first ChildAddress filtered by the city_id column
 * @method     ChildAddress|null findOneByMapLng(string $mapLng) Return the first ChildAddress filtered by the mapLng column
 * @method     ChildAddress|null findOneByMapLat(string $mapLat) Return the first ChildAddress filtered by the mapLat column
 * @method     ChildAddress|null findOneById(int $id) Return the first ChildAddress filtered by the id column *

 * @method     ChildAddress requirePk($key, ?ConnectionInterface $con = null) Return the ChildAddress by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAddress requireOne(?ConnectionInterface $con = null) Return the first ChildAddress matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildAddress requireOneByPostCode(string $post_code) Return the first ChildAddress filtered by the post_code column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAddress requireOneByStreet(string $street) Return the first ChildAddress filtered by the street column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAddress requireOneByHouse(string $house) Return the first ChildAddress filtered by the house column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAddress requireOneByRoom(string $room) Return the first ChildAddress filtered by the room column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAddress requireOneByCityId(int $city_id) Return the first ChildAddress filtered by the city_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAddress requireOneByMapLng(string $mapLng) Return the first ChildAddress filtered by the mapLng column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAddress requireOneByMapLat(string $mapLat) Return the first ChildAddress filtered by the mapLat column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAddress requireOneById(int $id) Return the first ChildAddress filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildAddress[]|Collection find(?ConnectionInterface $con = null) Return ChildAddress objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildAddress> find(?ConnectionInterface $con = null) Return ChildAddress objects based on current ModelCriteria
 * @method     ChildAddress[]|Collection findByPostCode(string $post_code) Return ChildAddress objects filtered by the post_code column
 * @psalm-method Collection&\Traversable<ChildAddress> findByPostCode(string $post_code) Return ChildAddress objects filtered by the post_code column
 * @method     ChildAddress[]|Collection findByStreet(string $street) Return ChildAddress objects filtered by the street column
 * @psalm-method Collection&\Traversable<ChildAddress> findByStreet(string $street) Return ChildAddress objects filtered by the street column
 * @method     ChildAddress[]|Collection findByHouse(string $house) Return ChildAddress objects filtered by the house column
 * @psalm-method Collection&\Traversable<ChildAddress> findByHouse(string $house) Return ChildAddress objects filtered by the house column
 * @method     ChildAddress[]|Collection findByRoom(string $room) Return ChildAddress objects filtered by the room column
 * @psalm-method Collection&\Traversable<ChildAddress> findByRoom(string $room) Return ChildAddress objects filtered by the room column
 * @method     ChildAddress[]|Collection findByCityId(int $city_id) Return ChildAddress objects filtered by the city_id column
 * @psalm-method Collection&\Traversable<ChildAddress> findByCityId(int $city_id) Return ChildAddress objects filtered by the city_id column
 * @method     ChildAddress[]|Collection findByMapLng(string $mapLng) Return ChildAddress objects filtered by the mapLng column
 * @psalm-method Collection&\Traversable<ChildAddress> findByMapLng(string $mapLng) Return ChildAddress objects filtered by the mapLng column
 * @method     ChildAddress[]|Collection findByMapLat(string $mapLat) Return ChildAddress objects filtered by the mapLat column
 * @psalm-method Collection&\Traversable<ChildAddress> findByMapLat(string $mapLat) Return ChildAddress objects filtered by the mapLat column
 * @method     ChildAddress[]|Collection findById(int $id) Return ChildAddress objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildAddress> findById(int $id) Return ChildAddress objects filtered by the id column
 * @method     ChildAddress[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildAddress> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class AddressQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\Address\Base\AddressQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Infrastructure\\Models\\Address\\Address', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildAddressQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildAddressQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildAddressQuery) {
            return $criteria;
        }
        $query = new ChildAddressQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildAddress|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(AddressTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = AddressTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildAddress A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `post_code`, `street`, `house`, `room`, `city_id`, `mapLng`, `mapLat`, `id` FROM `shop_addresses` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildAddress $obj */
            $obj = new ChildAddress();
            $obj->hydrate($row);
            AddressTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildAddress|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(AddressTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(AddressTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the post_code column
     *
     * Example usage:
     * <code>
     * $query->filterByPostCode('fooValue');   // WHERE post_code = 'fooValue'
     * $query->filterByPostCode('%fooValue%', Criteria::LIKE); // WHERE post_code LIKE '%fooValue%'
     * $query->filterByPostCode(['foo', 'bar']); // WHERE post_code IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $postCode The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPostCode($postCode = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($postCode)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AddressTableMap::COL_POST_CODE, $postCode, $comparison);

        return $this;
    }

    /**
     * Filter the query on the street column
     *
     * Example usage:
     * <code>
     * $query->filterByStreet('fooValue');   // WHERE street = 'fooValue'
     * $query->filterByStreet('%fooValue%', Criteria::LIKE); // WHERE street LIKE '%fooValue%'
     * $query->filterByStreet(['foo', 'bar']); // WHERE street IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $street The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByStreet($street = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($street)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AddressTableMap::COL_STREET, $street, $comparison);

        return $this;
    }

    /**
     * Filter the query on the house column
     *
     * Example usage:
     * <code>
     * $query->filterByHouse('fooValue');   // WHERE house = 'fooValue'
     * $query->filterByHouse('%fooValue%', Criteria::LIKE); // WHERE house LIKE '%fooValue%'
     * $query->filterByHouse(['foo', 'bar']); // WHERE house IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $house The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByHouse($house = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($house)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AddressTableMap::COL_HOUSE, $house, $comparison);

        return $this;
    }

    /**
     * Filter the query on the room column
     *
     * Example usage:
     * <code>
     * $query->filterByRoom('fooValue');   // WHERE room = 'fooValue'
     * $query->filterByRoom('%fooValue%', Criteria::LIKE); // WHERE room LIKE '%fooValue%'
     * $query->filterByRoom(['foo', 'bar']); // WHERE room IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $room The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByRoom($room = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($room)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AddressTableMap::COL_ROOM, $room, $comparison);

        return $this;
    }

    /**
     * Filter the query on the city_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCityId(1234); // WHERE city_id = 1234
     * $query->filterByCityId(array(12, 34)); // WHERE city_id IN (12, 34)
     * $query->filterByCityId(array('min' => 12)); // WHERE city_id > 12
     * </code>
     *
     * @see       filterByCity()
     *
     * @param mixed $cityId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCityId($cityId = null, ?string $comparison = null)
    {
        if (is_array($cityId)) {
            $useMinMax = false;
            if (isset($cityId['min'])) {
                $this->addUsingAlias(AddressTableMap::COL_CITY_ID, $cityId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($cityId['max'])) {
                $this->addUsingAlias(AddressTableMap::COL_CITY_ID, $cityId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AddressTableMap::COL_CITY_ID, $cityId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the mapLng column
     *
     * Example usage:
     * <code>
     * $query->filterByMapLng('fooValue');   // WHERE mapLng = 'fooValue'
     * $query->filterByMapLng('%fooValue%', Criteria::LIKE); // WHERE mapLng LIKE '%fooValue%'
     * $query->filterByMapLng(['foo', 'bar']); // WHERE mapLng IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $mapLng The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMapLng($mapLng = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mapLng)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AddressTableMap::COL_MAPLNG, $mapLng, $comparison);

        return $this;
    }

    /**
     * Filter the query on the mapLat column
     *
     * Example usage:
     * <code>
     * $query->filterByMapLat('fooValue');   // WHERE mapLat = 'fooValue'
     * $query->filterByMapLat('%fooValue%', Criteria::LIKE); // WHERE mapLat LIKE '%fooValue%'
     * $query->filterByMapLat(['foo', 'bar']); // WHERE mapLat IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $mapLat The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMapLat($mapLat = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mapLat)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AddressTableMap::COL_MAPLAT, $mapLat, $comparison);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @see       filterByShop()
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(AddressTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(AddressTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AddressTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\City\City object
     *
     * @param \Shop\Infrastructure\Models\City\City|ObjectCollection $city The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCity($city, ?string $comparison = null)
    {
        if ($city instanceof \Shop\Infrastructure\Models\City\City) {
            return $this
                ->addUsingAlias(AddressTableMap::COL_CITY_ID, $city->getId(), $comparison);
        } elseif ($city instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(AddressTableMap::COL_CITY_ID, $city->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByCity() only accepts arguments of type \Shop\Infrastructure\Models\City\City or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the City relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinCity(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('City');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'City');
        }

        return $this;
    }

    /**
     * Use the City relation City object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\City\CityQuery A secondary query class using the current class as primary query
     */
    public function useCityQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCity($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'City', '\Shop\Infrastructure\Models\City\CityQuery');
    }

    /**
     * Use the City relation City object
     *
     * @param callable(\Shop\Infrastructure\Models\City\CityQuery):\Shop\Infrastructure\Models\City\CityQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withCityQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useCityQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to City table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\City\CityQuery The inner query object of the EXISTS statement
     */
    public function useCityExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('City', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to City table for a NOT EXISTS query.
     *
     * @see useCityExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\City\CityQuery The inner query object of the NOT EXISTS statement
     */
    public function useCityNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('City', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Shop\Shop object
     *
     * @param \Shop\Infrastructure\Models\Shop\Shop|ObjectCollection $shop The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByShop($shop, ?string $comparison = null)
    {
        if ($shop instanceof \Shop\Infrastructure\Models\Shop\Shop) {
            return $this
                ->addUsingAlias(AddressTableMap::COL_ID, $shop->getId(), $comparison);
        } elseif ($shop instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(AddressTableMap::COL_ID, $shop->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByShop() only accepts arguments of type \Shop\Infrastructure\Models\Shop\Shop or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Shop relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinShop(?string $relationAlias = null, ?string $joinType = 'LEFT JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Shop');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Shop');
        }

        return $this;
    }

    /**
     * Use the Shop relation Shop object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Shop\ShopQuery A secondary query class using the current class as primary query
     */
    public function useShopQuery($relationAlias = null, $joinType = 'LEFT JOIN')
    {
        return $this
            ->joinShop($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Shop', '\Shop\Infrastructure\Models\Shop\ShopQuery');
    }

    /**
     * Use the Shop relation Shop object
     *
     * @param callable(\Shop\Infrastructure\Models\Shop\ShopQuery):\Shop\Infrastructure\Models\Shop\ShopQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withShopQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = 'LEFT JOIN'
    ) {
        $relatedQuery = $this->useShopQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Shop table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Shop\ShopQuery The inner query object of the EXISTS statement
     */
    public function useShopExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Shop', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Shop table for a NOT EXISTS query.
     *
     * @see useShopExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Shop\ShopQuery The inner query object of the NOT EXISTS statement
     */
    public function useShopNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Shop', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Exclude object from result
     *
     * @param ChildAddress $address Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($address = null)
    {
        if ($address) {
            $this->addUsingAlias(AddressTableMap::COL_ID, $address->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_addresses table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(AddressTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            AddressTableMap::clearInstancePool();
            AddressTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(AddressTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(AddressTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            AddressTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            AddressTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
