<?php

namespace Shop\Domain\ProductGroup;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\ProductGroup\Contracts\ProductGroupEntityInterface;

/**
* Description of ProductGroups
*
* @author Diamond Code Generator
*/
class ProductGroupCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return ProductGroupEntityInterface::class;
    }

    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getName();
        }

        return $ar;
    }
}               