<?php

namespace Shop\Infrastructure\Models\Order\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Order\Order;
use Shop\Infrastructure\Models\Order\OrderQuery;
use Shop\Infrastructure\Models\OrderItem\Map\OrderItemTableMap;
use Shop\Infrastructure\Models\OrderSign\Map\OrderSignTableMap;


/**
 * This class defines the structure of the 'shop_orders' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class OrderTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.Order.Map.OrderTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_orders';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\Order\\Order';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.Order.Order';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 14;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 14;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_orders.id';

    /**
     * the column name for the type_id field
     */
    public const COL_TYPE_ID = 'shop_orders.type_id';

    /**
     * the column name for the customer_id field
     */
    public const COL_CUSTOMER_ID = 'shop_orders.customer_id';

    /**
     * the column name for the contractor_id field
     */
    public const COL_CONTRACTOR_ID = 'shop_orders.contractor_id';

    /**
     * the column name for the datetime field
     */
    public const COL_DATETIME = 'shop_orders.datetime';

    /**
     * the column name for the udatetime field
     */
    public const COL_UDATETIME = 'shop_orders.udatetime';

    /**
     * the column name for the discount_summ field
     */
    public const COL_DISCOUNT_SUMM = 'shop_orders.discount_summ';

    /**
     * the column name for the reload field
     */
    public const COL_RELOAD = 'shop_orders.reload';

    /**
     * the column name for the delivery_address field
     */
    public const COL_DELIVERY_ADDRESS = 'shop_orders.delivery_address';

    /**
     * the column name for the payment_id field
     */
    public const COL_PAYMENT_ID = 'shop_orders.payment_id';

    /**
     * the column name for the state_id field
     */
    public const COL_STATE_ID = 'shop_orders.state_id';

    /**
     * the column name for the comment field
     */
    public const COL_COMMENT = 'shop_orders.comment';

    /**
     * the column name for the post_code field
     */
    public const COL_POST_CODE = 'shop_orders.post_code';

    /**
     * the column name for the shop_id field
     */
    public const COL_SHOP_ID = 'shop_orders.shop_id';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'TypeId', 'CustomerId', 'ContractorId', 'Datetime', 'UDatetime', 'DiscountSumm', 'Reload', 'DeliveryAddress', 'PaymentId', 'StateId', 'Comment', 'PostCode', 'ShopId', ],
        self::TYPE_CAMELNAME     => ['id', 'typeId', 'customerId', 'contractorId', 'datetime', 'uDatetime', 'discountSumm', 'reload', 'deliveryAddress', 'paymentId', 'stateId', 'comment', 'postCode', 'shopId', ],
        self::TYPE_COLNAME       => [OrderTableMap::COL_ID, OrderTableMap::COL_TYPE_ID, OrderTableMap::COL_CUSTOMER_ID, OrderTableMap::COL_CONTRACTOR_ID, OrderTableMap::COL_DATETIME, OrderTableMap::COL_UDATETIME, OrderTableMap::COL_DISCOUNT_SUMM, OrderTableMap::COL_RELOAD, OrderTableMap::COL_DELIVERY_ADDRESS, OrderTableMap::COL_PAYMENT_ID, OrderTableMap::COL_STATE_ID, OrderTableMap::COL_COMMENT, OrderTableMap::COL_POST_CODE, OrderTableMap::COL_SHOP_ID, ],
        self::TYPE_FIELDNAME     => ['id', 'type_id', 'customer_id', 'contractor_id', 'datetime', 'udatetime', 'discount_summ', 'reload', 'delivery_address', 'payment_id', 'state_id', 'comment', 'post_code', 'shop_id', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'TypeId' => 1, 'CustomerId' => 2, 'ContractorId' => 3, 'Datetime' => 4, 'UDatetime' => 5, 'DiscountSumm' => 6, 'Reload' => 7, 'DeliveryAddress' => 8, 'PaymentId' => 9, 'StateId' => 10, 'Comment' => 11, 'PostCode' => 12, 'ShopId' => 13, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'typeId' => 1, 'customerId' => 2, 'contractorId' => 3, 'datetime' => 4, 'uDatetime' => 5, 'discountSumm' => 6, 'reload' => 7, 'deliveryAddress' => 8, 'paymentId' => 9, 'stateId' => 10, 'comment' => 11, 'postCode' => 12, 'shopId' => 13, ],
        self::TYPE_COLNAME       => [OrderTableMap::COL_ID => 0, OrderTableMap::COL_TYPE_ID => 1, OrderTableMap::COL_CUSTOMER_ID => 2, OrderTableMap::COL_CONTRACTOR_ID => 3, OrderTableMap::COL_DATETIME => 4, OrderTableMap::COL_UDATETIME => 5, OrderTableMap::COL_DISCOUNT_SUMM => 6, OrderTableMap::COL_RELOAD => 7, OrderTableMap::COL_DELIVERY_ADDRESS => 8, OrderTableMap::COL_PAYMENT_ID => 9, OrderTableMap::COL_STATE_ID => 10, OrderTableMap::COL_COMMENT => 11, OrderTableMap::COL_POST_CODE => 12, OrderTableMap::COL_SHOP_ID => 13, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'type_id' => 1, 'customer_id' => 2, 'contractor_id' => 3, 'datetime' => 4, 'udatetime' => 5, 'discount_summ' => 6, 'reload' => 7, 'delivery_address' => 8, 'payment_id' => 9, 'state_id' => 10, 'comment' => 11, 'post_code' => 12, 'shop_id' => 13, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'Order.Id' => 'ID',
        'id' => 'ID',
        'order.id' => 'ID',
        'OrderTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_orders.id' => 'ID',
        'TypeId' => 'TYPE_ID',
        'Order.TypeId' => 'TYPE_ID',
        'typeId' => 'TYPE_ID',
        'order.typeId' => 'TYPE_ID',
        'OrderTableMap::COL_TYPE_ID' => 'TYPE_ID',
        'COL_TYPE_ID' => 'TYPE_ID',
        'type_id' => 'TYPE_ID',
        'shop_orders.type_id' => 'TYPE_ID',
        'CustomerId' => 'CUSTOMER_ID',
        'Order.CustomerId' => 'CUSTOMER_ID',
        'customerId' => 'CUSTOMER_ID',
        'order.customerId' => 'CUSTOMER_ID',
        'OrderTableMap::COL_CUSTOMER_ID' => 'CUSTOMER_ID',
        'COL_CUSTOMER_ID' => 'CUSTOMER_ID',
        'customer_id' => 'CUSTOMER_ID',
        'shop_orders.customer_id' => 'CUSTOMER_ID',
        'ContractorId' => 'CONTRACTOR_ID',
        'Order.ContractorId' => 'CONTRACTOR_ID',
        'contractorId' => 'CONTRACTOR_ID',
        'order.contractorId' => 'CONTRACTOR_ID',
        'OrderTableMap::COL_CONTRACTOR_ID' => 'CONTRACTOR_ID',
        'COL_CONTRACTOR_ID' => 'CONTRACTOR_ID',
        'contractor_id' => 'CONTRACTOR_ID',
        'shop_orders.contractor_id' => 'CONTRACTOR_ID',
        'Datetime' => 'DATETIME',
        'Order.Datetime' => 'DATETIME',
        'datetime' => 'DATETIME',
        'order.datetime' => 'DATETIME',
        'OrderTableMap::COL_DATETIME' => 'DATETIME',
        'COL_DATETIME' => 'DATETIME',
        'shop_orders.datetime' => 'DATETIME',
        'UDatetime' => 'UDATETIME',
        'Order.UDatetime' => 'UDATETIME',
        'uDatetime' => 'UDATETIME',
        'order.uDatetime' => 'UDATETIME',
        'OrderTableMap::COL_UDATETIME' => 'UDATETIME',
        'COL_UDATETIME' => 'UDATETIME',
        'udatetime' => 'UDATETIME',
        'shop_orders.udatetime' => 'UDATETIME',
        'DiscountSumm' => 'DISCOUNT_SUMM',
        'Order.DiscountSumm' => 'DISCOUNT_SUMM',
        'discountSumm' => 'DISCOUNT_SUMM',
        'order.discountSumm' => 'DISCOUNT_SUMM',
        'OrderTableMap::COL_DISCOUNT_SUMM' => 'DISCOUNT_SUMM',
        'COL_DISCOUNT_SUMM' => 'DISCOUNT_SUMM',
        'discount_summ' => 'DISCOUNT_SUMM',
        'shop_orders.discount_summ' => 'DISCOUNT_SUMM',
        'Reload' => 'RELOAD',
        'Order.Reload' => 'RELOAD',
        'reload' => 'RELOAD',
        'order.reload' => 'RELOAD',
        'OrderTableMap::COL_RELOAD' => 'RELOAD',
        'COL_RELOAD' => 'RELOAD',
        'shop_orders.reload' => 'RELOAD',
        'DeliveryAddress' => 'DELIVERY_ADDRESS',
        'Order.DeliveryAddress' => 'DELIVERY_ADDRESS',
        'deliveryAddress' => 'DELIVERY_ADDRESS',
        'order.deliveryAddress' => 'DELIVERY_ADDRESS',
        'OrderTableMap::COL_DELIVERY_ADDRESS' => 'DELIVERY_ADDRESS',
        'COL_DELIVERY_ADDRESS' => 'DELIVERY_ADDRESS',
        'delivery_address' => 'DELIVERY_ADDRESS',
        'shop_orders.delivery_address' => 'DELIVERY_ADDRESS',
        'PaymentId' => 'PAYMENT_ID',
        'Order.PaymentId' => 'PAYMENT_ID',
        'paymentId' => 'PAYMENT_ID',
        'order.paymentId' => 'PAYMENT_ID',
        'OrderTableMap::COL_PAYMENT_ID' => 'PAYMENT_ID',
        'COL_PAYMENT_ID' => 'PAYMENT_ID',
        'payment_id' => 'PAYMENT_ID',
        'shop_orders.payment_id' => 'PAYMENT_ID',
        'StateId' => 'STATE_ID',
        'Order.StateId' => 'STATE_ID',
        'stateId' => 'STATE_ID',
        'order.stateId' => 'STATE_ID',
        'OrderTableMap::COL_STATE_ID' => 'STATE_ID',
        'COL_STATE_ID' => 'STATE_ID',
        'state_id' => 'STATE_ID',
        'shop_orders.state_id' => 'STATE_ID',
        'Comment' => 'COMMENT',
        'Order.Comment' => 'COMMENT',
        'comment' => 'COMMENT',
        'order.comment' => 'COMMENT',
        'OrderTableMap::COL_COMMENT' => 'COMMENT',
        'COL_COMMENT' => 'COMMENT',
        'shop_orders.comment' => 'COMMENT',
        'PostCode' => 'POST_CODE',
        'Order.PostCode' => 'POST_CODE',
        'postCode' => 'POST_CODE',
        'order.postCode' => 'POST_CODE',
        'OrderTableMap::COL_POST_CODE' => 'POST_CODE',
        'COL_POST_CODE' => 'POST_CODE',
        'post_code' => 'POST_CODE',
        'shop_orders.post_code' => 'POST_CODE',
        'ShopId' => 'SHOP_ID',
        'Order.ShopId' => 'SHOP_ID',
        'shopId' => 'SHOP_ID',
        'order.shopId' => 'SHOP_ID',
        'OrderTableMap::COL_SHOP_ID' => 'SHOP_ID',
        'COL_SHOP_ID' => 'SHOP_ID',
        'shop_id' => 'SHOP_ID',
        'shop_orders.shop_id' => 'SHOP_ID',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_orders');
        $this->setPhpName('Order');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\Order\\Order');
        $this->setPackage('Shop.Infrastructure.Models.Order');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addForeignKey('type_id', 'TypeId', 'INTEGER', 'shop_order_types', 'id', true, null, 1);
        $this->addForeignKey('customer_id', 'CustomerId', 'INTEGER', 'shop_customer', 'id', true, null, null);
        $this->addForeignKey('contractor_id', 'ContractorId', 'INTEGER', 'shop_customer', 'id', true, null, null);
        $this->addColumn('datetime', 'Datetime', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('udatetime', 'UDatetime', 'TIMESTAMP', false, null, null);
        $this->addColumn('discount_summ', 'DiscountSumm', 'DECIMAL', false, 19, 0.00);
        $this->addColumn('reload', 'Reload', 'CHAR', true, null, 'N');
        $this->addColumn('delivery_address', 'DeliveryAddress', 'LONGVARCHAR', false, null, null);
        $this->addForeignKey('payment_id', 'PaymentId', 'INTEGER', 'shop_payments', 'id', true, null, null);
        $this->addForeignKey('state_id', 'StateId', 'INTEGER', 'shop_states', 'id', true, null, null);
        $this->addColumn('comment', 'Comment', 'LONGVARCHAR', false, null, null);
        $this->addColumn('post_code', 'PostCode', 'VARCHAR', false, 100, null);
        $this->addColumn('shop_id', 'ShopId', 'INTEGER', false, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('Type', '\\Shop\\Infrastructure\\Models\\OrderType\\OrderType', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':type_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Customer', '\\Shop\\Infrastructure\\Models\\Customer\\Customer', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':customer_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Contractor', '\\Shop\\Infrastructure\\Models\\Customer\\Customer', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':contractor_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Payment', '\\Shop\\Infrastructure\\Models\\Payment\\Payment', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':payment_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('State', '\\Shop\\Infrastructure\\Models\\State\\State', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':state_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('PaymentTransaction', '\\Shop\\Infrastructure\\Models\\PaymentTransaction\\PaymentTransaction', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':order_id',
    1 => ':id',
  ),
), null, null, 'PaymentTransactions', false);
        $this->addRelation('OrderItem', '\\Shop\\Infrastructure\\Models\\OrderItem\\OrderItem', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':order_id',
    1 => ':id',
  ),
), 'CASCADE', null, 'OrderItems', false);
        $this->addRelation('SyncLog', '\\Shop\\Infrastructure\\Models\\SyncLog\\SyncLog', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':order_id',
    1 => ':id',
  ),
), null, null, 'SyncLogs', false);
        $this->addRelation('OrderSign', '\\Shop\\Infrastructure\\Models\\OrderSign\\OrderSign', RelationMap::ONE_TO_ONE, array (
  0 =>
  array (
    0 => ':id',
    1 => ':id',
  ),
), 'CASCADE', null, null, false);
    }

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array<string, array> Associative array (name => parameters) of behaviors
     */
    public function getBehaviors(): array
    {
        return [
            'delegate' => ['to' => 'shop_order_signs'],
            'archivable' => ['archive_table' => '', 'archive_phpname' => NULL, 'archive_class' => '', 'log_archived_at' => 'true', 'archived_at_column' => 'archived_at', 'archive_on_insert' => 'false', 'archive_on_update' => 'false', 'archive_on_delete' => 'true'],
        ];
    }

    /**
     * Method to invalidate the instance pool of all tables related to shop_orders     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool(): void
    {
        // Invalidate objects in related instance pools,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        OrderItemTableMap::clearInstancePool();
        OrderSignTableMap::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? OrderTableMap::CLASS_DEFAULT : OrderTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (Order object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = OrderTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = OrderTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + OrderTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = OrderTableMap::OM_CLASS;
            /** @var Order $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            OrderTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = OrderTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = OrderTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Order $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                OrderTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(OrderTableMap::COL_ID);
            $criteria->addSelectColumn(OrderTableMap::COL_TYPE_ID);
            $criteria->addSelectColumn(OrderTableMap::COL_CUSTOMER_ID);
            $criteria->addSelectColumn(OrderTableMap::COL_CONTRACTOR_ID);
            $criteria->addSelectColumn(OrderTableMap::COL_DATETIME);
            $criteria->addSelectColumn(OrderTableMap::COL_UDATETIME);
            $criteria->addSelectColumn(OrderTableMap::COL_DISCOUNT_SUMM);
            $criteria->addSelectColumn(OrderTableMap::COL_RELOAD);
            $criteria->addSelectColumn(OrderTableMap::COL_DELIVERY_ADDRESS);
            $criteria->addSelectColumn(OrderTableMap::COL_PAYMENT_ID);
            $criteria->addSelectColumn(OrderTableMap::COL_STATE_ID);
            $criteria->addSelectColumn(OrderTableMap::COL_COMMENT);
            $criteria->addSelectColumn(OrderTableMap::COL_POST_CODE);
            $criteria->addSelectColumn(OrderTableMap::COL_SHOP_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.type_id');
            $criteria->addSelectColumn($alias . '.customer_id');
            $criteria->addSelectColumn($alias . '.contractor_id');
            $criteria->addSelectColumn($alias . '.datetime');
            $criteria->addSelectColumn($alias . '.udatetime');
            $criteria->addSelectColumn($alias . '.discount_summ');
            $criteria->addSelectColumn($alias . '.reload');
            $criteria->addSelectColumn($alias . '.delivery_address');
            $criteria->addSelectColumn($alias . '.payment_id');
            $criteria->addSelectColumn($alias . '.state_id');
            $criteria->addSelectColumn($alias . '.comment');
            $criteria->addSelectColumn($alias . '.post_code');
            $criteria->addSelectColumn($alias . '.shop_id');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(OrderTableMap::COL_ID);
            $criteria->removeSelectColumn(OrderTableMap::COL_TYPE_ID);
            $criteria->removeSelectColumn(OrderTableMap::COL_CUSTOMER_ID);
            $criteria->removeSelectColumn(OrderTableMap::COL_CONTRACTOR_ID);
            $criteria->removeSelectColumn(OrderTableMap::COL_DATETIME);
            $criteria->removeSelectColumn(OrderTableMap::COL_UDATETIME);
            $criteria->removeSelectColumn(OrderTableMap::COL_DISCOUNT_SUMM);
            $criteria->removeSelectColumn(OrderTableMap::COL_RELOAD);
            $criteria->removeSelectColumn(OrderTableMap::COL_DELIVERY_ADDRESS);
            $criteria->removeSelectColumn(OrderTableMap::COL_PAYMENT_ID);
            $criteria->removeSelectColumn(OrderTableMap::COL_STATE_ID);
            $criteria->removeSelectColumn(OrderTableMap::COL_COMMENT);
            $criteria->removeSelectColumn(OrderTableMap::COL_POST_CODE);
            $criteria->removeSelectColumn(OrderTableMap::COL_SHOP_ID);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.type_id');
            $criteria->removeSelectColumn($alias . '.customer_id');
            $criteria->removeSelectColumn($alias . '.contractor_id');
            $criteria->removeSelectColumn($alias . '.datetime');
            $criteria->removeSelectColumn($alias . '.udatetime');
            $criteria->removeSelectColumn($alias . '.discount_summ');
            $criteria->removeSelectColumn($alias . '.reload');
            $criteria->removeSelectColumn($alias . '.delivery_address');
            $criteria->removeSelectColumn($alias . '.payment_id');
            $criteria->removeSelectColumn($alias . '.state_id');
            $criteria->removeSelectColumn($alias . '.comment');
            $criteria->removeSelectColumn($alias . '.post_code');
            $criteria->removeSelectColumn($alias . '.shop_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(OrderTableMap::DATABASE_NAME)->getTable(OrderTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a Order or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or Order object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\Order\Order) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(OrderTableMap::DATABASE_NAME);
            $criteria->add(OrderTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = OrderQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            OrderTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                OrderTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_orders table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return OrderQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Order or Criteria object.
     *
     * @param mixed $criteria Criteria or Order object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Order object
        }

        if ($criteria->containsKey(OrderTableMap::COL_ID) && $criteria->keyContainsValue(OrderTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.OrderTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = OrderQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
