<?php


namespace Shop\Infrastructure\Repositories\SizeGrid;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\SizeGrid\SizeGridCollection;
use Shop\Infrastructure\Models\SizeGrid\SizeGrid;
use Shop\Infrastructure\Models\SizeGrid\SizeGridQuery;

class SizeGridRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new SizeGrid();
    }

    protected function createQuery(): ModelCriteria
    {
        return SizeGridQuery::create();
    }

    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        
    }
    
    protected function createCollection(): CollectionInterface
    {
        return new SizeGridCollection();
    }

    /**
     * @param array $categoryIds
     * @param int $sizeGridId
     * @return bool
     */
    public function addRelationCategories(array $categoryIds, int $sizeGridId): void
    {

        $grid = $this->createQuery()->findPk($sizeGridId);

        $categories = \Shop\Infrastructure\Models\Category\CategoryQuery::create()->filterByPrimaryKeys($categoryIds)->find();

        $grid->setCategories($categories);

        $grid->save();
    }
}