<?php


namespace Shop\Infrastructure\Repositories\ImageDefault;


use Shop\Domain\ImageDefault\Contracts\ImageDefaultCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class ImageDefaultCriteria extends AbstractCriteria implements ImageDefaultCriteriaInterface
{

    /**
     * @var int|null
     */
    protected $filterByBrandId;

    /**
     * @var int|null
     */
    protected $filterByCategoryId;

    /**
     * @return int|null
     */
    public function getFilterByBrandId(): ?int
    {
        return $this->filterByBrandId;
    }

    /**
     * @param int|null $filterByBrandId
     * @return ImageDefaultCriteria
     */
    public function setFilterByBrandId(?int $filterByBrandId): ImageDefaultCriteria
    {
        $this->filterByBrandId = $filterByBrandId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByCategoryId(): ?int
    {
        return $this->filterByCategoryId;
    }

    /**
     * @param int|null $filterByCategoryId
     * @return ImageDefaultCriteria
     */
    public function setFilterByCategoryId(?int $filterByCategoryId): ImageDefaultCriteria
    {
        $this->filterByCategoryId = $filterByCategoryId;
        return $this;
    }


    public static function create()
    {
        return new self;
    }

}