<?php

namespace Shop\Infrastructure\Repositories\Product;

use Repo\Concrete\AbstractCriteria;
use Shop\Domain\Product\Contracts\ProductCriteriaInterface;
/**
 * Description of ProductCriteria
 *
 * @author Admin
 */
class ProductCriteria extends AbstractCriteria implements ProductCriteriaInterface
{
    /**
     * @var array|null
     */
    protected $filterByGroupIds;

    /**
     * @var array|null
     */
    protected $filterByBrandIds;

    /**
     * @var string|null
     */
    protected $filterByName;

    /**
     * @var string|null
     */
    protected $searchByBrand;

    /**
     * @var string|null
     */
    protected $searchByArticle;

    /**
     * @var array| null
     */
    protected $filterByBrandNames;

    /**
     *
     * @var bool|null
     */
    protected $filterByNewGoodDays;

    /**
     *
     * @var int|null
     */
    protected $newGoodDays;


    /**
     *
     * @var string|null
     */
    protected $sortedByDateCreate;


    /**
     *
     * @var string|null
     */
    protected $sortedByDateUpdate;

    /**
     * @var string|null
     */
    protected $sortedByPrice;

    /**
     *
     * @var string|null
     */
    protected $searchByTitle;


    /**
     *
     * @var \DateTime
     */
    protected $filterByDateCreate;


    /**
     * @var \DateTime
     */
    protected $filterByDateUpdate;

    /**
     *
     * @var bool|null
     */
    protected $sortedRandom;


    /**
     *
     * @var bool|null
     */
    protected $filterByRemains;


    /**
     *
     * @var bool|null
     */
    protected $filterByPopular;


    /**
     * @var bool|null
     */
    protected $filterByImageExist;


    /**
     *
     * @var int|null
     */
    protected $filterByCategoryId;

    /**
     *
     * @var int|null
     */
    protected $filterByBrandId;


    /**
     * @var array
     */
    protected $filterByPriceListScheetIds;

    /**
     * @var bool|null
     */
    protected $filterBySpecial;

    /**
     * @var bool|null
     */
    protected $filterByActive;

    /**
     * @var array|null
     */
    protected $filterByweights;

    /**
     * @var float|null
     */
    protected $filterByWeight;

    /**
     * @var array|null
     */
    protected $filterByIgnoreCategories;

    /**
     * @var array|null
     */
    protected $filterBySizeTypeIds;
    /**
     * @var array|null
     */
    protected $filterByDestinations;

    /**
     * @var array|null
     */
    protected $filterBySizeValues;

    /**
     * @var string|null
     */
    protected $sortByHitSale;

    /**
     * @var array|null
     */
    protected $sortByBrandsPriority;

    /**
     * @return array|null
     */
    public function getSortByBrandsPriority(): ?array
    {
        return $this->sortByBrandsPriority;
    }

    /**
     * @param array|null $sortByBrandsPriority
     * @return ProductCriteria
     */
    public function setSortByBrandsPriority(?array $sortByBrandsPriority): ProductCriteria
    {
        $this->sortByBrandsPriority = $sortByBrandsPriority;
        return $this;
    }
    

    /**
     * @return float|null
     */
    public function getFilterByWeight(): ?float
    {
        return $this->filterByWeight;
    }

    /**
     * @param float|null $filterByWeight
     * @return ProductCriteria
     */
    public function setFilterByWeight(?float $filterByWeight): ProductCriteria
    {
        $this->filterByWeight = $filterByWeight;
        return $this;
    }
    
    
    /**
     * @return string|null
     */
    public function getSortByHitSale(): ?string
    {
        return $this->sortByHitSale;
    }

    /**
     * @param string|null $sortByHitSale
     * @return ProductCriteria
     */
    public function setSortByHitSale(?string $sortByHitSale): ProductCriteria
    {
        $this->sortByHitSale = $sortByHitSale;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterByDestinations(): ?array
    {
        return $this->filterByDestinations;
    }

    /**
     * @var float|null
     */
    protected $filterByPriceMin;

    /**
     * @var float|null
     */
    protected $filterByPriceMax;

    /**
     * @var int|null
     */
    protected $filterBySaleId;

    /**
     * @var array|null
     */
    protected $filterByCategoryIds;

    /**
     * @var array|null
     */
    protected $filterByCategoryParentIds;

    /**
     * @var array|null
     */
    protected $setFilterByStockIds;

    /**
     * @var string|null
     */
    protected $sortByTitle;

    /**
     * @return string|null
     */
    public function getSortByTitle(): ?string
    {
        return $this->sortByTitle;
    }

    /**
     * @param string|null $sortByTitle
     * @return ProductCriteria
     */
    public function setSortByTitle(?string $sortByTitle): ProductCriteria
    {
        $this->sortByTitle = $sortByTitle;
        return $this;
    }


    /**
     * @param array|null $filterByDestinations
     * @return ProductCriteria
     */
    public function setFilterByDestinations(?array $filterByDestinations): ProductCriteria
    {
        $this->filterByDestinations = $filterByDestinations;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getSetFilterByStockIds(): ?array
    {
        return $this->setFilterByStockIds;
    }

    /**
     * @param array|null $setFilterByStockIds
     * @return ProductCriteria
     */
    public function setSetFilterByStockIds(?array $setFilterByStockIds): ProductCriteria
    {
        $this->setFilterByStockIds = $setFilterByStockIds;
        return $this;
    }



    /**
     * @return array|null
     */
    public function getFilterByCategoryParentIds(): ?array
    {
        return $this->filterByCategoryParentIds;
    }

    /**
     * @param array|null $filterByCategoryParentIds
     * @return ProductCriteria
     */
    public function setFilterByCategoryParentIds(?array $filterByCategoryParentIds): ProductCriteria
    {
        $this->filterByCategoryParentIds = $filterByCategoryParentIds;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterByCategoryIds(): ?array
    {
        return $this->filterByCategoryIds;
    }

    /**
     * @param array|null $filterByCategoryIds
     * @return ProductCriteria
     */
    public function setFilterByCategoryIds(?array $filterByCategoryIds): ProductCriteria
    {
        $this->filterByCategoryIds = $filterByCategoryIds;
        return $this;
    }


    /**
     * @return int|null
     */
    public function getFilterBySaleId(): ?int
    {
        return $this->filterBySaleId;
    }

    /**
     * @param int|null $filterBySaleId
     * @return ProductCriteria
     */
    public function setFilterBySaleId(?int $filterBySaleId): ProductCriteria
    {
        $this->filterBySaleId = $filterBySaleId;
        return $this;
    }


    /**
     * @return float|null
     */
    public function getFilterByPriceMin(): ?float
    {
        return $this->filterByPriceMin;
    }

    /**
     * @param float|null $filterByPriceMin
     * @return ProductCriteria
     */
    public function setFilterByPriceMin(?float $filterByPriceMin): ProductCriteria
    {
        $this->filterByPriceMin = $filterByPriceMin;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getFilterByPriceMax(): ?float
    {
        return $this->filterByPriceMax;
    }

    /**
     * @param float|null $filterByPriceMax
     * @return ProductCriteria
     */
    public function setFilterByPriceMax(?float $filterByPriceMax): ProductCriteria
    {
        $this->filterByPriceMax = $filterByPriceMax;
        return $this;
    }



    /**
     * @return array|null
     */
    public function getFilterBySizeValues(): ?array
    {
        return $this->filterBySizeValues;
    }

    /**
     * @param array|null $filterBySizeValues
     * @return ProductCriteria
     */
    public function setFilterBySizeValues(?array $filterBySizeValues): ProductCriteria
    {
        $this->filterBySizeValues = $filterBySizeValues;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterBySizeTypeIds(): ?array
    {
        return $this->filterBySizeTypeIds;
    }

    /**
     * @param array|null $filterBySizeTypeIds
     * @return ProductCriteria
     */
    public function setFilterBySizeTypeIds(?array $filterBySizeTypeIds): ProductCriteria
    {
        $this->filterBySizeTypeIds = $filterBySizeTypeIds;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterByGroupIds(): ?array
    {
        return $this->filterByGroupIds;
    }

    /**
     * @param array|null $filterByGroupIds
     * @return ProductCriteria
     */
    public function setFilterByGroupIds(?array $filterByGroupIds): ProductCriteria
    {
        $this->filterByGroupIds = $filterByGroupIds;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterByBrandIds(): ?array
    {
        return $this->filterByBrandIds;
    }

    /**
     * @param array|null $filterByBrandIds
     * @return ProductCriteria
     */
    public function setFilterByBrandIds(?array $filterByBrandIds): ProductCriteria
    {
        $this->filterByBrandIds = $filterByBrandIds;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getFilterByName(): ?string
    {
        return $this->filterByName;
    }

    /**
     * @param string|null $filterByName
     * @return ProductCriteria
     */
    public function setFilterByName(?string $filterByName): ProductCriteria
    {
        $this->filterByName = $filterByName;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterByIgnoreCategories(): ?array
    {
        return $this->filterByIgnoreCategories;
    }

    /**
     * @param array|null $filterByIgnoreCategories
     * @return ProductCriteria
     */
    public function setFilterByIgnoreCategories(?array $filterByIgnoreCategories): ProductCriteria
    {
        $this->filterByIgnoreCategories = $filterByIgnoreCategories;
        return $this;
    }



    /**
     * @return string|null
     */
    public function getSearchByBrand(): ?string
    {
        return $this->searchByBrand;
    }

    /**
     * @param string|null $searchByBrand
     * @return ProductCriteria
     */
    public function setSearchByBrand(?string $searchByBrand): ProductCriteria
    {
        $this->searchByBrand = $searchByBrand;
        return $this;
    }


    /**
     * @return mixed
     */
    public function getSearchByArticle(): ?string
    {
        return $this->searchByArticle;
    }

    /**
     * @param mixed $searchByArticle
     * @return ProductCriteria
     */
    public function setSearchByArticle(?string $searchByArticle): self
    {
        $this->searchByArticle = $searchByArticle;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterByWeights(): ?array
    {
        return $this->filterByweights;
    }

    /**
     * @param array|null $filterByWeights
     * @return ProductCriteria
     */
    public function setFilterByWeights(?array $filterByWeights): ProductCriteria
    {
        $this->filterByweights = $filterByWeights;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSortedByPrice(): ?string
    {
        return $this->sortedByPrice;
    }

    /**
     * @param string|null $sortedByPrice
     * @return ProductCriteria
     */
    public function setSortedByPrice(?string $sortedByPrice): ProductCriteria
    {
        $this->sortedByPrice = $sortedByPrice;
        return $this;
    }


    /**
     * @return \DateTime
     */
    public function getFilterByDateUpdate(): ?\DateTime
    {
        return $this->filterByDateUpdate;
    }

    /**
     * @param \DateTime $filterByDateUpdate
     * @return ProductCriteria
     */
    public function setFilterByDateUpdate(\DateTime $filterByDateUpdate): ProductCriteria
    {
        $this->filterByDateUpdate = $filterByDateUpdate;
        return $this;
    }


    /**
     * @return bool
     */
    public function getFilterByActive(): ?bool
    {
        return $this->filterByActive;
    }

    /**
     * @param bool $filterByActive
     * @return ProductCriteria
     */
    public function setFilterByActive(?bool $filterByActive): ProductCriteria
    {
        $this->filterByActive = $filterByActive;
        return $this;
    }


    /**
     * @return bool
     */
    public function getFilterBySpecial(): ?bool
    {
        return $this->filterBySpecial;
    }

    /**
     * @param bool $filterBySpecial
     * @return ProductCriteria
     */
    public function setFilterBySpecial(?bool $filterBySpecial): ProductCriteria
    {
        $this->filterBySpecial = $filterBySpecial;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSortedByDateUpdate(): ?string
    {
        return $this->sortedByDateUpdate;
    }

    /**
     * @param string|null $sortedByDateUpdate
     * @return ProductCriteria
     */
    public function setSortedByDateUpdate(?string $sortedByDateUpdate): ProductCriteria
    {
        $this->sortedByDateUpdate = $sortedByDateUpdate;
        return $this;
    }


    /**
     * @return array
     */
    public function getFilterByBrandNames():?array
    {
        return $this->filterByBrandNames;
    }

    /**
     * @param array $filterByBrandNames
     * @return ProductCriteria
     */
    public function setFilterByBrandNames(?array $filterByBrandNames)
    {
        $this->filterByBrandNames = $filterByBrandNames;
        return $this;
    }


    function getFilterByNewGoodDays(): ?bool
    {
        return $this->filterByNewGoodDays;
    }

    function setFilterByNewGoodDays(?bool $filterByNewGoodDays)
    {
        $this->filterByNewGoodDays = $filterByNewGoodDays;
        return $this;
    }


    function getNewGoodDays()
    {
        return $this->newGoodDays;
    }

    function setNewGoodDays($newGoodDays)
    {
        $this->newGoodDays = $newGoodDays;
        return $this;
    }

    function getSortedByDateCreate()
    {
        return $this->sortedByDateCreate;
    }

    function setSortedByDateCreate($sortedByDateCreate)
    {
        $this->sortedByDateCreate = $sortedByDateCreate;
        return $this;
    }


    function getSearchByTitle(): ?string
    {
        return $this->searchByTitle;
    }

    function setSearchByTitle(?string $searchByName): self
    {
        $this->searchByTitle = $searchByName;
        return $this;
    }

    function getFilterByDateCreate()
    {
        return $this->filterByDateCreate;
    }

    function setFilterByDateCreate($filterByDateCreate)
    {
        $this->filterByDateCreate = $filterByDateCreate;
        return $this;
    }


    public function getSortedRandom(): ?bool
    {
        return $this->sortedRandom;
    }

    public function setSortedRandom(?bool $useRandomSort)
    {
        $this->sortedRandom = $useRandomSort;
        return $this;
    }

    public function getFilterByRemains(): ?bool
    {
        return $this->filterByRemains;
    }

    public function setFilterByRemains(?bool $filterByRemains)
    {
        $this->filterByRemains = $filterByRemains;
        return $this;
    }

    public function getFilterByPopular(): ?bool
    {
        return $this->filterByPopular;
    }

    public function setFilterByPopular(?bool $filterByPopular)
    {
        $this->filterByPopular = $filterByPopular;
        return $this;
    }


    public function getFilterByPriceListScheetIds(): ?array
    {

        return $this->filterByPriceListScheetIds;
    }

    public function setFilterByPriceListScheetIds(?array $filter)
    {

        $this->filterByPriceListScheetIds = $filter;

        return $this;
    }

    public function getFilterByImageExist(): ?bool
    {

        return $this->filterByImageExist;
    }

    public function setFilterByImageExist(bool $filter)
    {

        $this->filterByImageExist = $filter;

        return $this;
    }


    function getFilterByCategoryId():?int
    {
        return $this->filterByCategoryId;
    }

    function getFilterByBrandId():?int
    {
        return $this->filterByBrandId;
    }


    function setFilterByCategoryId(?int $filterByCategoryId)
    {
        $this->filterByCategoryId = $filterByCategoryId;
        return $this;
    }

    function setFilterByBrandId(?int $filterByBrandId)
    {
        $this->filterByBrandId = $filterByBrandId;
        return $this;
    }

    /**
     * @return ProductCriteria
     */
    public static function create()
    {
        return new self;
    }
}