<?php

namespace Shop\Infrastructure\Models\Provider\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Provider\Provider;
use Shop\Infrastructure\Models\Provider\ProviderQuery;


/**
 * This class defines the structure of the 'shop_providers' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class ProviderTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.Provider.Map.ProviderTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'shop_providers';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Shop\\Models\\Provider\\Provider';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.Provider.Provider';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 10;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 10;

    /**
     * the column name for the id field
     */
    const COL_ID = 'shop_providers.id';

    /**
     * the column name for the name field
     */
    const COL_NAME = 'shop_providers.name';

    /**
     * the column name for the term field
     */
    const COL_TERM = 'shop_providers.term';

    /**
     * the column name for the desc field
     */
    const COL_DESC = 'shop_providers.desc';

    /**
     * the column name for the contact field
     */
    const COL_CONTACT = 'shop_providers.contact';

    /**
     * the column name for the destination field
     */
    const COL_DESTINATION = 'shop_providers.destination';

    /**
     * the column name for the color field
     */
    const COL_COLOR = 'shop_providers.color';

    /**
     * the column name for the shop_id field
     */
    const COL_SHOP_ID = 'shop_providers.shop_id';

    /**
     * the column name for the crrency_id field
     */
    const COL_CRRENCY_ID = 'shop_providers.crrency_id';

    /**
     * the column name for the contractor_id field
     */
    const COL_CONTRACTOR_ID = 'shop_providers.contractor_id';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'Name', 'Term', 'Desc', 'Contact', 'Destination', 'Color', 'ShopId', 'CurrencyId', 'ContractorId', ),
        self::TYPE_CAMELNAME     => array('id', 'name', 'term', 'desc', 'contact', 'destination', 'color', 'shopId', 'currencyId', 'contractorId', ),
        self::TYPE_COLNAME       => array(ProviderTableMap::COL_ID, ProviderTableMap::COL_NAME, ProviderTableMap::COL_TERM, ProviderTableMap::COL_DESC, ProviderTableMap::COL_CONTACT, ProviderTableMap::COL_DESTINATION, ProviderTableMap::COL_COLOR, ProviderTableMap::COL_SHOP_ID, ProviderTableMap::COL_CRRENCY_ID, ProviderTableMap::COL_CONTRACTOR_ID, ),
        self::TYPE_FIELDNAME     => array('id', 'name', 'term', 'desc', 'contact', 'destination', 'color', 'shop_id', 'crrency_id', 'contractor_id', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'Name' => 1, 'Term' => 2, 'Desc' => 3, 'Contact' => 4, 'Destination' => 5, 'Color' => 6, 'ShopId' => 7, 'CurrencyId' => 8, 'ContractorId' => 9, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'name' => 1, 'term' => 2, 'desc' => 3, 'contact' => 4, 'destination' => 5, 'color' => 6, 'shopId' => 7, 'currencyId' => 8, 'contractorId' => 9, ),
        self::TYPE_COLNAME       => array(ProviderTableMap::COL_ID => 0, ProviderTableMap::COL_NAME => 1, ProviderTableMap::COL_TERM => 2, ProviderTableMap::COL_DESC => 3, ProviderTableMap::COL_CONTACT => 4, ProviderTableMap::COL_DESTINATION => 5, ProviderTableMap::COL_COLOR => 6, ProviderTableMap::COL_SHOP_ID => 7, ProviderTableMap::COL_CRRENCY_ID => 8, ProviderTableMap::COL_CONTRACTOR_ID => 9, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'name' => 1, 'term' => 2, 'desc' => 3, 'contact' => 4, 'destination' => 5, 'color' => 6, 'shop_id' => 7, 'crrency_id' => 8, 'contractor_id' => 9, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('shop_providers');
        $this->setPhpName('Provider');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Models\\Provider\\Provider');
        $this->setPackage('Models.Provider');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('name', 'Name', 'VARCHAR', false, 255, null);
        $this->addColumn('term', 'Term', 'INTEGER', true, null, null);
        $this->addColumn('desc', 'Desc', 'LONGVARCHAR', false, null, null);
        $this->addColumn('contact', 'Contact', 'VARCHAR', false, 255, null);
        $this->addColumn('destination', 'Destination', 'VARCHAR', false, 255, null);
        $this->addColumn('color', 'Color', 'CHAR', false, 10, null);
        $this->addColumn('shop_id', 'ShopId', 'INTEGER', true, null, null);
        $this->addForeignKey('crrency_id', 'CurrencyId', 'INTEGER', 'shop_currencies', 'id', true, null, null);
        $this->addForeignKey('contractor_id', 'ContractorId', 'INTEGER', 'shop_customer', 'id', true, null, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Currency', '\\Shop\\Models\\Currency\\Currency', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':crrency_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Contractor', '\\Shop\\Models\\Customer\\Customer', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':contractor_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('OrderItem', '\\Shop\\Models\\OrderItem\\OrderItem', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':provider_id',
    1 => ':id',
  ),
), null, null, 'OrderItems', false);
        $this->addRelation('PricelistFile', '\\Shop\\Models\\PricelistFile\\PricelistFile', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':provider_id',
    1 => ':id',
  ),
), null, null, 'PricelistFiles', false);
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'archivable' => array('archive_table' => '', 'archive_phpname' => '', 'archive_class' => '', 'log_archived_at' => 'true', 'archived_at_column' => 'archived_at', 'archive_on_insert' => 'false', 'archive_on_update' => 'false', 'archive_on_delete' => 'true', ),
        );
    } // getBehaviors()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? ProviderTableMap::CLASS_DEFAULT : ProviderTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (Provider object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = ProviderTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = ProviderTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + ProviderTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ProviderTableMap::OM_CLASS;
            /** @var Provider $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            ProviderTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = ProviderTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = ProviderTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Provider $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ProviderTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ProviderTableMap::COL_ID);
            $criteria->addSelectColumn(ProviderTableMap::COL_NAME);
            $criteria->addSelectColumn(ProviderTableMap::COL_TERM);
            $criteria->addSelectColumn(ProviderTableMap::COL_DESC);
            $criteria->addSelectColumn(ProviderTableMap::COL_CONTACT);
            $criteria->addSelectColumn(ProviderTableMap::COL_DESTINATION);
            $criteria->addSelectColumn(ProviderTableMap::COL_COLOR);
            $criteria->addSelectColumn(ProviderTableMap::COL_SHOP_ID);
            $criteria->addSelectColumn(ProviderTableMap::COL_CRRENCY_ID);
            $criteria->addSelectColumn(ProviderTableMap::COL_CONTRACTOR_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.name');
            $criteria->addSelectColumn($alias . '.term');
            $criteria->addSelectColumn($alias . '.desc');
            $criteria->addSelectColumn($alias . '.contact');
            $criteria->addSelectColumn($alias . '.destination');
            $criteria->addSelectColumn($alias . '.color');
            $criteria->addSelectColumn($alias . '.shop_id');
            $criteria->addSelectColumn($alias . '.crrency_id');
            $criteria->addSelectColumn($alias . '.contractor_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(ProviderTableMap::DATABASE_NAME)->getTable(ProviderTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(ProviderTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(ProviderTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new ProviderTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a Provider or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or Provider object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProviderTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\Provider\Provider) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ProviderTableMap::DATABASE_NAME);
            $criteria->add(ProviderTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = ProviderQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            ProviderTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                ProviderTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_providers table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return ProviderQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Provider or Criteria object.
     *
     * @param mixed               $criteria Criteria or Provider object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProviderTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Provider object
        }

        if ($criteria->containsKey(ProviderTableMap::COL_ID) && $criteria->keyContainsValue(ProviderTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ProviderTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = ProviderQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // ProviderTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
ProviderTableMap::buildTableMap();
