<?php

namespace Shop\Infrastructure\Models\Position\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Position\Position as ChildPosition;
use Shop\Infrastructure\Models\Position\PositionQuery as ChildPositionQuery;
use Shop\Infrastructure\Models\Position\Map\PositionTableMap;
use Shop\Infrastructure\Models\PricelistSheet\PricelistSheet;
use Shop\Infrastructure\Models\Product\Product;
use Shop\Infrastructure\Models\Sale\Sale;
use Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSize;

/**
 * Base class that represents a query for the 'shop_positions' table.
 *
 *
 *
 * @method     ChildPositionQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildPositionQuery orderByDesc($order = Criteria::ASC) Order by the desc column
 * @method     ChildPositionQuery orderByRemain($order = Criteria::ASC) Order by the remain column
 * @method     ChildPositionQuery orderByPrice($order = Criteria::ASC) Order by the price column
 * @method     ChildPositionQuery orderByPriceOld($order = Criteria::ASC) Order by the price_old column
 * @method     ChildPositionQuery orderByDestination($order = Criteria::ASC) Order by the destination column
 * @method     ChildPositionQuery orderBySaleId($order = Criteria::ASC) Order by the sale_id column
 * @method     ChildPositionQuery orderByImage($order = Criteria::ASC) Order by the image column
 * @method     ChildPositionQuery orderByProductId($order = Criteria::ASC) Order by the product_id column
 * @method     ChildPositionQuery orderByPricelistSheetId($order = Criteria::ASC) Order by the pricelist_sheet_id column
 * @method     ChildPositionQuery orderByRefId($order = Criteria::ASC) Order by the ref_id column
 *
 * @method     ChildPositionQuery groupById() Group by the id column
 * @method     ChildPositionQuery groupByDesc() Group by the desc column
 * @method     ChildPositionQuery groupByRemain() Group by the remain column
 * @method     ChildPositionQuery groupByPrice() Group by the price column
 * @method     ChildPositionQuery groupByPriceOld() Group by the price_old column
 * @method     ChildPositionQuery groupByDestination() Group by the destination column
 * @method     ChildPositionQuery groupBySaleId() Group by the sale_id column
 * @method     ChildPositionQuery groupByImage() Group by the image column
 * @method     ChildPositionQuery groupByProductId() Group by the product_id column
 * @method     ChildPositionQuery groupByPricelistSheetId() Group by the pricelist_sheet_id column
 * @method     ChildPositionQuery groupByRefId() Group by the ref_id column
 *
 * @method     ChildPositionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildPositionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildPositionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildPositionQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildPositionQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildPositionQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildPositionQuery leftJoinSale($relationAlias = null) Adds a LEFT JOIN clause to the query using the Sale relation
 * @method     ChildPositionQuery rightJoinSale($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Sale relation
 * @method     ChildPositionQuery innerJoinSale($relationAlias = null) Adds a INNER JOIN clause to the query using the Sale relation
 *
 * @method     ChildPositionQuery joinWithSale($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Sale relation
 *
 * @method     ChildPositionQuery leftJoinWithSale() Adds a LEFT JOIN clause and with to the query using the Sale relation
 * @method     ChildPositionQuery rightJoinWithSale() Adds a RIGHT JOIN clause and with to the query using the Sale relation
 * @method     ChildPositionQuery innerJoinWithSale() Adds a INNER JOIN clause and with to the query using the Sale relation
 *
 * @method     ChildPositionQuery leftJoinProduct($relationAlias = null) Adds a LEFT JOIN clause to the query using the Product relation
 * @method     ChildPositionQuery rightJoinProduct($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Product relation
 * @method     ChildPositionQuery innerJoinProduct($relationAlias = null) Adds a INNER JOIN clause to the query using the Product relation
 *
 * @method     ChildPositionQuery joinWithProduct($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Product relation
 *
 * @method     ChildPositionQuery leftJoinWithProduct() Adds a LEFT JOIN clause and with to the query using the Product relation
 * @method     ChildPositionQuery rightJoinWithProduct() Adds a RIGHT JOIN clause and with to the query using the Product relation
 * @method     ChildPositionQuery innerJoinWithProduct() Adds a INNER JOIN clause and with to the query using the Product relation
 *
 * @method     ChildPositionQuery leftJoinPricelistSheet($relationAlias = null) Adds a LEFT JOIN clause to the query using the PricelistSheet relation
 * @method     ChildPositionQuery rightJoinPricelistSheet($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PricelistSheet relation
 * @method     ChildPositionQuery innerJoinPricelistSheet($relationAlias = null) Adds a INNER JOIN clause to the query using the PricelistSheet relation
 *
 * @method     ChildPositionQuery joinWithPricelistSheet($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the PricelistSheet relation
 *
 * @method     ChildPositionQuery leftJoinWithPricelistSheet() Adds a LEFT JOIN clause and with to the query using the PricelistSheet relation
 * @method     ChildPositionQuery rightJoinWithPricelistSheet() Adds a RIGHT JOIN clause and with to the query using the PricelistSheet relation
 * @method     ChildPositionQuery innerJoinWithPricelistSheet() Adds a INNER JOIN clause and with to the query using the PricelistSheet relation
 *
 * @method     ChildPositionQuery leftJoinShopPositionSize($relationAlias = null) Adds a LEFT JOIN clause to the query using the ShopPositionSize relation
 * @method     ChildPositionQuery rightJoinShopPositionSize($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ShopPositionSize relation
 * @method     ChildPositionQuery innerJoinShopPositionSize($relationAlias = null) Adds a INNER JOIN clause to the query using the ShopPositionSize relation
 *
 * @method     ChildPositionQuery joinWithShopPositionSize($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ShopPositionSize relation
 *
 * @method     ChildPositionQuery leftJoinWithShopPositionSize() Adds a LEFT JOIN clause and with to the query using the ShopPositionSize relation
 * @method     ChildPositionQuery rightJoinWithShopPositionSize() Adds a RIGHT JOIN clause and with to the query using the ShopPositionSize relation
 * @method     ChildPositionQuery innerJoinWithShopPositionSize() Adds a INNER JOIN clause and with to the query using the ShopPositionSize relation
 *
 * @method     \Shop\Infrastructure\Models\Sale\SaleQuery|\Shop\Infrastructure\Models\Product\ProductQuery|\Shop\Infrastructure\Models\PricelistSheet\PricelistSheetQuery|\Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSizeQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildPosition findOne(ConnectionInterface $con = null) Return the first ChildPosition matching the query
 * @method     ChildPosition findOneOrCreate(ConnectionInterface $con = null) Return the first ChildPosition matching the query, or a new ChildPosition object populated from the query conditions when no match is found
 *
 * @method     ChildPosition findOneById(int $id) Return the first ChildPosition filtered by the id column
 * @method     ChildPosition findOneByDesc(string $desc) Return the first ChildPosition filtered by the desc column
 * @method     ChildPosition findOneByRemain(int $remain) Return the first ChildPosition filtered by the remain column
 * @method     ChildPosition findOneByPrice(string $price) Return the first ChildPosition filtered by the price column
 * @method     ChildPosition findOneByPriceOld(string $price_old) Return the first ChildPosition filtered by the price_old column
 * @method     ChildPosition findOneByDestination(string $destination) Return the first ChildPosition filtered by the destination column
 * @method     ChildPosition findOneBySaleId(int $sale_id) Return the first ChildPosition filtered by the sale_id column
 * @method     ChildPosition findOneByImage(string $image) Return the first ChildPosition filtered by the image column
 * @method     ChildPosition findOneByProductId(int $product_id) Return the first ChildPosition filtered by the product_id column
 * @method     ChildPosition findOneByPricelistSheetId(int $pricelist_sheet_id) Return the first ChildPosition filtered by the pricelist_sheet_id column
 * @method     ChildPosition findOneByRefId(string $ref_id) Return the first ChildPosition filtered by the ref_id column *

 * @method     ChildPosition requirePk($key, ConnectionInterface $con = null) Return the ChildPosition by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPosition requireOne(ConnectionInterface $con = null) Return the first ChildPosition matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPosition requireOneById(int $id) Return the first ChildPosition filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPosition requireOneByDesc(string $desc) Return the first ChildPosition filtered by the desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPosition requireOneByRemain(int $remain) Return the first ChildPosition filtered by the remain column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPosition requireOneByPrice(string $price) Return the first ChildPosition filtered by the price column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPosition requireOneByPriceOld(string $price_old) Return the first ChildPosition filtered by the price_old column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPosition requireOneByDestination(string $destination) Return the first ChildPosition filtered by the destination column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPosition requireOneBySaleId(int $sale_id) Return the first ChildPosition filtered by the sale_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPosition requireOneByImage(string $image) Return the first ChildPosition filtered by the image column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPosition requireOneByProductId(int $product_id) Return the first ChildPosition filtered by the product_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPosition requireOneByPricelistSheetId(int $pricelist_sheet_id) Return the first ChildPosition filtered by the pricelist_sheet_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPosition requireOneByRefId(string $ref_id) Return the first ChildPosition filtered by the ref_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPosition[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildPosition objects based on current ModelCriteria
 * @method     ChildPosition[]|ObjectCollection findById(int $id) Return ChildPosition objects filtered by the id column
 * @method     ChildPosition[]|ObjectCollection findByDesc(string $desc) Return ChildPosition objects filtered by the desc column
 * @method     ChildPosition[]|ObjectCollection findByRemain(int $remain) Return ChildPosition objects filtered by the remain column
 * @method     ChildPosition[]|ObjectCollection findByPrice(string $price) Return ChildPosition objects filtered by the price column
 * @method     ChildPosition[]|ObjectCollection findByPriceOld(string $price_old) Return ChildPosition objects filtered by the price_old column
 * @method     ChildPosition[]|ObjectCollection findByDestination(string $destination) Return ChildPosition objects filtered by the destination column
 * @method     ChildPosition[]|ObjectCollection findBySaleId(int $sale_id) Return ChildPosition objects filtered by the sale_id column
 * @method     ChildPosition[]|ObjectCollection findByImage(string $image) Return ChildPosition objects filtered by the image column
 * @method     ChildPosition[]|ObjectCollection findByProductId(int $product_id) Return ChildPosition objects filtered by the product_id column
 * @method     ChildPosition[]|ObjectCollection findByPricelistSheetId(int $pricelist_sheet_id) Return ChildPosition objects filtered by the pricelist_sheet_id column
 * @method     ChildPosition[]|ObjectCollection findByRefId(string $ref_id) Return ChildPosition objects filtered by the ref_id column
 * @method     ChildPosition[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class PositionQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\Position\Base\PositionQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\Position\\Position', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildPositionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildPositionQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildPositionQuery) {
            return $criteria;
        }
        $query = new ChildPositionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildPosition|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(PositionTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = PositionTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPosition A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `desc`, `remain`, `price`, `price_old`, `destination`, `sale_id`, `image`, `product_id`, `pricelist_sheet_id`, `ref_id` FROM `shop_positions` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildPosition $obj */
            $obj = new ChildPosition();
            $obj->hydrate($row);
            PositionTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildPosition|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(PositionTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(PositionTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(PositionTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(PositionTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the desc column
     *
     * Example usage:
     * <code>
     * $query->filterByDesc('fooValue');   // WHERE desc = 'fooValue'
     * $query->filterByDesc('%fooValue%', Criteria::LIKE); // WHERE desc LIKE '%fooValue%'
     * </code>
     *
     * @param     string $desc The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function filterByDesc($desc = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($desc)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTableMap::COL_DESC, $desc, $comparison);
    }

    /**
     * Filter the query on the remain column
     *
     * Example usage:
     * <code>
     * $query->filterByRemain(1234); // WHERE remain = 1234
     * $query->filterByRemain(array(12, 34)); // WHERE remain IN (12, 34)
     * $query->filterByRemain(array('min' => 12)); // WHERE remain > 12
     * </code>
     *
     * @param     mixed $remain The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function filterByRemain($remain = null, $comparison = null)
    {
        if (is_array($remain)) {
            $useMinMax = false;
            if (isset($remain['min'])) {
                $this->addUsingAlias(PositionTableMap::COL_REMAIN, $remain['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($remain['max'])) {
                $this->addUsingAlias(PositionTableMap::COL_REMAIN, $remain['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTableMap::COL_REMAIN, $remain, $comparison);
    }

    /**
     * Filter the query on the price column
     *
     * Example usage:
     * <code>
     * $query->filterByPrice(1234); // WHERE price = 1234
     * $query->filterByPrice(array(12, 34)); // WHERE price IN (12, 34)
     * $query->filterByPrice(array('min' => 12)); // WHERE price > 12
     * </code>
     *
     * @param     mixed $price The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function filterByPrice($price = null, $comparison = null)
    {
        if (is_array($price)) {
            $useMinMax = false;
            if (isset($price['min'])) {
                $this->addUsingAlias(PositionTableMap::COL_PRICE, $price['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($price['max'])) {
                $this->addUsingAlias(PositionTableMap::COL_PRICE, $price['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTableMap::COL_PRICE, $price, $comparison);
    }

    /**
     * Filter the query on the price_old column
     *
     * Example usage:
     * <code>
     * $query->filterByPriceOld(1234); // WHERE price_old = 1234
     * $query->filterByPriceOld(array(12, 34)); // WHERE price_old IN (12, 34)
     * $query->filterByPriceOld(array('min' => 12)); // WHERE price_old > 12
     * </code>
     *
     * @param     mixed $priceOld The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function filterByPriceOld($priceOld = null, $comparison = null)
    {
        if (is_array($priceOld)) {
            $useMinMax = false;
            if (isset($priceOld['min'])) {
                $this->addUsingAlias(PositionTableMap::COL_PRICE_OLD, $priceOld['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($priceOld['max'])) {
                $this->addUsingAlias(PositionTableMap::COL_PRICE_OLD, $priceOld['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTableMap::COL_PRICE_OLD, $priceOld, $comparison);
    }

    /**
     * Filter the query on the destination column
     *
     * Example usage:
     * <code>
     * $query->filterByDestination('fooValue');   // WHERE destination = 'fooValue'
     * $query->filterByDestination('%fooValue%', Criteria::LIKE); // WHERE destination LIKE '%fooValue%'
     * </code>
     *
     * @param     string $destination The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function filterByDestination($destination = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($destination)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTableMap::COL_DESTINATION, $destination, $comparison);
    }

    /**
     * Filter the query on the sale_id column
     *
     * Example usage:
     * <code>
     * $query->filterBySaleId(1234); // WHERE sale_id = 1234
     * $query->filterBySaleId(array(12, 34)); // WHERE sale_id IN (12, 34)
     * $query->filterBySaleId(array('min' => 12)); // WHERE sale_id > 12
     * </code>
     *
     * @see       filterBySale()
     *
     * @param     mixed $saleId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function filterBySaleId($saleId = null, $comparison = null)
    {
        if (is_array($saleId)) {
            $useMinMax = false;
            if (isset($saleId['min'])) {
                $this->addUsingAlias(PositionTableMap::COL_SALE_ID, $saleId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($saleId['max'])) {
                $this->addUsingAlias(PositionTableMap::COL_SALE_ID, $saleId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTableMap::COL_SALE_ID, $saleId, $comparison);
    }

    /**
     * Filter the query on the image column
     *
     * Example usage:
     * <code>
     * $query->filterByImage('fooValue');   // WHERE image = 'fooValue'
     * $query->filterByImage('%fooValue%', Criteria::LIKE); // WHERE image LIKE '%fooValue%'
     * </code>
     *
     * @param     string $image The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function filterByImage($image = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($image)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTableMap::COL_IMAGE, $image, $comparison);
    }

    /**
     * Filter the query on the product_id column
     *
     * Example usage:
     * <code>
     * $query->filterByProductId(1234); // WHERE product_id = 1234
     * $query->filterByProductId(array(12, 34)); // WHERE product_id IN (12, 34)
     * $query->filterByProductId(array('min' => 12)); // WHERE product_id > 12
     * </code>
     *
     * @see       filterByProduct()
     *
     * @param     mixed $productId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function filterByProductId($productId = null, $comparison = null)
    {
        if (is_array($productId)) {
            $useMinMax = false;
            if (isset($productId['min'])) {
                $this->addUsingAlias(PositionTableMap::COL_PRODUCT_ID, $productId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($productId['max'])) {
                $this->addUsingAlias(PositionTableMap::COL_PRODUCT_ID, $productId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTableMap::COL_PRODUCT_ID, $productId, $comparison);
    }

    /**
     * Filter the query on the pricelist_sheet_id column
     *
     * Example usage:
     * <code>
     * $query->filterByPricelistSheetId(1234); // WHERE pricelist_sheet_id = 1234
     * $query->filterByPricelistSheetId(array(12, 34)); // WHERE pricelist_sheet_id IN (12, 34)
     * $query->filterByPricelistSheetId(array('min' => 12)); // WHERE pricelist_sheet_id > 12
     * </code>
     *
     * @see       filterByPricelistSheet()
     *
     * @param     mixed $pricelistSheetId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function filterByPricelistSheetId($pricelistSheetId = null, $comparison = null)
    {
        if (is_array($pricelistSheetId)) {
            $useMinMax = false;
            if (isset($pricelistSheetId['min'])) {
                $this->addUsingAlias(PositionTableMap::COL_PRICELIST_SHEET_ID, $pricelistSheetId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($pricelistSheetId['max'])) {
                $this->addUsingAlias(PositionTableMap::COL_PRICELIST_SHEET_ID, $pricelistSheetId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTableMap::COL_PRICELIST_SHEET_ID, $pricelistSheetId, $comparison);
    }

    /**
     * Filter the query on the ref_id column
     *
     * Example usage:
     * <code>
     * $query->filterByRefId('fooValue');   // WHERE ref_id = 'fooValue'
     * $query->filterByRefId('%fooValue%', Criteria::LIKE); // WHERE ref_id LIKE '%fooValue%'
     * </code>
     *
     * @param     string $refId The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function filterByRefId($refId = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($refId)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTableMap::COL_REF_ID, $refId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Sale\Sale object
     *
     * @param \Shop\Infrastructure\Models\Sale\Sale|ObjectCollection $sale The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPositionQuery The current query, for fluid interface
     */
    public function filterBySale($sale, $comparison = null)
    {
        if ($sale instanceof \Shop\Infrastructure\Models\Sale\Sale) {
            return $this
                ->addUsingAlias(PositionTableMap::COL_SALE_ID, $sale->getId(), $comparison);
        } elseif ($sale instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(PositionTableMap::COL_SALE_ID, $sale->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterBySale() only accepts arguments of type \Shop\Infrastructure\Models\Sale\Sale or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Sale relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function joinSale($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Sale');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Sale');
        }

        return $this;
    }

    /**
     * Use the Sale relation Sale object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Sale\SaleQuery A secondary query class using the current class as primary query
     */
    public function useSaleQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinSale($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Sale', '\Shop\Infrastructure\Models\Sale\SaleQuery');
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Product\Product object
     *
     * @param \Shop\Infrastructure\Models\Product\Product|ObjectCollection $product The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPositionQuery The current query, for fluid interface
     */
    public function filterByProduct($product, $comparison = null)
    {
        if ($product instanceof \Shop\Infrastructure\Models\Product\Product) {
            return $this
                ->addUsingAlias(PositionTableMap::COL_PRODUCT_ID, $product->getId(), $comparison);
        } elseif ($product instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(PositionTableMap::COL_PRODUCT_ID, $product->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProduct() only accepts arguments of type \Shop\Infrastructure\Models\Product\Product or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Product relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function joinProduct($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Product');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Product');
        }

        return $this;
    }

    /**
     * Use the Product relation Product object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Product\ProductQuery A secondary query class using the current class as primary query
     */
    public function useProductQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProduct($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Product', '\Shop\Infrastructure\Models\Product\ProductQuery');
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\PricelistSheet\PricelistSheet object
     *
     * @param \Shop\Infrastructure\Models\PricelistSheet\PricelistSheet|ObjectCollection $pricelistSheet The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPositionQuery The current query, for fluid interface
     */
    public function filterByPricelistSheet($pricelistSheet, $comparison = null)
    {
        if ($pricelistSheet instanceof \Shop\Infrastructure\Models\PricelistSheet\PricelistSheet) {
            return $this
                ->addUsingAlias(PositionTableMap::COL_PRICELIST_SHEET_ID, $pricelistSheet->getId(), $comparison);
        } elseif ($pricelistSheet instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(PositionTableMap::COL_PRICELIST_SHEET_ID, $pricelistSheet->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPricelistSheet() only accepts arguments of type \Shop\Infrastructure\Models\PricelistSheet\PricelistSheet or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PricelistSheet relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function joinPricelistSheet($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PricelistSheet');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PricelistSheet');
        }

        return $this;
    }

    /**
     * Use the PricelistSheet relation PricelistSheet object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\PricelistSheet\PricelistSheetQuery A secondary query class using the current class as primary query
     */
    public function usePricelistSheetQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPricelistSheet($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PricelistSheet', '\Shop\Infrastructure\Models\PricelistSheet\PricelistSheetQuery');
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSize object
     *
     * @param \Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSize|ObjectCollection $shopPositionSize the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildPositionQuery The current query, for fluid interface
     */
    public function filterByShopPositionSize($shopPositionSize, $comparison = null)
    {
        if ($shopPositionSize instanceof \Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSize) {
            return $this
                ->addUsingAlias(PositionTableMap::COL_ID, $shopPositionSize->getPositionId(), $comparison);
        } elseif ($shopPositionSize instanceof ObjectCollection) {
            return $this
                ->useShopPositionSizeQuery()
                ->filterByPrimaryKeys($shopPositionSize->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByShopPositionSize() only accepts arguments of type \Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSize or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ShopPositionSize relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function joinShopPositionSize($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ShopPositionSize');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ShopPositionSize');
        }

        return $this;
    }

    /**
     * Use the ShopPositionSize relation ShopPositionSize object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSizeQuery A secondary query class using the current class as primary query
     */
    public function useShopPositionSizeQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinShopPositionSize($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ShopPositionSize', '\Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSizeQuery');
    }

    /**
     * Filter the query by a related ShopPositionSizeType object
     * using the shop_position_sizes table as cross reference
     *
     * @param ShopPositionSizeType $shopPositionSizeType the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildPositionQuery The current query, for fluid interface
     */
    public function filterByShopPositionSizeType($shopPositionSizeType, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useShopPositionSizeQuery()
            ->filterByShopPositionSizeType($shopPositionSizeType, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   ChildPosition $position Object to remove from the list of results
     *
     * @return $this|ChildPositionQuery The current query, for fluid interface
     */
    public function prune($position = null)
    {
        if ($position) {
            $this->addUsingAlias(PositionTableMap::COL_ID, $position->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_positions table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PositionTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            PositionTableMap::clearInstancePool();
            PositionTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PositionTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(PositionTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            PositionTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            PositionTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // PositionQuery
